/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.models;

import com.altair.ks_engine.models.KSModelQuerySectionBuilder;
import com.altair.ks_engine.models.KSTreeModelColumnQuerySection;
import com.altair.ks_engine.parser.splitedit.KSContinuousSplitEdit;

public final class KSCasesQuerySectionBuilder
implements KSModelQuerySectionBuilder {
    private KSContinuousSplitEdit splitEdit;

    KSCasesQuerySectionBuilder() {
    }

    public KSCasesQuerySectionBuilder withContinuousSplit(KSContinuousSplitEdit splitEdit) {
        this.splitEdit = splitEdit;
        return this;
    }

    @Override
    public KSTreeModelColumnQuerySection build() {
        if (this.splitEdit == null) {
            throw new IllegalStateException("split edit must not be null");
        }
        String split = "[" + this.splitEdit.getSplitName() + "]";
        int rangeSize = this.splitEdit.getRanges().size();
        int index = 0;
        StringBuilder builder = new StringBuilder();
        for (KSContinuousSplitEdit.SplitRange range : this.splitEdit.getRanges()) {
            builder.append("WHEN (");
            if (range == null) {
                builder.append(split).append(" IS null");
            } else {
                if (range.getContainsMissing()) {
                    builder.append("(");
                }
                String from = range.getFrom();
                builder.append(split).append(">=");
                if (from.contains(":")) {
                    builder.append("{").append(from).append("}");
                } else {
                    builder.append(from.replace("Infinity", "{Inf}"));
                }
                builder.append(" AND ");
                boolean isLast = index == rangeSize - 1;
                builder.append(split).append(isLast ? "<=" : "<");
                String to = range.getTo();
                if (to.contains(":")) {
                    builder.append("{").append(to).append("}");
                } else {
                    builder.append(to.replace("Infinity", "{Inf}"));
                }
                if (range.getContainsMissing()) {
                    builder.append(") OR ").append(split).append(" IS null");
                }
            }
            builder.append(") THEN ").append(index).append(" ");
            ++index;
        }
        builder.append("ELSE ").append(index);
        return new KSTreeModelColumnQuerySection(builder.toString());
    }
}

