/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.models;

import com.altair.ks_engine.models.KSModelQuerySection;
import com.altair.ks_engine.models.KSModelQuerySectionBuilder;
import com.altair.ks_engine.models.KSSplitEditQuerySection;
import com.altair.ks_engine.parser.splitedit.KSContinuousSplitEdit;
import com.altair.ks_engine.parser.splitedit.KSNonContinuousSplitEdit;
import com.altair.ks_engine.parser.splitedit.KSSplitEdit;
import com.altair.ks_engine.util.KSEngineTools;
import com.rapidminer.tools.ValidationUtilV2;

public final class KSSplitEditQuerySectionBuilder
implements KSModelQuerySectionBuilder {
    private final KSSplitEdit splitEdit;

    KSSplitEditQuerySectionBuilder(KSSplitEdit splitEdit) {
        this.splitEdit = (KSSplitEdit)ValidationUtilV2.requireNonNull((Object)splitEdit, (String)"splitEdit");
    }

    @Override
    public KSModelQuerySection build() {
        if (this.splitEdit instanceof KSNonContinuousSplitEdit) {
            return this.createNonContinuous((KSNonContinuousSplitEdit)this.splitEdit);
        }
        return this.createContinuous((KSContinuousSplitEdit)this.splitEdit);
    }

    private KSModelQuerySection createContinuous(KSContinuousSplitEdit splitEdit) {
        if (!KSEngineTools.KS_VALUE_TYPES.contains(splitEdit.getContentType())) {
            throw new IllegalArgumentException("Illegal ks value type " + splitEdit.getContentType());
        }
        StringBuilder builder = new StringBuilder("<?xml version=\"1.0\"?><node forced=\"true\" preserve=\"true\">");
        builder.append("<split IV=\"").append(splitEdit.getSplitName()).append("\">");
        int rangeSize = splitEdit.getRanges().size();
        int index = 0;
        for (KSContinuousSplitEdit.SplitRange range : splitEdit.getRanges()) {
            ++index;
            if (range == null) {
                builder.append("<node><branch-values>");
                builder.append("<value type=\"missing\">Missing</value>");
                builder.append("</branch-values></node>");
                continue;
            }
            builder.append("<node><branch-values>");
            if (range.getContainsMissing()) {
                builder.append("<value type=\"missing\">Missing</value>");
            }
            builder.append("<value type=\"").append(splitEdit.getContentType()).append("\">");
            builder.append("<").append("closed").append(">");
            builder.append(range.getFrom());
            builder.append("</").append("closed").append(">");
            boolean isLast = index == rangeSize;
            builder.append("<").append(isLast ? "closed" : "open").append(">");
            builder.append(range.getTo());
            builder.append("</").append(isLast ? "closed" : "open").append(">");
            builder.append("</value></branch-values></node>");
        }
        builder.append("</split></node>");
        return new KSSplitEditQuerySection(builder.toString());
    }

    private KSModelQuerySection createNonContinuous(KSNonContinuousSplitEdit splitEdit) {
        StringBuilder builder = new StringBuilder("<?xml version=\"1.0\"?><node forced=\"true\" preserve=\"true\">");
        builder.append("<split IV=\"").append(splitEdit.getSplitName()).append("\">");
        for (KSNonContinuousSplitEdit.Group group : splitEdit.getGroups()) {
            if (group.getLabel() != null) {
                builder.append("<node><branch-values label=\"").append(KSEngineTools.escapeXMLForKS(group.getLabel())).append("\">");
            } else {
                builder.append("<node><branch-values>");
            }
            for (KSNonContinuousSplitEdit.CountedValue value : group.getValues()) {
                String type = value.getValue().getType().trim();
                if (!KSEngineTools.KS_VALUE_TYPES.contains(type)) {
                    throw new IllegalArgumentException("Illegal ks value type " + type);
                }
                builder.append("<value type=\"").append(type).append("\">").append(KSEngineTools.escapeXMLForKS(value.getValue().getValue())).append("</value>");
            }
            builder.append("</branch-values></node>");
        }
        builder.append("</split></node>");
        return new KSSplitEditQuerySection(builder.toString());
    }
}

