/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.models;

import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceInvalidNameException;
import com.altair.ks_engine.dto.ColumnCardinality;
import com.altair.ks_engine.models.KSModelColumnType;
import com.altair.ks_engine.models.KSModelQuerySectionBuilder;
import com.altair.ks_engine.models.KSTreeModelColumnQuerySection;
import com.altair.ks_engine.models.KSTreeModelSettings;
import com.altair.ks_engine.util.KSEngineTools;
import com.rapidminer.belt.column.Column;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.NumberTools;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public final class KSTreeModelColumnQuerySectionBuilder
implements KSModelQuerySectionBuilder {
    private static final String GENERIC_SETTINGS = "SIGNIFICANCE %s MAX BRANCHES %d BREAK %s";
    private static final String NOMINAL_SETTINGS = "DISCRETIZED (THRESHOLDS, %d) SET null AS %s DISPLAY %s";
    private static final String CONTINUOUS_SETTINGS = "DISCRETIZED (%s, %d) SET null AS %s FORMAT '' DISPLAY %s %s";
    private static final String ORDINAL_SETTINGS = "DISPLAY %s SET null AS %s FORMAT '' %s";
    private static final String DEPENDENT_VARIABLE_SETTINGS = "%s";
    private final Map<String, KSModelColumnType> columns = new LinkedHashMap<String, KSModelColumnType>();
    private final Map<String, ColumnCardinality> cardinality = new HashMap<String, ColumnCardinality>();
    private final Map<String, KSTreeModelSettings> settingsPerColumn = new HashMap<String, KSTreeModelSettings>();
    private final KSTreeModelSettings defaultSettings;

    KSTreeModelColumnQuerySectionBuilder(KSTreeModelSettings defaultSettings) {
        this.defaultSettings = defaultSettings;
    }

    public KSTreeModelColumnQuerySectionBuilder addColumn(ColumnCardinality column, boolean isTarget, KSTreeModelSettings columnSettings) throws KSEngineWorkspaceInvalidNameException {
        KSTreeModelSettings settingsForColumn;
        String colName = KSEngineTools.stripSquareBracketsAndValidateColumnName(column.getColumnName());
        KSTreeModelSettings kSTreeModelSettings = settingsForColumn = columnSettings != null ? columnSettings : this.defaultSettings;
        if (isTarget) {
            this.columns.put(colName, KSModelColumnType.DEPENDENT_VARIABLE);
        } else if (column.getColumnType() == Column.TypeId.REAL || column.getColumnType() == Column.TypeId.INTEGER_53_BIT || column.getColumnType() == Column.TypeId.DATE_TIME || column.getColumnType() == Column.TypeId.TIME) {
            this.columns.put(colName, column.getCardinality() < settingsForColumn.getMinCardinalityForContinuous() ? KSModelColumnType.ORDINAL : KSModelColumnType.CONTINUOUS);
        } else {
            this.columns.put(colName, KSModelColumnType.NOMINAL);
        }
        this.cardinality.put(colName, column);
        this.settingsPerColumn.put(colName, settingsForColumn);
        return this;
    }

    @Override
    public KSTreeModelColumnQuerySection build() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        block6: for (Map.Entry<String, KSModelColumnType> entry : this.columns.entrySet()) {
            String columnName = entry.getKey();
            KSTreeModelSettings settingsForColumn = this.settingsPerColumn.get(columnName);
            KSModelColumnType columnType = entry.getValue();
            if (i++ > 0) {
                sb.append(", ");
            }
            sb.append("[").append(columnName).append("] ");
            if (columnType != KSModelColumnType.DEPENDENT_VARIABLE) {
                sb.append(String.format(GENERIC_SETTINGS, NumberTools.formatNumber((double)settingsForColumn.getPValue(), (int)2), settingsForColumn.getMaxBranches(), settingsForColumn.isBreakApart()));
            }
            switch (columnType) {
                case NOMINAL: {
                    sb.append(" ").append(String.format(NOMINAL_SETTINGS, Math.min(this.cardinality.get(columnName).getCardinality(), settingsForColumn.getNominalMaxBins()), settingsForColumn.getNominalMissingValueHandling().getRepresentation(), columnType.getInterpretation()));
                    continue block6;
                }
                case CONTINUOUS: {
                    sb.append(" ").append(String.format(CONTINUOUS_SETTINGS, settingsForColumn.getContinuousIntervalType().getRepresentation(), Math.min(this.cardinality.get(columnName).getCardinality(), settingsForColumn.getContinuousMaxIntervals()), settingsForColumn.getContinuousMissingValueHandling().getRepresentation(), KSTreeModelSettings.OrderedDisplay.RANGE.getRepresentation(), columnType.getInterpretation()));
                    continue block6;
                }
                case ORDINAL: {
                    sb.append(" ").append(String.format(ORDINAL_SETTINGS, settingsForColumn.getOrdinalOrderedDisplay().getRepresentation(), settingsForColumn.getOrdinalMissingValueHandling().getRepresentation(), columnType.getInterpretation()));
                    continue block6;
                }
                case DEPENDENT_VARIABLE: {
                    sb.append(String.format(DEPENDENT_VARIABLE_SETTINGS, columnType.getInterpretation()));
                    continue block6;
                }
            }
            LogService.getRoot().log(Level.WARNING, () -> String.format("Unexpected column type when building column query: %s", new Object[]{columnType}));
        }
        return new KSTreeModelColumnQuerySection(sb.toString());
    }
}

