/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.models;

import com.rapidminer.tools.ValidationUtilV2;

public class KSTreeModelSettings {
    private static KSTreeModelSettings instance;
    private double pValue;
    private int maxBranches;
    private int minCardinalityForContinuous;
    private boolean breakApart;
    private int nominalMaxBins;
    private MissingValueHandling nominalMissingValueHandling;
    private int continuousMaxIntervals;
    private MissingValueHandling continuousMissingValueHandling;
    private IntervalType continuousIntervalType;
    private OrderedDisplay ordinalOrderedDisplay;
    private MissingValueHandling ordinalMissingValueHandling;

    public KSTreeModelSettings() {
        this.setPValue(0.05);
        this.setMaxBranches(0);
        this.setMinCardinalityForContinuous(50);
        this.setBreakApart(true);
        this.setNominalMaxBins(50);
        this.setNominalMissingValueHandling(MissingValueHandling.USE);
        this.setContinuousMaxIntervals(10);
        this.setContinuousMissingValueHandling(MissingValueHandling.FLOAT);
        this.setContinuousIntervalType(IntervalType.STATIC);
        this.setOrdinalOrderedDisplay(OrderedDisplay.RANGE);
        this.setOrdinalMissingValueHandling(MissingValueHandling.FLOAT);
    }

    public double getPValue() {
        return this.pValue;
    }

    public void setPValue(double pValue) {
        if (pValue < 0.0 || pValue > 1.0) {
            throw new IllegalArgumentException("pValue must be within [0, 1]");
        }
        this.pValue = pValue;
    }

    public int getMaxBranches() {
        return this.maxBranches;
    }

    public void setMaxBranches(int maxBranches) {
        if (maxBranches < 0) {
            throw new IllegalArgumentException("maxBranches must not be < 0!");
        }
        this.maxBranches = maxBranches;
    }

    public int getMinCardinalityForContinuous() {
        return this.minCardinalityForContinuous;
    }

    public void setMinCardinalityForContinuous(int minCardinalityForContinuous) {
        if (minCardinalityForContinuous < 0) {
            throw new IllegalArgumentException("minCardinalityForContinuous must not be < 0!");
        }
        this.minCardinalityForContinuous = minCardinalityForContinuous;
    }

    public boolean isBreakApart() {
        return this.breakApart;
    }

    public void setBreakApart(boolean breakApart) {
        this.breakApart = breakApart;
    }

    public int getNominalMaxBins() {
        return this.nominalMaxBins;
    }

    public void setNominalMaxBins(int nominalMaxBins) {
        if (nominalMaxBins < 1) {
            throw new IllegalArgumentException("nominalMaxBins must not be < 1!");
        }
        this.nominalMaxBins = nominalMaxBins;
    }

    public MissingValueHandling getNominalMissingValueHandling() {
        return this.nominalMissingValueHandling;
    }

    public void setNominalMissingValueHandling(MissingValueHandling nominalMissingValueHandling) {
        this.nominalMissingValueHandling = (MissingValueHandling)((Object)ValidationUtilV2.requireNonNull((Object)((Object)nominalMissingValueHandling), (String)"nominalMissingValueHandling"));
    }

    public int getContinuousMaxIntervals() {
        return this.continuousMaxIntervals;
    }

    public void setContinuousMaxIntervals(int continuousMaxIntervals) {
        if (continuousMaxIntervals < 1) {
            throw new IllegalArgumentException("continuousMaxIntervals must not be < 1!");
        }
        this.continuousMaxIntervals = continuousMaxIntervals;
    }

    public MissingValueHandling getContinuousMissingValueHandling() {
        return this.continuousMissingValueHandling;
    }

    public void setContinuousMissingValueHandling(MissingValueHandling continuousMissingValueHandling) {
        this.continuousMissingValueHandling = (MissingValueHandling)((Object)ValidationUtilV2.requireNonNull((Object)((Object)continuousMissingValueHandling), (String)"continuousMissingValueHandling"));
    }

    public IntervalType getContinuousIntervalType() {
        return this.continuousIntervalType;
    }

    public void setContinuousIntervalType(IntervalType continuousIntervalType) {
        this.continuousIntervalType = (IntervalType)((Object)ValidationUtilV2.requireNonNull((Object)((Object)continuousIntervalType), (String)"continuousIntervalType"));
    }

    public OrderedDisplay getOrdinalOrderedDisplay() {
        return this.ordinalOrderedDisplay;
    }

    public void setOrdinalOrderedDisplay(OrderedDisplay ordinalOrderedDisplay) {
        this.ordinalOrderedDisplay = (OrderedDisplay)((Object)ValidationUtilV2.requireNonNull((Object)((Object)ordinalOrderedDisplay), (String)"ordinalOrderedDisplay"));
    }

    public MissingValueHandling getOrdinalMissingValueHandling() {
        return this.ordinalMissingValueHandling;
    }

    public void setOrdinalMissingValueHandling(MissingValueHandling ordinalMissingValueHandling) {
        this.ordinalMissingValueHandling = (MissingValueHandling)((Object)ValidationUtilV2.requireNonNull((Object)((Object)ordinalMissingValueHandling), (String)"ordinalMissingValueHandling"));
    }

    public String toString() {
        return "KSTreeModelSettings{pValue=" + this.pValue + ", maxBranches=" + this.maxBranches + ", minCardinalityForContinuous=" + this.minCardinalityForContinuous + ", breakApart=" + this.breakApart + ", nominalMaxBins=" + this.nominalMaxBins + ", nominalMissingValueHandling=" + this.nominalMissingValueHandling + ", continuousMaxIntervals=" + this.continuousMaxIntervals + ", continuousMissingValueHandling=" + this.continuousMissingValueHandling + ", continuousIntervalType=" + this.continuousIntervalType + ", ordinalOrderedDisplay=" + this.ordinalOrderedDisplay + ", ordinalMissingValueHandling=" + this.ordinalMissingValueHandling + "}";
    }

    public static synchronized KSTreeModelSettings getInstance() {
        if (instance == null) {
            instance = new KSTreeModelSettings();
        }
        return instance;
    }

    public static enum MissingValueHandling {
        USE("null"),
        IGNORE("ignore"),
        FLOAT("float");

        private final String representation;

        private MissingValueHandling(String representation) {
            this.representation = representation;
        }

        public String getRepresentation() {
            return this.representation;
        }
    }

    public static enum IntervalType {
        STATIC("THRESHOLDS"),
        DYNAMIC("AUTOMATIC");

        private final String representation;

        private IntervalType(String representation) {
            this.representation = representation;
        }

        public String getRepresentation() {
            return this.representation;
        }
    }

    public static enum OrderedDisplay {
        RANGE("Range"),
        PRESENT("Present"),
        ALL("All");

        private final String representation;

        private OrderedDisplay(String representation) {
            this.representation = representation;
        }

        public String getRepresentation() {
            return this.representation;
        }
    }
}

