/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.models;

import com.altair.ks_engine.models.KSModelQuerySectionBuilder;
import com.altair.ks_engine.models.KSTreeBonferroniMethod;
import com.altair.ks_engine.models.KSTreeClusterMethod;
import com.altair.ks_engine.models.KSTreeMeasure;
import com.altair.ks_engine.models.KSTreeModelSettingsQuerySection;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.NumberTools;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.logging.Level;

public final class KSTreeModelSettingsQuerySectionBuilder
implements KSModelQuerySectionBuilder {
    private static final String REPRESENTATION_CREATE = "MultiTree=%s,Algorithm='%s',Measure='%s',ClusterMethod='%s',BisectionSamples='%d',DiscreteFilterThreshold='%s',ContinuousFilterThreshold='%s',UserBonferroniAdjustment='%s',GrowAutomaticStopSize='%s',MinWeight='%s',GrowAutomaticMaxDepth='%d',AllowConsecutiveSplits='%s',KeepRootSplits='%d',AsPercent='%s',BonferroniMethod='%s',BreakApartThresholdFactor='%s'";
    private static final String REPRESENTATION_ALTER = "define parameter Algorithm = '%s', define parameter GrowAutomaticStopSize = %s, define parameter MinWeight = %s, define parameter AsPercent = %s, define parameter AllowConsecutiveSplits = %s, define parameter GrowAutomaticMaxDepth = %s, define parameter KeepSplitTable = %d, define parameter KeepRootSplits = %d, define parameter KeepSubSplits = %d, define parameter PreserveSplits = %s, define parameter ValidationHoldback = %s, define parameter MultiTree = %s, define parameter PruneRequest = %s";
    private final boolean multiTree;
    private final String algorithm;
    private KSTreeMeasure measure;
    private KSTreeClusterMethod clusterMethod;
    private int bisectionSamples = 10;
    private double discreteFilterThreshold = 0.01;
    private double continuousFilterThreshold = 0.01;
    private double bonferroniAdjustment = 1.0;
    private double growAutomaticStopSize = 3.0;
    private double minWeight = 1.0;
    private int growAutomaticMaxDepth = 1;
    private boolean allowConsecutiveSplits = true;
    private boolean asPercent = true;
    private KSTreeBonferroniMethod bonferroniMethod;
    private double breakApartThresholdFactor = 0.98;
    private boolean keepSplitTable = false;
    private boolean keepRootSplits = false;
    private boolean keepSubSplits = false;
    private boolean validationHoldback = false;
    private boolean prune = false;
    private KSSettingsType settingsType = KSSettingsType.CREATE;

    KSTreeModelSettingsQuerySectionBuilder() {
        this.multiTree = false;
        this.algorithm = "KnowledgeSEEKER";
        this.measure = KSTreeMeasure.ENTROPY_VARIANCE;
        this.clusterMethod = KSTreeClusterMethod.CLUSTER;
        this.bonferroniMethod = KSTreeBonferroniMethod.KASS;
    }

    public KSTreeModelSettingsQuerySectionBuilder setSettingsType(KSSettingsType settingsType) {
        this.settingsType = (KSSettingsType)((Object)ValidationUtilV2.requireNonNull((Object)((Object)settingsType), (String)"settingsType"));
        return this;
    }

    public KSTreeModelSettingsQuerySectionBuilder setMeasure(KSTreeMeasure measure) {
        this.measure = (KSTreeMeasure)((Object)ValidationUtilV2.requireNonNull((Object)((Object)measure), (String)"measure"));
        return this;
    }

    public KSTreeModelSettingsQuerySectionBuilder setClusterMethod(KSTreeClusterMethod clusterMethod) {
        this.clusterMethod = (KSTreeClusterMethod)((Object)ValidationUtilV2.requireNonNull((Object)((Object)clusterMethod), (String)"clusterMethod"));
        return this;
    }

    public KSTreeModelSettingsQuerySectionBuilder setBisectionSamples(int bisectionSamples) {
        this.bisectionSamples = bisectionSamples;
        return this;
    }

    public KSTreeModelSettingsQuerySectionBuilder setDiscreteFilterThreshold(double discreteFilterThreshold) {
        this.discreteFilterThreshold = discreteFilterThreshold;
        return this;
    }

    public KSTreeModelSettingsQuerySectionBuilder setContinuousFilterThreshold(double continuousFilterThreshold) {
        this.continuousFilterThreshold = continuousFilterThreshold;
        return this;
    }

    public KSTreeModelSettingsQuerySectionBuilder setBonferroniAdjustment(double bonferroniAdjustment) {
        this.bonferroniAdjustment = bonferroniAdjustment;
        return this;
    }

    public KSTreeModelSettingsQuerySectionBuilder setGrowAutomaticStopSize(double growAutomaticStopSize) {
        if (growAutomaticStopSize < 0.0) {
            throw new IllegalArgumentException("growAutomaticStopSize must not be < 0!");
        }
        this.growAutomaticStopSize = growAutomaticStopSize;
        return this;
    }

    public KSTreeModelSettingsQuerySectionBuilder setMinWeight(double minWeight) {
        if (minWeight < 0.0) {
            throw new IllegalArgumentException("minWeight must not be < 0!");
        }
        this.minWeight = minWeight;
        return this;
    }

    public KSTreeModelSettingsQuerySectionBuilder setGrowAutomaticMaxDepth(int growAutomaticMaxDepth) {
        this.growAutomaticMaxDepth = growAutomaticMaxDepth;
        return this;
    }

    public KSTreeModelSettingsQuerySectionBuilder setAllowConsecutiveSplits(boolean allowConsecutiveSplits) {
        this.allowConsecutiveSplits = allowConsecutiveSplits;
        return this;
    }

    public KSTreeModelSettingsQuerySectionBuilder setAsPercent(boolean asPercent) {
        this.asPercent = asPercent;
        return this;
    }

    public KSTreeModelSettingsQuerySectionBuilder setKeepRootSplits(boolean keepRootSplits) {
        this.keepRootSplits = keepRootSplits;
        return this;
    }

    public KSTreeModelSettingsQuerySectionBuilder setKeepSubSplits(boolean keepSubSplits) {
        this.keepSubSplits = keepSubSplits;
        return this;
    }

    public boolean isKeepSubSplits() {
        return this.keepSubSplits;
    }

    public KSTreeModelSettingsQuerySectionBuilder setBonferroniMethod(KSTreeBonferroniMethod bonferroniMethod) {
        this.bonferroniMethod = (KSTreeBonferroniMethod)((Object)ValidationUtilV2.requireNonNull((Object)((Object)bonferroniMethod), (String)"bonferroniMethod"));
        return this;
    }

    public KSTreeModelSettingsQuerySectionBuilder setBreakApartThresholdFactor(double breakApartThresholdFactor) {
        this.breakApartThresholdFactor = breakApartThresholdFactor;
        return this;
    }

    @Override
    public KSTreeModelSettingsQuerySection build() {
        switch (this.settingsType) {
            case CREATE: {
                return new KSTreeModelSettingsQuerySection(String.format(REPRESENTATION_CREATE, this.multiTree, this.algorithm, this.measure.getName(), this.clusterMethod.getName(), this.bisectionSamples, NumberTools.formatNumber((double)this.discreteFilterThreshold, (int)2), NumberTools.formatNumber((double)this.continuousFilterThreshold, (int)2), NumberTools.formatNumber((double)this.bonferroniAdjustment, (int)2), NumberTools.formatNumber((double)this.growAutomaticStopSize, (int)2), NumberTools.formatNumber((double)this.minWeight, (int)2), this.growAutomaticMaxDepth, this.allowConsecutiveSplits, this.keepRootSplits ? 1 : 0, this.asPercent, this.bonferroniMethod.getName(), NumberTools.formatNumber((double)this.breakApartThresholdFactor, (int)2)));
            }
            case ALTER: {
                return new KSTreeModelSettingsQuerySection(String.format(REPRESENTATION_ALTER, this.algorithm, NumberTools.formatNumber((double)this.growAutomaticStopSize, (int)2), NumberTools.formatNumber((double)this.minWeight, (int)2), this.asPercent, this.allowConsecutiveSplits, this.growAutomaticMaxDepth, this.keepSplitTable ? 1 : 0, this.keepRootSplits ? 1 : 0, this.keepSubSplits ? 1 : 0, this.keepSubSplits, this.validationHoldback ? 1 : 0, this.multiTree, this.prune));
            }
        }
        LogService.getRoot().log(Level.SEVERE, () -> String.format("Unexpected KSSettingsType: %s", new Object[]{this.settingsType}));
        return new KSTreeModelSettingsQuerySection("");
    }

    public static enum KSSettingsType {
        CREATE,
        ALTER;

    }
}

