/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.models;

import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceInvalidNameException;
import com.altair.ks_engine.models.KSModelQuerySectionBuilder;
import com.altair.ks_engine.models.KSTreeModelColumnQuerySection;
import com.altair.ks_engine.parser.schema.KSAttribute;
import com.altair.ks_engine.parser.tree.KSDecisionTree;
import com.altair.ks_engine.parser.tree.Range;
import com.altair.ks_engine.parser.tree.TreeEdge;
import com.altair.ks_engine.parser.tree.TreeNode;
import com.altair.ks_engine.util.KSEngineTools;
import com.rapidminer.tools.container.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class KSTreeModelToWhereQuerySectionBuilder
implements KSModelQuerySectionBuilder {
    private KSDecisionTree tree;
    private Map<Integer, KSAttribute> schema;
    private String nodeID = "x";

    KSTreeModelToWhereQuerySectionBuilder() {
    }

    public KSTreeModelToWhereQuerySectionBuilder withNodeID(String nodeID) throws KSEngineWorkspaceInvalidNameException {
        this.nodeID = KSEngineTools.checkNodeIDValidity(nodeID);
        return this;
    }

    public KSTreeModelToWhereQuerySectionBuilder withTree(KSDecisionTree tree) {
        this.tree = tree;
        return this;
    }

    public KSTreeModelToWhereQuerySectionBuilder withSchema(Map<Integer, KSAttribute> schema) {
        this.schema = schema;
        return this;
    }

    @Override
    public KSTreeModelColumnQuerySection build() {
        if (this.schema == null) {
            throw new IllegalStateException("schema must not be null");
        }
        KSAttribute dependent = this.getDependent(this.schema);
        if ("x".equals(this.nodeID)) {
            if (dependent.getGrouping() == KSAttribute.Grouping.CONTINUOUS) {
                return new KSTreeModelColumnQuerySection(this.getNotNull(dependent.getName()));
            }
            return new KSTreeModelColumnQuerySection("");
        }
        if (this.tree == null) {
            throw new IllegalStateException("tree must not be null for non-root nodes");
        }
        ArrayList<TreeEdge> edgesOfInterest = new ArrayList<TreeEdge>();
        String nextId = this.nodeID;
        while (!"x".equals(nextId)) {
            String idToCheck = nextId;
            Optional<TreeEdge> found = this.tree.getEdges().stream().filter(e -> e.getChildId().equals(idToCheck)).findFirst();
            if (found.isEmpty()) {
                throw new IllegalStateException("Inconsistent tree");
            }
            TreeEdge treeEdge = found.get();
            edgesOfInterest.add(treeEdge);
            nextId = treeEdge.getParentId();
        }
        StringBuilder builder = new StringBuilder();
        int size = edgesOfInterest.size();
        int index = 0;
        for (TreeEdge treeEdge : edgesOfInterest) {
            builder.append("(");
            KSAttribute schemaForEdge = this.getSchemaForEdge(treeEdge);
            if (schemaForEdge.getDisplay() == KSAttribute.Display.RANGE && !treeEdge.getBranchValueRange().isEmpty()) {
                this.rangeQuery(treeEdge, schemaForEdge.getName(), builder);
            } else {
                this.listQuery(treeEdge, schemaForEdge.getName(), builder);
            }
            builder.append(")");
            if (index < size - 1) {
                builder.append(" AND ");
            }
            ++index;
        }
        if (dependent.getGrouping() == KSAttribute.Grouping.CONTINUOUS) {
            builder.append(" AND ").append(this.getNotNull(dependent.getName()));
        }
        return new KSTreeModelColumnQuerySection(builder.toString());
    }

    private String getNotNull(String name) {
        return "[" + name + "] IS NOT null";
    }

    private KSAttribute getDependent(Map<Integer, KSAttribute> schema) {
        Optional<KSAttribute> dependent = schema.values().stream().filter(a -> a.getState().equals((Object)KSAttribute.State.DEPENDENT)).findFirst();
        if (dependent.isEmpty()) {
            throw new IllegalStateException("schema without dependent");
        }
        return dependent.get();
    }

    private void rangeQuery(TreeEdge treeEdge, String name, StringBuilder builder) {
        List<Range> ranges = treeEdge.getBranchValueRange();
        int index = 0;
        for (Range range : ranges) {
            ++index;
            if (range.getRanges().size() == 1) {
                Pair<String, String> rangePair = range.getRanges().get(0);
                builder.append("[").append(name).append("]");
                if ("missing".equals(rangePair.getFirst())) {
                    builder.append(" IS null");
                } else {
                    builder.append("=").append((String)rangePair.getSecond());
                }
            } else {
                Pair<String, String> rangeStart = range.getRanges().get(0);
                builder.append("[").append(name).append("]");
                builder.append("closed".equals(rangeStart.getFirst()) ? ">=" : ">");
                builder.append(this.prepareValue((String)rangeStart.getSecond()));
                builder.append(" AND ");
                Pair<String, String> rangeEnd = range.getRanges().get(1);
                builder.append("[").append(name).append("]");
                builder.append("closed".equals(rangeEnd.getFirst()) ? "<=" : "<");
                builder.append(this.prepareValue((String)rangeEnd.getSecond()));
            }
            if (index >= ranges.size()) continue;
            builder.append(" OR ");
        }
    }

    private String prepareValue(String value) {
        if (((String)value).contains("Infinity")) {
            value = ((String)value).replace("Infinity", "{inf}");
        } else if (((String)value).contains(":")) {
            value = "{" + (String)value + "}";
        }
        return value;
    }

    private void listQuery(TreeEdge treeEdge, String name, StringBuilder builder) {
        List<TreeNode.Value> valueList = treeEdge.getBranchValueList();
        boolean hasOther = valueList.stream().anyMatch(v -> v.getType().equals("other"));
        if (!hasOther) {
            boolean hasMissing;
            List nonMissingValues = valueList.stream().filter(v -> !v.getType().equals("missing")).map(TreeNode.Value::getValue).collect(Collectors.toList());
            boolean bl = hasMissing = nonMissingValues.size() < valueList.size();
            if (hasMissing) {
                if (nonMissingValues.isEmpty()) {
                    builder.append("[").append(name).append("]").append(" IS NULL");
                    return;
                }
                builder.append("[").append(name).append("]");
                builder.append(" IS NULL OR ");
            }
            builder.append("[").append(name).append("]");
            if (nonMissingValues.size() == 1) {
                builder.append(" = ");
                builder.append("'").append(this.escapeForKS((String)nonMissingValues.get(0))).append("'");
            } else {
                builder.append(" IN (");
                for (int i = 0; i < nonMissingValues.size(); ++i) {
                    builder.append("'").append(this.escapeForKS((String)nonMissingValues.get(i))).append("'");
                    if (i >= nonMissingValues.size() - 1) continue;
                    builder.append(", ");
                }
                builder.append(")");
            }
            return;
        }
        String parentId = treeEdge.getParentId();
        List siblings = this.tree.getEdges().stream().filter(e -> e.getParentId().equals(parentId) && e != treeEdge).collect(Collectors.toList());
        HashSet otherValues = new HashSet();
        for (TreeEdge sibling : siblings) {
            List siblingValues = sibling.getBranchValueList().stream().map(v -> v.getType().equals("missing") ? null : v.getValue()).collect(Collectors.toList());
            otherValues.addAll(siblingValues);
        }
        boolean siblingsContainNull = otherValues.contains(null);
        if (siblingsContainNull) {
            builder.append("[").append(name).append("]");
            builder.append(" IS NOT NULL AND ");
            otherValues.remove(null);
        }
        builder.append("[").append(name).append("]");
        builder.append(" NOT IN (");
        int index = 0;
        for (String value : otherValues) {
            builder.append("'").append(this.escapeForKS(value)).append("'");
            if (++index >= otherValues.size()) continue;
            builder.append(", ");
        }
        builder.append(")");
    }

    private String escapeForKS(String value) {
        return value.replace("'", "''");
    }

    private KSAttribute getSchemaForEdge(TreeEdge edge) {
        String toSearch = edge.getChildId();
        Optional<TreeNode> first = this.tree.getChildren().stream().filter(n -> n.getId().equals(toSearch)).findFirst();
        if (first.isEmpty()) {
            throw new IllegalStateException("Inconsistent tree");
        }
        TreeNode treeNode = first.get();
        int iv = treeNode.getIV();
        KSAttribute ksAttribute = this.schema.get(iv);
        if (ksAttribute == null) {
            throw new IllegalArgumentException("Schema does not match tree");
        }
        return ksAttribute;
    }
}

