/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.models;

import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceInvalidNameException;
import com.altair.ks_engine.models.KSModelQuerySectionBuilder;
import com.altair.ks_engine.models.KSTreeNodeRenderQuerySection;
import com.altair.ks_engine.util.KSEngineTools;

public final class KSTreeNodeRenderQuerySectionBuilder
implements KSModelQuerySectionBuilder {
    private static final String REPRESENTATION = "%s%s%s%s%s";
    private int depthLimit = -1;
    private boolean includeNodeId = true;
    private boolean showOnlyActiveSplit = false;
    private String nodeAsRoot = "x";

    KSTreeNodeRenderQuerySectionBuilder() {
    }

    public KSTreeNodeRenderQuerySectionBuilder limitDepth(int depthLimit) {
        if (depthLimit == 0) {
            throw new IllegalArgumentException("depthLimit must not be 0");
        }
        this.depthLimit = depthLimit < 0 ? -1 : depthLimit;
        return this;
    }

    public KSTreeNodeRenderQuerySectionBuilder includeNodeId(boolean includeNodeId) {
        this.includeNodeId = includeNodeId;
        return this;
    }

    public KSTreeNodeRenderQuerySectionBuilder showOnlyActiveSplit(boolean showOnlyActiveSplit) {
        this.showOnlyActiveSplit = showOnlyActiveSplit;
        return this;
    }

    public KSTreeNodeRenderQuerySectionBuilder setNodeAsRoot(String nodeID) throws KSEngineWorkspaceInvalidNameException {
        this.nodeAsRoot = nodeID == null ? "x" : KSEngineTools.checkNodeIDValidity(nodeID);
        return this;
    }

    @Override
    public KSTreeNodeRenderQuerySection build() {
        return new KSTreeNodeRenderQuerySection(String.format(REPRESENTATION, this.includeNodeId ? ":" : "", this.depthLimit == -1 ? "@" : "=", this.showOnlyActiveSplit ? "" : "!", this.showOnlyActiveSplit ? "" : "%", this.nodeAsRoot));
    }
}

