/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.parser;

import com.altair.ks_engine.bridge.exception.KSEngineParserException;
import com.altair.ks_engine.parser.schema.KSAttribute;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.LogService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class KSEngineSchemaRenderXMLToAttributesParser {
    private static final String INDEX = "index";
    private static final String NAME = "name";
    private static final String STATE = "state";
    private static final String DISPLAY = "display";
    private static final String GROUPING = "grouping";
    private static final String ATTRIBUTE = "attribute";
    private static final String ATTRIBUTE_SETTINGS = "attribute-settings";

    KSEngineSchemaRenderXMLToAttributesParser() {
    }

    public Map<Integer, KSAttribute> extractSchemaRender(String doc) throws KSEngineParserException {
        HashMap<Integer, KSAttribute> hashMap;
        CharSequenceInputStream is = new CharSequenceInputStream((CharSequence)doc, StandardCharsets.UTF_8);
        try {
            Document resultDoc = XMLTools.createDocumentBuilder((boolean)false).parse((InputStream)is);
            HashMap<Integer, KSAttribute> result = new HashMap<Integer, KSAttribute>();
            NodeList childNodes = resultDoc.getDocumentElement().getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                KSAttribute.Grouping grouping;
                Node item = childNodes.item(i);
                if (!ATTRIBUTE.equals(item.getNodeName())) continue;
                String indexStr = item.getAttributes().getNamedItem(INDEX).getNodeValue();
                int index = Integer.parseInt(indexStr);
                String attrName = item.getAttributes().getNamedItem(NAME).getNodeValue();
                NodeList attrChildren = item.getChildNodes();
                String stateStr = "";
                String displayStr = "";
                String groupingStr = "";
                block26: for (int k = 0; k < attrChildren.getLength(); ++k) {
                    Node child = attrChildren.item(k);
                    switch (child.getNodeName()) {
                        case "state": {
                            stateStr = child.getTextContent();
                            continue block26;
                        }
                        case "attribute-settings": {
                            NodeList innerChildren = child.getChildNodes();
                            block27: for (int l = 0; l < innerChildren.getLength(); ++l) {
                                Node innerChild = innerChildren.item(l);
                                switch (innerChild.getNodeName()) {
                                    case "display": {
                                        displayStr = innerChild.getTextContent();
                                        continue block27;
                                    }
                                    case "grouping": {
                                        groupingStr = innerChild.getTextContent();
                                    }
                                }
                            }
                            continue block26;
                        }
                    }
                }
                try {
                    grouping = KSAttribute.Grouping.valueOf(groupingStr.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    LogService.getRoot().log(Level.SEVERE, String.format("Unknown grouping: %s", groupingStr));
                    grouping = KSAttribute.Grouping.UNORDERED;
                }
                result.put(index, new KSAttribute(attrName, index, KSAttribute.State.forString(stateStr), KSAttribute.Display.forString(displayStr), grouping));
            }
            hashMap = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SAXException e) {
                LogService.getRoot().log(Level.SEVERE, "Unexpected error when processing schemarender result from KS engine!", e);
                throw new KSEngineParserException(e);
            }
        }
        is.close();
        return hashMap;
    }
}

