/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.parser;

import com.altair.ks_engine.bridge.exception.KSEngineParserException;
import com.altair.ks_engine.parser.KSEngineParsers;
import com.altair.ks_engine.parser.schema.KSAttribute;
import com.altair.ks_engine.parser.splitedit.KSContinuousSplitEdit;
import com.altair.ks_engine.parser.splitedit.KSNonContinuousSplitEdit;
import com.altair.ks_engine.parser.splitedit.KSSplitEdit;
import com.altair.ks_engine.parser.tree.Frequency;
import com.altair.ks_engine.parser.tree.KSDecisionTree;
import com.altair.ks_engine.parser.tree.Range;
import com.altair.ks_engine.parser.tree.TreeEdge;
import com.altair.ks_engine.parser.tree.TreeNode;
import com.altair.ks_engine.util.KSEngineTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ValidationUtilV2;
import com.rapidminer.tools.container.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.regex.Matcher;

class KSEngineSplitEditParser {
    private final String doc;

    KSEngineSplitEditParser(String doc) {
        this.doc = (String)ValidationUtilV2.requireNonNull((Object)doc, (String)"doc");
    }

    KSSplitEdit extractSplitEdit() throws KSEngineParserException {
        KSAttribute.Grouping grouping;
        Matcher m = KSEngineTools.KS_EDIT_SPLIT_PATTERN.matcher(this.doc);
        if (!m.find()) {
            throw new KSEngineParserException("Invalid document, does not contain split IV and groupingType");
        }
        String ivName = m.group(1);
        String groupingType = m.group(2);
        try {
            grouping = KSAttribute.Grouping.valueOf(groupingType.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            LogService.getRoot().log(Level.SEVERE, String.format("Unknown grouping: %s", groupingType));
            grouping = KSAttribute.Grouping.UNORDERED;
        }
        KSDecisionTree tree = KSEngineParsers.parseDecisionTree(this.doc, false);
        if (grouping == KSAttribute.Grouping.CONTINUOUS) {
            return KSEngineSplitEditParser.extractContinuousSplitEdit(ivName, tree, this.doc);
        }
        return KSEngineSplitEditParser.extractNonContinuousSplitEdit(tree, grouping, ivName);
    }

    private static KSContinuousSplitEdit extractContinuousSplitEdit(String ivName, KSDecisionTree tree, String doc) throws KSEngineParserException {
        Matcher m = KSEngineTools.KS_EDIT_SPLIT_TYPE_PATTERN.matcher(doc);
        if (!m.find()) {
            throw new KSEngineParserException("Invalid document, does not contain value type");
        }
        String contentType = m.group(1);
        ArrayList<KSContinuousSplitEdit.SplitRange> ranges = new ArrayList<KSContinuousSplitEdit.SplitRange>();
        for (TreeEdge edge : tree.getEdges()) {
            List<Range> branchValueRange = edge.getBranchValueRange();
            boolean missing = false;
            String from = null;
            String to = null;
            for (Range range : branchValueRange) {
                List<Pair<String, String>> rangePairs = range.getRanges();
                if (rangePairs.size() == 1) {
                    Pair<String, String> stringStringPair = rangePairs.get(0);
                    if (!"missing".equals(stringStringPair.getFirst())) continue;
                    missing = true;
                    continue;
                }
                if (rangePairs.size() != 2) continue;
                Pair<String, String> first = rangePairs.get(0);
                from = (String)first.getSecond();
                Pair<String, String> second = rangePairs.get(1);
                to = (String)second.getSecond();
            }
            if (missing && to == null && from == null) {
                ranges.add(null);
                continue;
            }
            ranges.add(new KSContinuousSplitEdit.SplitRange(from, to, missing));
        }
        return new KSContinuousSplitEdit(tree.getRootNode().getTotal(), ivName, contentType, ranges);
    }

    private static KSNonContinuousSplitEdit extractNonContinuousSplitEdit(KSDecisionTree tree, KSAttribute.Grouping groupingType, String splitName) {
        ArrayList<KSNonContinuousSplitEdit.Group> groups = new ArrayList<KSNonContinuousSplitEdit.Group>();
        for (TreeEdge edge : tree.getEdges()) {
            List<TreeNode.Value> branchValueList = edge.getBranchValueList();
            List<Frequency> branchFrequenciesList = edge.getBranchFrequenciesList();
            ArrayList<KSNonContinuousSplitEdit.CountedValue> values = new ArrayList<KSNonContinuousSplitEdit.CountedValue>(branchValueList.size());
            int index = 0;
            for (TreeNode.Value value : branchValueList) {
                int frequency = Integer.parseInt(branchFrequenciesList.get(index).getUnweighted());
                values.add(new KSNonContinuousSplitEdit.CountedValue(value, frequency));
                ++index;
            }
            KSNonContinuousSplitEdit.Group group = new KSNonContinuousSplitEdit.Group(edge.getBranchLabel(), values);
            groups.add(group);
        }
        return new KSNonContinuousSplitEdit(groupingType, tree.getRootNode().getTotal(), splitName, groups);
    }
}

