/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.parser;

import com.altair.ks_engine.bridge.exception.KSEngineParserException;
import com.altair.ks_engine.models.KSTreeMeasure;
import com.altair.ks_engine.parser.schema.KSAttribute;
import com.altair.ks_engine.parser.splitreport.KSSplitReport;
import com.altair.ks_engine.util.KSEngineTools;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class KSEngineSplitReportParser {
    private static final String ATTR_INDEPENDENT_VARIABLE = "IV";
    private static final String ATTR_VALUE_NAME = "name";
    private static final String ATTR_VALUE_TYPE = "type";
    private static final String TYPE_MISSING = "missing";
    private static final String TYPE_REAL = "real";
    private final String doc;
    private final Map<Integer, KSAttribute> schema;
    private final KSTreeMeasure measure;

    KSEngineSplitReportParser(String doc, Map<Integer, KSAttribute> schema, KSTreeMeasure measure) throws KSEngineParserException {
        this.doc = (String)ValidationUtilV2.requireNonNull((Object)doc, (String)"doc");
        this.schema = (Map)ValidationUtilV2.requireNonNull(schema, (String)"schema");
        this.measure = (KSTreeMeasure)((Object)ValidationUtilV2.requireNonNull((Object)((Object)measure), (String)"measure"));
        if (schema.isEmpty()) {
            throw new KSEngineParserException("No columns in schema!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    KSSplitReport extractSplitReport() throws KSEngineParserException {
        if (StringUtils.isBlank((CharSequence)this.doc)) {
            KSSplitReport report2 = new KSSplitReport(this.measure);
            report2.calculateAndSeal();
            return report2;
        }
        try (CharSequenceInputStream is = new CharSequenceInputStream((CharSequence)this.doc, StandardCharsets.UTF_8);){
            Document resultDoc = XMLTools.createDocumentBuilder((boolean)false).parse((InputStream)is);
            KSSplitReport report = new KSSplitReport(this.measure);
            NodeList splits = (NodeList)KSEngineTools.XPATH_EXPRESSION_SPLIT_REPORT_SPLITS.evaluate(resultDoc, XPathConstants.NODESET);
            if (splits.getLength() == 0) {
                report.calculateAndSeal();
                KSSplitReport kSSplitReport = report;
                return kSSplitReport;
            }
            for (int i = 0; i < splits.getLength(); ++i) {
                Node split = splits.item(i);
                String ivVal = split.getAttributes().getNamedItem(ATTR_INDEPENDENT_VARIABLE).getTextContent();
                try {
                    Integer ivNumber = Integer.parseInt(ivVal);
                    KSAttribute ksAttribute = this.schema.get(ivNumber);
                    String colName = ksAttribute.getName();
                    KSAttribute.Grouping groupType = ksAttribute.getGrouping();
                    NodeList additionalFields = (NodeList)KSEngineTools.XPATH_EXPRESSION_SPLIT_REPORT_SPLIT_VALUES.evaluate(split, XPathConstants.NODESET);
                    LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
                    block19: for (int j = 0; j < additionalFields.getLength(); ++j) {
                        Node field = additionalFields.item(j);
                        String name = field.getAttributes().getNamedItem(ATTR_VALUE_NAME).getTextContent();
                        String type = field.getAttributes().getNamedItem(ATTR_VALUE_TYPE).getTextContent();
                        String content = field.getFirstChild() != null ? field.getFirstChild().getTextContent() : null;
                        switch (type) {
                            case "missing": {
                                map.put(name, Double.NaN);
                                continue block19;
                            }
                            case "real": {
                                map.put(name, content != null ? Double.parseDouble(content) : Double.NaN);
                                continue block19;
                            }
                            default: {
                                LogService.getRoot().log(Level.WARNING, () -> String.format("Unknown field type in split report: %s", type));
                            }
                        }
                    }
                    report.addColumn(colName, ivVal, groupType, map);
                    continue;
                }
                catch (NumberFormatException e) {
                    LogService.getRoot().log(Level.WARNING, () -> String.format("Found IV that could not be parsed, skipping: %s", ivVal));
                }
            }
            report.calculateAndSeal();
            KSSplitReport kSSplitReport = report;
            return kSSplitReport;
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.SEVERE, "UNEXPECTED ERROR WHEN PROCESSING SPLIT REPORT FROM KS ENGINE: Cannot parse to split report!", e);
            throw new KSEngineParserException(e);
        }
    }
}

