/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.parser;

import com.altair.ks_engine.bridge.exception.KSEngineParserException;
import com.altair.ks_engine.parser.tree.Frequency;
import com.altair.ks_engine.parser.tree.KSDecisionTree;
import com.altair.ks_engine.parser.tree.Range;
import com.altair.ks_engine.parser.tree.TreeEdge;
import com.altair.ks_engine.parser.tree.TreeNode;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ValidationUtilV2;
import com.rapidminer.tools.container.Pair;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class KSEngineXMLToDecisionTreeParser {
    public static final String TAG_DISCRETE_DIST = "discrete-dist";
    public static final String TAG_CONTINUOUS_DIST = "continuous-dist";
    public static final String TAG_NODE_DIST = "node-dist";
    public static final String TAG_TOTAL = "total";
    public static final String TAG_NODE = "node";
    public static final String TAG_NODE_OUTCOME = "node-outcome";
    public static final String TAG_SPLIT = "split";
    public static final String TAG_SPLIT_PARAMETERS = "split-parameters";
    public static final String TAG_BRANCH_VALUES = "branch-values";
    public static final String TAG_BRANCH_FREQUENCIES = "branch-frequencies";
    public static final String TAG_FREQUENCY = "frequency";
    public static final String TAG_VALUE = "value";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE_LIST = "list";
    public static final String ATTR_VALUE_RANGE = "range";
    private static final String INDEPENDENT_VARIABLE = "IV";
    private static final String DEPENDENT_VARIABLE = "DV";
    private static final String BRANCH_LABEL = "label";
    private final String doc;
    private final boolean variableIndexParsing;
    private Document xmlDocument;
    private final Deque<TreeNode> parentNodes = new ArrayDeque<TreeNode>();
    private KSDecisionTree decisionTree;

    KSEngineXMLToDecisionTreeParser(String doc, boolean variableIndexParsing) throws KSEngineParserException {
        this.doc = ValidationUtilV2.requireNonEmptyString((String)doc, (String)"doc");
        this.variableIndexParsing = variableIndexParsing;
        this.setupParser();
    }

    public KSDecisionTree extractDecisionTree() throws KSEngineParserException {
        this.decisionTree = new KSDecisionTree();
        this.parseNode(this.xmlDocument.getDocumentElement(), -1);
        return this.decisionTree;
    }

    private void setupParser() throws KSEngineParserException {
        try {
            this.xmlDocument = XMLTools.createDocumentBuilder((boolean)false).parse(new InputSource(new StringReader(this.doc)));
        }
        catch (IOException | SAXException e) {
            throw new KSEngineParserException(e);
        }
        this.xmlDocument.getDocumentElement().normalize();
    }

    private void parseNode(Element parentElement, int preKnownVariableIndex) throws KSEngineParserException {
        String nodeID = parentElement.getAttribute("node-id");
        TreeNode item = new TreeNode(StringUtils.isBlank((CharSequence)nodeID) ? UUID.randomUUID().toString() : nodeID);
        Optional<Object> parent = Optional.empty();
        if (!this.parentNodes.isEmpty()) {
            parent = Optional.ofNullable(this.parentNodes.peek());
            parent.ifPresent(node -> this.decisionTree.addEdge((TreeNode)node, item));
        }
        this.parentNodes.push(item);
        List childList = XMLTools.getChildElementsAsList((Element)parentElement);
        block14: for (Element elem : childList) {
            switch (elem.getNodeName()) {
                case "node-outcome": {
                    TreeNode tempContainer = this.parseNodeOutcome(elem, nodeID, preKnownVariableIndex);
                    TreeNode newChild = this.parentNodes.peek();
                    if (newChild == null) {
                        throw new KSEngineParserException("newChild was unexpectedly null!");
                    }
                    newChild.configureFrom(tempContainer);
                    this.getLastTreeEdge().ifPresent(edge -> edge.setChildId(newChild.getId()));
                    parent.ifPresent(node -> node.addDirectChild(newChild.getId()));
                    this.decisionTree.addChild(newChild);
                    continue block14;
                }
                case "split": {
                    this.parseSplit(elem);
                    continue block14;
                }
                case "branch-values": {
                    this.parseBranchValues(elem);
                    continue block14;
                }
                case "branch-frequencies": {
                    this.parseBranchFrequencies(elem);
                    continue block14;
                }
                case "node-dist": {
                    continue block14;
                }
            }
            LogService.getRoot().log(Level.WARNING, "unknown tempContainer child: " + elem.getNodeName());
        }
        this.parentNodes.pop();
    }

    private void parseBranchFrequencies(Element parentElement) {
        if (parentElement.getAttribute(ATTR_TYPE).equals(ATTR_VALUE_LIST)) {
            this.getLastTreeEdge().ifPresent(edge -> edge.setBranchFrequenciesList(this.parseFrequencies(XMLTools.getChildElementsAsList((Element)parentElement))));
        } else if (parentElement.getAttribute(ATTR_TYPE).equals(ATTR_VALUE_RANGE)) {
            this.getLastTreeEdge().ifPresent(edge -> edge.setBranchFrequenciesRange(this.parseFrequencies(XMLTools.getChildElementsAsList((Element)parentElement))));
        } else {
            LogService.getRoot().log(Level.WARNING, "unknown node child: " + parentElement.getNodeName());
        }
    }

    private Optional<TreeEdge> getLastTreeEdge() {
        if (this.decisionTree.getEdges().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.decisionTree.getEdges().get(this.decisionTree.getEdges().size() - 1));
    }

    private List<Frequency> parseFrequencies(List<Element> children) {
        ArrayList<Frequency> frequencies = new ArrayList<Frequency>();
        for (Element child : children) {
            if (child.getNodeName().startsWith(TAG_FREQUENCY)) {
                frequencies.add(this.parseFrequency(child));
                continue;
            }
            LogService.getRoot().log(Level.WARNING, "unexpected element found: " + child);
        }
        return frequencies;
    }

    private Frequency parseFrequency(Element element) {
        return new Frequency(element.getAttribute("weighted"), element.getAttribute("unweighted"));
    }

    private void parseBranchValues(Element parentElement) {
        if (parentElement.hasAttribute(BRANCH_LABEL)) {
            String branchLabel = parentElement.getAttribute(BRANCH_LABEL);
            this.getLastTreeEdge().ifPresent(edge -> edge.setBranchLabel(branchLabel));
        }
        if (parentElement.getAttribute(ATTR_TYPE).equals(ATTR_VALUE_LIST)) {
            List<TreeNode.Value> values = this.parseMultipleValues(XMLTools.getChildElementsAsList((Element)parentElement));
            this.getLastTreeEdge().ifPresent(edge -> edge.setBranchValueList(values));
        } else if (parentElement.getAttribute(ATTR_TYPE).equals(ATTR_VALUE_RANGE)) {
            List<Range> range = this.parseBranchValuesRange(XMLTools.getChildElementsAsList((Element)parentElement));
            this.getLastTreeEdge().ifPresent(edge -> edge.addBranchValueRange(range));
        } else {
            LogService.getRoot().log(Level.WARNING, "could not parse branch values for " + parentElement);
        }
    }

    private List<Range> parseBranchValuesRange(List<Element> children) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Element child : children) {
            if (child.getNodeName().equals(TAG_VALUE)) {
                Range range = new Range();
                List childChildren = XMLTools.getChildElementsAsList((Element)child);
                if (childChildren.isEmpty()) {
                    if ("missing".equals(child.getAttribute(ATTR_TYPE))) {
                        range.getRanges().add((Pair<String, String>)new Pair((Object)"missing", (Object)"Missing"));
                    } else {
                        range.getRanges().add((Pair<String, String>)new Pair((Object)"single", (Object)XMLTools.getFirstLevelTextContent((Node)child)));
                    }
                } else {
                    for (Element grandChild : childChildren) {
                        range.getRanges().add((Pair<String, String>)new Pair((Object)grandChild.getNodeName(), (Object)grandChild.getTextContent()));
                    }
                }
                if (range.isEmpty()) continue;
                ranges.add(range);
                continue;
            }
            LogService.getRoot().log(Level.WARNING, "could not parse branch values range for " + child);
        }
        return ranges;
    }

    private List<TreeNode.Value> parseMultipleValues(List<Element> children) {
        ArrayList<TreeNode.Value> result = new ArrayList<TreeNode.Value>();
        for (Element child : children) {
            if (child.getNodeName().equals(TAG_VALUE)) {
                result.add(this.parseValueNode(child));
                continue;
            }
            LogService.getRoot().log(Level.WARNING, "unexpected element found: " + child);
        }
        return result;
    }

    private void parseSplit(Element parentElement) throws KSEngineParserException {
        int preKnownVariableIndex;
        String ivValue = parentElement.getAttribute(INDEPENDENT_VARIABLE);
        String string = ivValue = ivValue.isEmpty() ? "-1" : ivValue;
        if (this.variableIndexParsing) {
            try {
                preKnownVariableIndex = Integer.parseInt(ivValue);
            }
            catch (NumberFormatException e) {
                LogService.getRoot().log(Level.WARNING, "Failed to parse IV value", e);
                preKnownVariableIndex = -1;
            }
        } else {
            preKnownVariableIndex = -1;
        }
        block10: for (Element elem : XMLTools.getChildElementsAsList((Element)parentElement)) {
            String nodeName;
            switch (nodeName = elem.getNodeName()) {
                case "node": {
                    this.parseNode(elem, preKnownVariableIndex);
                    continue block10;
                }
                case "split-parameters": {
                    continue block10;
                }
            }
            LogService.getRoot().log(Level.WARNING, () -> String.format("Unknown element '%s' found for parent '%s' while parsing split", elem, parentElement));
        }
    }

    private TreeNode parseNodeOutcome(Element element, String nodeID, int preKnownVariableIndex) {
        int dv = -1;
        int iv = preKnownVariableIndex;
        if (this.variableIndexParsing) {
            for (Attr attribute : XMLTools.getAttributes((Element)element)) {
                if (DEPENDENT_VARIABLE.equals(attribute.getName())) {
                    try {
                        dv = Integer.parseInt(attribute.getValue());
                    }
                    catch (NumberFormatException e) {
                        LogService.getRoot().log(Level.WARNING, e.getMessage(), e);
                    }
                }
                if (iv != -1 || !INDEPENDENT_VARIABLE.equals(attribute.getName())) continue;
                try {
                    iv = Integer.parseInt(attribute.getValue());
                }
                catch (NumberFormatException e) {
                    LogService.getRoot().log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        TreeNode node = new TreeNode(nodeID);
        node.setDV(dv);
        node.setIV(iv);
        List childList = XMLTools.getChildElementsAsList((Element)element);
        if (childList.size() == 1) {
            Element child = (Element)childList.get(0);
            if (child.getNodeName().equals(TAG_NODE_DIST)) {
                block15: for (Element subElement : XMLTools.getChildElementsAsList((Element)child)) {
                    String name;
                    switch (name = subElement.getNodeName()) {
                        case "total": {
                            node.setTotal(Integer.parseInt(subElement.getFirstChild().getTextContent()));
                            continue block15;
                        }
                        case "discrete-dist": {
                            TreeNode.Value[] values;
                            node.setType(TreeNode.NodeType.DISCRETE);
                            if (!XMLTools.getChildElementsAsList((Element)subElement).isEmpty()) {
                                values = (TreeNode.Value[])XMLTools.getChildElementsAsList((Element)subElement).stream().map(this::parseValueNode).toArray(TreeNode.Value[]::new);
                                node.setDistribution(new TreeNode.Distribution(TAG_DISCRETE_DIST, values));
                                continue block15;
                            }
                            LogService.getRoot().log(Level.WARNING, () -> String.format("Expected children but found none for '%s' while parsing %s", subElement, TAG_DISCRETE_DIST));
                            continue block15;
                        }
                        case "continuous-dist": {
                            TreeNode.Value[] values;
                            node.setType(TreeNode.NodeType.CONTINUOUS);
                            if (!XMLTools.getChildElementsAsList((Element)subElement).isEmpty()) {
                                values = (TreeNode.Value[])XMLTools.getChildElementsAsList((Element)subElement).stream().map(elem -> this.parseContinuousDistElement((Element)elem, subElement.getAttribute(ATTR_TYPE))).toArray(TreeNode.Value[]::new);
                                node.setDistribution(new TreeNode.Distribution(TAG_CONTINUOUS_DIST, values));
                                continue block15;
                            }
                            LogService.getRoot().log(Level.WARNING, () -> String.format("Expected children but found none for '%s' while parsing %s", subElement, TAG_CONTINUOUS_DIST));
                            continue block15;
                        }
                    }
                    LogService.getRoot().log(Level.WARNING, () -> String.format("Unexpected element '%s' found in '%s' while parsing %s", name, child, TAG_NODE_DIST));
                }
            } else {
                LogService.getRoot().log(Level.WARNING, () -> String.format("Expected exactly 1 node-dist element but found '%s' while parsing nodeOutcome", child));
            }
        } else {
            LogService.getRoot().log(Level.WARNING, () -> String.format("Expected exactly 1 child element but found these: '%s' while parsing nodeOutcome", XMLTools.getChildElementsAsList((Element)element)));
        }
        return node;
    }

    private TreeNode.Value parseValueNode(Element element) {
        String name = element.getAttribute(ATTR_NAME);
        String type = element.getAttribute(ATTR_TYPE);
        String contentValue = element.getFirstChild().getTextContent();
        return new TreeNode.Value(name, type, contentValue);
    }

    private TreeNode.Value parseContinuousDistElement(Element element, String type) {
        String name = element.getNodeName();
        String contentValue = XMLTools.getFirstLevelTextContent((Node)element);
        return new TreeNode.Value(name, type, contentValue);
    }
}

