/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.parser;

import com.altair.ks_engine.bridge.exception.KSEngineParserException;
import com.altair.ks_engine.util.KSEngineTools;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.column.type.RealArray;
import com.rapidminer.belt.column.type.TextList;
import com.rapidminer.belt.column.type.TextSet;
import com.rapidminer.belt.table.MixedRowWriter;
import com.rapidminer.belt.table.Table;
import com.rapidminer.belt.table.Writers;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class KSEngineXMLToTableParser {
    private static final String LIST_SPLIT_PLACEHOLDER = "\\s*,\\s*";
    private final String doc;
    private final List<String> columnOrder = new ArrayList<String>();
    private final List<Column.TypeId> columnTypes = new ArrayList<Column.TypeId>();

    KSEngineXMLToTableParser(String doc) {
        this.doc = ValidationUtilV2.requireNonEmptyString((String)doc, (String)"doc");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    Table extractTable() throws KSEngineParserException {
        try (CharSequenceInputStream is = new CharSequenceInputStream((CharSequence)this.doc, StandardCharsets.UTF_8);){
            Document resultDoc = XMLTools.createDocumentBuilder((boolean)false).parse((InputStream)is);
            this.extractColumnsAndTypes(resultDoc);
            NodeList rows = (NodeList)KSEngineTools.XPATH_EXPRESSION_ROWS.evaluate(resultDoc, XPathConstants.NODESET);
            int tableSize = rows.getLength();
            if (tableSize == 1 && !rows.item(0).hasChildNodes()) {
                MixedRowWriter writer = Writers.mixedRowWriter(KSEngineXMLToTableParser.convertToJavaUnicode(this.columnOrder), this.columnTypes, (int)0, (boolean)false);
                Table table = writer.create();
                return table;
            }
            MixedRowWriter writer = Writers.mixedRowWriter(KSEngineXMLToTableParser.convertToJavaUnicode(this.columnOrder), this.columnTypes, (int)tableSize, (boolean)true);
            for (int i = 0; i < tableSize; ++i) {
                writer.move();
                Node node = rows.item(i);
                if (node.getNodeType() != 1) {
                    throw new IllegalStateException(String.format("Row node was not an Element but was: %s", node.getNodeType()));
                }
                Element elNode = (Element)node;
                for (int index = 0; index < this.columnOrder.size(); ++index) {
                    String textContent;
                    Node item;
                    Node colTextNode;
                    String columnName = this.columnOrder.get(index);
                    NodeList colNode = elNode.getElementsByTagName(columnName);
                    if (colNode.getLength() < 1 || (colTextNode = (item = colNode.item(0)).getFirstChild()) == null || (textContent = colTextNode.getTextContent()) == null) continue;
                    this.addToWriter(writer, textContent, index);
                }
            }
            LogService.getRoot().log(Level.FINE, () -> String.format("Found %d rows and the following columns: %s", tableSize, StringUtils.join((Object[])new List[]{this.columnTypes})));
            Table table = writer.create();
            return table;
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.SEVERE, "UNEXPECTED ERROR WHEN PROCESSING RESULT FROM KS ENGINE: Cannot parse to table!", e);
            throw new KSEngineParserException(e);
        }
    }

    private void extractColumnsAndTypes(Document resultDoc) throws XPathExpressionException, KSEngineParserException {
        NodeList columns = (NodeList)KSEngineTools.XPATH_EXPRESSION_COLUMNS.evaluate(resultDoc, XPathConstants.NODESET);
        if (columns.getLength() == 0) {
            throw new KSEngineParserException(new IllegalStateException("No column nodes found!"));
        }
        for (int i = 0; i < columns.getLength(); ++i) {
            Node columnNode = columns.item(i);
            Node nameNode = columnNode.getAttributes().getNamedItem("name");
            if (nameNode == null) {
                throw new KSEngineParserException(new IllegalStateException("Column node does not have a name!"));
            }
            String columnName = nameNode.getNodeValue();
            Node typeNode = columnNode.getAttributes().getNamedItem("type");
            if (typeNode == null) {
                if (columnNode.getAttributes().getNamedItem("sql:rowset") != null) {
                    LogService.getRoot().log(Level.WARNING, () -> String.format("Unexpected hierarchical results in column '%s', omitting column!", columnName));
                    continue;
                }
                LogService.getRoot().log(Level.WARNING, () -> String.format("Column node for column '%s' does not have a type!", columnName));
                continue;
            }
            String ksType = typeNode.getNodeValue();
            this.columnOrder.add(columnName);
            this.columnTypes.add(KSEngineTools.getTypeIdForKSType(ksType));
        }
    }

    private void addToWriter(MixedRowWriter writer, String valueRepresentation, int index) {
        Column.TypeId typeId = this.columnTypes.get(index);
        switch (typeId) {
            case NOMINAL: 
            case TEXT: {
                writer.set(index, (Object)valueRepresentation);
                break;
            }
            case REAL: 
            case INTEGER_53_BIT: {
                writer.set(index, KSEngineTools.extractDouble(valueRepresentation));
                break;
            }
            case DATE_TIME: {
                writer.set(index, (Object)Instant.parse(valueRepresentation));
                break;
            }
            case TIME: {
                writer.set(index, (Object)LocalTime.parse(valueRepresentation));
                break;
            }
            case TEXT_LIST: {
                writer.set(index, (Object)new TextList(Arrays.asList(valueRepresentation.split(LIST_SPLIT_PLACEHOLDER))));
                break;
            }
            case TEXT_SET: {
                writer.set(index, (Object)new TextSet(Arrays.asList(valueRepresentation.split(LIST_SPLIT_PLACEHOLDER))));
                break;
            }
            case REAL_ARRAY: {
                RealArray valRA = new RealArray(Arrays.stream(valueRepresentation.split(LIST_SPLIT_PLACEHOLDER)).mapToDouble(KSEngineTools::extractDouble).toArray());
                writer.set(index, (Object)valRA);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Column %s of type %s has no buffer implementation yet!", this.columnOrder.get(index), typeId));
            }
        }
    }

    private static List<String> convertToJavaUnicode(List<String> columnNames) {
        return columnNames.stream().map(KSEngineTools::convertKSUnicodeToJavaUnicode).collect(Collectors.toList());
    }
}

