/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.parser.splitedit;

import com.altair.ks_engine.parser.schema.KSAttribute;
import com.altair.ks_engine.parser.splitedit.KSSplitEdit;
import com.altair.ks_engine.util.KSEngineTools;
import java.util.Collections;
import java.util.List;

public class KSContinuousSplitEdit
extends KSSplitEdit {
    private final String contentType;
    private final List<SplitRange> ranges;

    private KSContinuousSplitEdit() {
        this.contentType = null;
        this.ranges = Collections.emptyList();
    }

    public KSContinuousSplitEdit(int total, String splitName, String contentType, List<SplitRange> ranges) {
        super(KSAttribute.Grouping.CONTINUOUS, total, splitName);
        if (!KSEngineTools.KS_VALUE_TYPES.contains(contentType)) {
            throw new IllegalArgumentException("Illegal ks value type " + contentType);
        }
        this.contentType = contentType;
        this.ranges = ranges;
    }

    public String getContentType() {
        return this.contentType;
    }

    public List<SplitRange> getRanges() {
        return this.ranges;
    }

    public static class SplitRange {
        private final String from;
        private final String to;
        private final boolean containsMissing;

        private SplitRange() {
            this.from = null;
            this.to = null;
            this.containsMissing = false;
        }

        public SplitRange(String from, String to, boolean containsMissing) {
            this.from = from;
            this.to = to;
            this.containsMissing = containsMissing;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public boolean getContainsMissing() {
            return this.containsMissing;
        }
    }
}

