/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.parser.splitreport;

import com.altair.ks_engine.models.KSTreeMeasure;
import com.altair.ks_engine.parser.schema.KSAttribute;
import com.altair.ks_engine.parser.splitreport.KSSplit;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class KSSplitReport {
    private static final Map<KSTreeMeasure, String> RANK_VALUE_FIELD_MAPPING = Map.of(KSTreeMeasure.ENTROPY_VARIANCE, "ratio entropy", KSTreeMeasure.GINI_VARIANCE, "ratio index", KSTreeMeasure.UNADJUSTED_P_VALUE, "confidence", KSTreeMeasure.UNADJUSTED_LOG_P_VALUE, "log p-value", KSTreeMeasure.BONFERRONI_ADJUSTED_P_VALUE, "adj confidence", KSTreeMeasure.BONFERRONI_ADJUSTED_LOG_P_VALUE, "log adj p-value");
    private static final Map<KSTreeMeasure, String> RANK_VALUE_FIELD_MAPPING_ALTERNATIVES = Map.of(KSTreeMeasure.ENTROPY_VARIANCE, "ratio variance", KSTreeMeasure.GINI_VARIANCE, "ratio variance");
    private static final String SPLIT_REPORT_IS_NOT_YET_SEALED = "Split report is not yet sealed";
    private final KSTreeMeasure measure;
    private final List<KSSplit> rankedColumns = new ArrayList<KSSplit>();
    private final List<String> fields = new ArrayList<String>();
    private final Map<String, Map<String, Double>> reportMap = new LinkedHashMap<String, Map<String, Double>>();
    private boolean sealed = false;

    public KSSplitReport(KSTreeMeasure measure) {
        this.measure = (KSTreeMeasure)((Object)ValidationUtilV2.requireNonNull((Object)((Object)measure), (String)"measure"));
    }

    public void addColumn(String colName, String columnID, KSAttribute.Grouping groupType, LinkedHashMap<String, Double> fieldMap) {
        ValidationUtilV2.requireNonEmptyString((String)colName, (String)"colName");
        ValidationUtilV2.requireNonNull((Object)((Object)groupType), (String)"groupType");
        ValidationUtilV2.requireNonNull(fieldMap, (String)"fieldMap");
        if (this.sealed) {
            throw new IllegalStateException("Split report already sealed");
        }
        this.rankedColumns.add(new KSSplit(colName, columnID, groupType, () -> this.getRankInfoValue(colName)));
        this.reportMap.putIfAbsent(colName, new LinkedHashMap<String, Double>(fieldMap));
    }

    public void calculateAndSeal() {
        this.sealed = true;
        if (this.rankedColumns.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Double> fieldEntry : this.reportMap.get(this.rankedColumns.get(0).getColumnName()).entrySet()) {
            this.fields.add(fieldEntry.getKey());
        }
        ArrayList<KSSplit> columnsToRank = new ArrayList<KSSplit>(this.rankedColumns);
        columnsToRank.sort((var1, var2) -> -1 * Double.compare(this.getRankInfoValue(var1.getColumnName()), this.getRankInfoValue(var2.getColumnName())));
        this.rankedColumns.clear();
        this.rankedColumns.addAll(columnsToRank);
    }

    public double getCalculatedRankForColumn(String colName) {
        ValidationUtilV2.requireNonEmptyString((String)colName, (String)"colName");
        if (!this.sealed) {
            throw new IllegalStateException(SPLIT_REPORT_IS_NOT_YET_SEALED);
        }
        if (this.isColumnUnknown(colName)) {
            return Double.NaN;
        }
        int rank = 0;
        for (int i = 0; i < this.rankedColumns.size(); ++i) {
            if (!colName.equals(this.rankedColumns.get(i).getColumnName())) continue;
            rank = i + 1;
            break;
        }
        return rank;
    }

    public double getRankInfoValue(String colName) {
        ValidationUtilV2.requireNonEmptyString((String)colName, (String)"colName");
        if (!this.sealed) {
            throw new IllegalStateException(SPLIT_REPORT_IS_NOT_YET_SEALED);
        }
        if (this.isColumnUnknown(colName)) {
            return Double.NaN;
        }
        Double originalValue = this.reportMap.get(colName).get(RANK_VALUE_FIELD_MAPPING.get((Object)this.measure));
        if (originalValue == null && (originalValue = this.reportMap.get(colName).get(RANK_VALUE_FIELD_MAPPING_ALTERNATIVES.get((Object)this.measure))) == null) {
            return Double.NaN;
        }
        switch (this.measure) {
            case ENTROPY_VARIANCE: 
            case GINI_VARIANCE: 
            case UNADJUSTED_P_VALUE: 
            case BONFERRONI_ADJUSTED_P_VALUE: {
                return originalValue * 100.0;
            }
            case UNADJUSTED_LOG_P_VALUE: 
            case BONFERRONI_ADJUSTED_LOG_P_VALUE: {
                return Math.abs(originalValue);
            }
        }
        return Double.NaN;
    }

    public String getRankInfoName() {
        if (!this.sealed) {
            throw new IllegalStateException(SPLIT_REPORT_IS_NOT_YET_SEALED);
        }
        switch (this.measure) {
            case ENTROPY_VARIANCE: 
            case GINI_VARIANCE: 
            case UNADJUSTED_P_VALUE: 
            case BONFERRONI_ADJUSTED_P_VALUE: {
                return null;
            }
            case UNADJUSTED_LOG_P_VALUE: {
                return "-log(p)";
            }
            case BONFERRONI_ADJUSTED_LOG_P_VALUE: {
                return "-log(adj p)";
            }
        }
        return "!! Unknown Rank !!";
    }

    public List<String> getReportFields() {
        if (!this.sealed) {
            throw new IllegalStateException(SPLIT_REPORT_IS_NOT_YET_SEALED);
        }
        return this.fields;
    }

    public List<KSSplit> getAvailableSplits() {
        if (!this.sealed) {
            throw new IllegalStateException(SPLIT_REPORT_IS_NOT_YET_SEALED);
        }
        return this.rankedColumns;
    }

    public double getValueForReportField(String colName, String field) {
        ValidationUtilV2.requireNonEmptyString((String)colName, (String)"colName");
        ValidationUtilV2.requireNonEmptyString((String)field, (String)"field");
        if (!this.sealed) {
            throw new IllegalStateException(SPLIT_REPORT_IS_NOT_YET_SEALED);
        }
        if (this.isColumnUnknown(colName)) {
            return Double.NaN;
        }
        Double val = this.reportMap.get(colName).get(field);
        return val != null ? val : Double.NaN;
    }

    public boolean isColumnUnknown(String colName) {
        return this.reportMap.get(colName) == null;
    }

    public boolean hasSplits() {
        return !this.rankedColumns.isEmpty();
    }

    public String toString() {
        return "KSSplitReport{measure=" + this.measure + ", rankedColumns=" + this.rankedColumns + ", fields=" + this.fields + ", sealed=" + this.sealed + "}";
    }
}

