/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.parser.tree;

import com.altair.ks_engine.parser.tree.TreeElement;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class TreeNode
extends TreeElement {
    private int total;
    private Distribution distribution;
    private String[] nodeHeader = new String[0];
    private String[] nodeFooter = new String[0];
    private boolean leafNode = true;
    private boolean headerModified = false;
    private int dv = -1;
    private int iv = -1;
    private NodeType type = NodeType.DISCRETE;
    private Set<String> directChildren = new LinkedHashSet<String>(0);

    public TreeNode(String id) {
        super(id);
    }

    public void configureFrom(TreeNode node) {
        this.setTotal(node.getTotal());
        this.setDistribution(node.getDistribution());
        this.setDV(node.getDV());
        this.setIV(node.getIV());
        this.setDirectChildren(node.getDirectChildren());
        this.setType(node.getType());
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(Distribution distribution) {
        this.distribution = distribution;
    }

    public String[] getNodeHeader() {
        return this.nodeHeader;
    }

    public int getDV() {
        return this.dv;
    }

    public void setDV(int dv) {
        this.dv = dv;
    }

    public int getIV() {
        return this.iv;
    }

    public void setIV(int iv) {
        this.iv = iv;
    }

    public Set<String> getDirectChildren() {
        return this.directChildren;
    }

    public void setDirectChildren(Set<String> directChildren) {
        this.directChildren = directChildren;
    }

    public void addDirectChild(String child) {
        this.directChildren.add(child);
        this.leafNode = false;
    }

    public void setNodeHeader(String[] nodeHeader) {
        this.nodeHeader = nodeHeader;
    }

    public String[] getNodeFooter() {
        return this.nodeFooter;
    }

    public void setNodeFooter(String[] nodeFooter) {
        this.nodeFooter = nodeFooter;
    }

    public boolean getLeafNode() {
        return this.leafNode;
    }

    public NodeType getType() {
        return this.type;
    }

    public void setType(NodeType type) {
        this.type = type;
    }

    public boolean getHeaderModified() {
        return this.headerModified;
    }

    public void setHeaderModified(boolean headerModified) {
        this.headerModified = headerModified;
    }

    @Override
    public String toString() {
        return "TreeNode{total=" + this.total + ", distribution=" + this.distribution + ", nodeHeader=" + Arrays.toString(this.nodeHeader) + ", nodeFooter=" + Arrays.toString(this.nodeFooter) + ", headerModified=" + this.headerModified + ", leafNode=" + this.leafNode + ", dv=" + this.dv + ", iv=" + this.iv + ", type='" + this.type + "', directChildren=" + this.directChildren + "} " + super.toString();
    }

    public static enum NodeType {
        DISCRETE("tabularNode"),
        CONTINUOUS("continuousNode");

        private final String type;

        private NodeType(String type) {
            this.type = type;
        }

        @JsonValue
        public String getType() {
            return this.type;
        }

        public String toString() {
            return "NodeType{type='" + this.type + "'} " + super.toString();
        }
    }

    public static class Distribution {
        private String type;
        private Value[] values;

        public Distribution() {
        }

        public Distribution(String type, Value[] values) {
            this.type = type;
            this.values = values;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Value[] getValues() {
            return this.values;
        }

        public void setValues(Value[] values) {
            this.values = values;
        }

        public String toString() {
            return "Distribution{type='" + this.type + "', values=" + Arrays.toString(this.values) + "}";
        }
    }

    public static class Value {
        private String name;
        private String type;
        private String value;

        public Value() {
        }

        public Value(String name, String type, String value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public String getName() {
            return this.name == null ? "" : this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type == null ? "" : this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return "Value{name='" + this.name + "', type='" + this.type + "', value='" + this.value + "'}";
        }
    }
}

