/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.query;

import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.List;
import java.util.logging.Level;

public class KSError {
    private static final String UNKNOWN_ID = "unknown";
    private final String errorMessage;
    private final String errorID;

    public KSError(List<String> errorLines) {
        ValidationUtilV2.requireNonEmptyList(errorLines, (String)"errorLines");
        StringBuilder sb = new StringBuilder();
        this.errorID = this.extractErrorID(errorLines.get(0));
        for (int i = 1; i < errorLines.size(); ++i) {
            sb.append(errorLines.get(i)).append("\n");
        }
        this.errorMessage = sb.toString();
    }

    public String getErrorAsString() {
        return this.errorMessage;
    }

    public String getErrorID() {
        return this.errorID;
    }

    private String extractErrorID(String line) {
        if (line.startsWith("#?! error")) {
            return line.substring("#?! error".length() + 1);
        }
        LogService.getRoot().log(Level.SEVERE, () -> String.format("UNEXPECTED RESULT RETURNED FROM KS ENGINE: line did not contain expected error id: %s", line));
        return UNKNOWN_ID;
    }
}

