/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.query;

import com.altair.ks_engine.bridge.exception.KSEngineParserException;
import com.altair.ks_engine.bridge.exception.KSEngineQueryProcessingException;
import com.altair.ks_engine.parser.KSEngineParsers;
import com.altair.ks_engine.util.KSEngineTools;
import com.rapidminer.belt.table.Table;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;

public class KSResult {
    private static final String ID_PREFIX = "]]>";
    private static final String ID_SUFFIX = "<[[";
    public static final String EMPTY_ID = "EMPTY";
    private final String resultID;
    private final String result;
    private final Table resultTable;

    public KSResult() {
        this.resultID = EMPTY_ID;
        this.result = "";
        this.resultTable = null;
    }

    public KSResult(List<String> resultLines) throws KSEngineQueryProcessingException {
        try {
            ValidationUtilV2.requireNonEmptyList(resultLines, (String)"resultLines");
            StringBuilder sb = new StringBuilder();
            int numberOfLines = resultLines.size();
            this.resultID = this.extractResultID(resultLines.get(0));
            this.validateResultID(resultLines.get(numberOfLines - 1));
            for (int i = 1; i < numberOfLines - 1; ++i) {
                sb.append(resultLines.get(i)).append("\n");
            }
            this.result = sb.toString();
            this.resultTable = KSEngineParsers.parseDataTable(this.result);
        }
        catch (KSEngineParserException | RuntimeException e) {
            throw new KSEngineQueryProcessingException(e);
        }
    }

    public String getResultID() {
        return this.resultID;
    }

    public boolean isEmptyResult() {
        return EMPTY_ID.equals(this.getResultID());
    }

    public String getResultAsString() {
        return this.result;
    }

    public Table getResultAsTable() {
        return this.resultTable;
    }

    private String extractResultID(String line) throws KSEngineQueryProcessingException {
        Matcher idMatcher = KSEngineTools.RESULT_ID_PATTERN.matcher(line);
        if (idMatcher.find()) {
            String match = idMatcher.group(0);
            if (match.startsWith(ID_PREFIX) && match.endsWith(ID_SUFFIX)) {
                return match.substring(ID_PREFIX.length(), match.length() - ID_SUFFIX.length());
            }
            LogService.getRoot().log(Level.SEVERE, () -> String.format("UNEXPECTED RESULT RETURNED FROM KS ENGINE: line did not contain expected result id format: %s", match));
            throw new KSEngineQueryProcessingException(new IllegalStateException("Line did not contain expected result id format"));
        }
        LogService.getRoot().log(Level.SEVERE, () -> String.format("UNEXPECTED RESULT RETURNED FROM KS ENGINE: line did not contain result id: %s", line));
        throw new KSEngineQueryProcessingException(new IllegalStateException("Line did not contain result id"));
    }

    private void validateResultID(String lastLine) throws KSEngineQueryProcessingException {
        String lastLineResultID = this.extractResultID(lastLine);
        if (!this.resultID.equals(lastLineResultID)) {
            LogService.getRoot().log(Level.SEVERE, () -> String.format("UNEXPECTED RESULT RETURNED FROM KS ENGINE: First line and last line contained different result ids: %s %s", this.resultID, lastLineResultID));
            throw new KSEngineQueryProcessingException(new IllegalStateException("First line and last line contained different result ids"));
        }
    }
}

