/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ks_engine.util;

import com.altair.ks_engine.bridge.exception.KSEngineInstallationException;
import com.altair.ks_engine.bridge.exception.KSEngineWorkspaceInvalidNameException;
import com.altair.ks_engine.bridge.installer.InternalKSEngineInstaller;
import com.altair.ks_engine.bridge.installer.KSEngineInstaller;
import com.altair.ks_engine.bridge.installer.LinuxKSEngineInstaller;
import com.altair.ks_engine.bridge.installer.MacKSEngineInstaller;
import com.altair.ks_engine.bridge.installer.WindowsKSEngineInstaller;
import com.rapidminer.belt.column.Column;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.PlatformUtilities;
import com.rapidminer.tools.SystemInfoUtilities;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;

public final class KSEngineTools
extends Enum<KSEngineTools> {
    public static final int MINIMAL_ENGINE_PORT = 1024;
    private static final String KS_ENGINE_INFINITY = "INF";
    private static final String KS_ENGINE_NEGATIVE_INFINITY = "-INF";
    private static final String KS_RESULT_ID_REGEX = "]]>[a-z\\d]*<\\[\\[";
    private static final String KS_UNICODE_REGEX = "_x([A-F0-9]{3,4})_";
    private static final String KS_SQUARE_BRACKET_REGEX = "[\\[\\]]";
    private static final String KS_NODE_ID_REGEX = "x|[x\\d\\/\\.]*\\d+";
    private static final String KS_SPLIT_GROUPING_REGEX = "<split IV=\"(.*)\" groupingType=\"(\\w+)\">";
    private static final String KS_SPLIT_TYPE_REGEX = "<value type=\"(?!missing)([a-z-]+)\">";
    private static final String KS_RESULT_XPATH_COLUMNS = "//element[@name='row']/complexType/sequence/element";
    private static final String KS_RESULT_XPATH_ROWS = "/root/row";
    private static final String KS_SPLIT_REPORT_XPATH_SPLITS = "/node/split";
    private static final String KS_SPLIT_REPORT_XPATH_SPLIT_VALUES = "split-parameters/value";
    private static final XPath X_PATH;
    public static final Pattern RESULT_ID_PATTERN;
    public static final Pattern KS_UNICODE_PATTERN;
    public static final Pattern KS_EDIT_SPLIT_PATTERN;
    public static final Pattern KS_EDIT_SPLIT_TYPE_PATTERN;
    public static final XPathExpression XPATH_EXPRESSION_COLUMNS;
    public static final XPathExpression XPATH_EXPRESSION_ROWS;
    public static final XPathExpression XPATH_EXPRESSION_SPLIT_REPORT_SPLITS;
    public static final XPathExpression XPATH_EXPRESSION_SPLIT_REPORT_SPLIT_VALUES;
    public static final String[] KS_BLACKLISTED_STORAGE_STRINGS;
    public static final String[] KS_BLACKLISTED_COLUMN_STRINGS;
    public static final Set<String> KS_VALUE_TYPES;
    private static final Map<Character, String> KS_XML_REPLACEMENTS;
    private static final /* synthetic */ KSEngineTools[] $VALUES;

    public static KSEngineTools[] values() {
        return (KSEngineTools[])$VALUES.clone();
    }

    public static KSEngineTools valueOf(String name) {
        return Enum.valueOf(KSEngineTools.class, name);
    }

    public static KSEngineInstaller createInstallerForExternalKSEngine() {
        return new KSEngineInstaller(){

            @Override
            public boolean isEngineInstalled() {
                return true;
            }

            @Override
            public void installEngine() {
            }

            @Override
            public boolean isKSEngineRunning() {
                return true;
            }

            @Override
            public void startKSEngine(int port) {
            }

            @Override
            public boolean isKSEngineShutdownPossible() {
                return false;
            }

            @Override
            public void shutdownKSEngine() {
            }
        };
    }

    public static InternalKSEngineInstaller createBundledSystemSpecificInstaller() {
        if (SystemInfoUtilities.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.WINDOWS) {
            return new WindowsKSEngineInstaller(KSEngineTools.createJarPathProvider());
        }
        if (SystemInfoUtilities.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.OSX) {
            return new MacKSEngineInstaller(KSEngineTools.createJarPathProvider());
        }
        return new LinuxKSEngineInstaller(KSEngineTools.createJarPathProvider());
    }

    public static Column.TypeId getTypeIdForKSType(String ksType) {
        switch (ValidationUtilV2.requireNonEmptyString((String)ksType, (String)"ksType")) {
            case "xsd:string": 
            case "xsd:boolean": {
                return Column.TypeId.NOMINAL;
            }
            case "xsd:short": 
            case "xsd:int": 
            case "xsd:unsignedShort": 
            case "xsd:unsignedInt": {
                return Column.TypeId.INTEGER_53_BIT;
            }
            case "xsd:double": {
                return Column.TypeId.REAL;
            }
            case "xsd:dateTime": {
                return Column.TypeId.DATE_TIME;
            }
            case "xsd:time": {
                return Column.TypeId.TIME;
            }
        }
        LogService.getRoot().log(Level.WARNING, () -> String.format("Unknown KS result column type '%s', no mapping found!", ksType));
        throw new IllegalArgumentException("Unknown KS column type " + ksType);
    }

    public static Column.TypeId getTypeIdForKSDBDataType(int ksDBDataType) {
        switch (ksDBDataType) {
            case 2: 
            case 3: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return Column.TypeId.INTEGER_53_BIT;
            }
            case 4: 
            case 5: 
            case 131: {
                return Column.TypeId.REAL;
            }
            case 11: {
                return Column.TypeId.INTEGER_53_BIT;
            }
            case 129: 
            case 130: {
                return Column.TypeId.NOMINAL;
            }
            case 134: {
                return Column.TypeId.TIME;
            }
            case 135: {
                return Column.TypeId.DATE_TIME;
            }
        }
        LogService.getRoot().log(Level.WARNING, () -> String.format("Unknown KS DB data type '%d', no mapping found!", ksDBDataType));
        throw new IllegalArgumentException("Unknown KS DB data type " + ksDBDataType);
    }

    public static String convertKSUnicodeToJavaUnicode(String ksString) {
        Matcher idMatcher = KS_UNICODE_PATTERN.matcher((CharSequence)ValidationUtilV2.requireNonNull((Object)ksString, (String)"ksString"));
        return idMatcher.replaceAll(matchResult -> {
            String unicodeNumbers = idMatcher.group(1);
            return new String(Character.toChars(Integer.parseInt(unicodeNumbers, 16)));
        });
    }

    public static String stripSquareBracketsAndValidateStorageName(String name) throws KSEngineWorkspaceInvalidNameException {
        return KSEngineTools.checkStorageNameValidity(KSEngineTools.stripSquareBrackets(name));
    }

    public static String stripSquareBracketsAndValidateColumnName(String name) throws KSEngineWorkspaceInvalidNameException {
        return KSEngineTools.checkColumnNameValidity(KSEngineTools.stripSquareBrackets(name));
    }

    public static String stripSquareBrackets(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll(KS_SQUARE_BRACKET_REGEX, "");
    }

    public static String stripBlacklistedStorageCharacters(String name, Supplier<String> emptyResultReplacement) {
        if (name == null) {
            return null;
        }
        String result = name.trim();
        return (result = StringUtils.replaceEachRepeatedly((String)result, (String[])KS_BLACKLISTED_STORAGE_STRINGS, (String[])((String[])IntStream.range(0, KS_BLACKLISTED_STORAGE_STRINGS.length).mapToObj(i -> "").toArray(String[]::new)))).isEmpty() ? (String)((Supplier)ValidationUtilV2.requireNonNull(emptyResultReplacement, (String)"emptyResultReplacement")).get() : result;
    }

    public static String checkStorageNameValidity(String name) throws KSEngineWorkspaceInvalidNameException {
        try {
            ValidationUtilV2.requireNonEmptyString((String)name, (String)"name");
        }
        catch (RuntimeException e) {
            throw new KSEngineWorkspaceInvalidNameException(e.getMessage(), name);
        }
        for (String blacklistedString : KS_BLACKLISTED_STORAGE_STRINGS) {
            if (!name.contains(blacklistedString)) continue;
            throw new KSEngineWorkspaceInvalidNameException("Name contains forbidden character: " + blacklistedString, name, blacklistedString);
        }
        return name;
    }

    public static String checkColumnNameValidity(String name) throws KSEngineWorkspaceInvalidNameException {
        try {
            ValidationUtilV2.requireNonEmptyString((String)name, (String)"name");
        }
        catch (RuntimeException e) {
            throw new KSEngineWorkspaceInvalidNameException(e.getMessage(), name);
        }
        for (String blacklistedString : KS_BLACKLISTED_COLUMN_STRINGS) {
            if (!name.contains(blacklistedString)) continue;
            throw new KSEngineWorkspaceInvalidNameException("Name contains forbidden character: " + blacklistedString, name, blacklistedString);
        }
        return name;
    }

    public static String escapeXMLForKS(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int lastFoundIndex = 0;
        for (int i = 0; i < value.length(); ++i) {
            char character = value.charAt(i);
            if (!KS_XML_REPLACEMENTS.containsKey(Character.valueOf(character))) continue;
            builder.append(value, lastFoundIndex, i);
            lastFoundIndex = i + 1;
            builder.append(KS_XML_REPLACEMENTS.get(Character.valueOf(character)));
        }
        if (lastFoundIndex == 0) {
            return value;
        }
        builder.append(value, lastFoundIndex, value.length());
        return builder.toString();
    }

    public static String checkNodeIDValidity(String nodeID) throws KSEngineWorkspaceInvalidNameException {
        try {
            ValidationUtilV2.requireNonEmptyString((String)nodeID, (String)"nodeID");
        }
        catch (RuntimeException e) {
            throw new KSEngineWorkspaceInvalidNameException(e.getMessage(), nodeID);
        }
        if (!nodeID.matches(KS_NODE_ID_REGEX)) {
            throw new KSEngineWorkspaceInvalidNameException("NodeID contains forbidden characters", nodeID);
        }
        return nodeID;
    }

    public static double extractDouble(String valueRepresentation) {
        double valReal;
        try {
            valReal = valueRepresentation != null ? Double.parseDouble(valueRepresentation) : Double.NaN;
        }
        catch (NumberFormatException e) {
            if (KS_ENGINE_INFINITY.equals(valueRepresentation)) {
                valReal = Double.POSITIVE_INFINITY;
            }
            if (KS_ENGINE_NEGATIVE_INFINITY.equals(valueRepresentation)) {
                valReal = Double.NEGATIVE_INFINITY;
            }
            LogService.getRoot().log(Level.WARNING, String.format("Failed to parse %s as number", valueRepresentation));
            valReal = Double.NaN;
        }
        return valReal;
    }

    public static int findFreePort(String host, int rangeStartPort, int rangeLength, int startIndex) {
        if (rangeStartPort < 1024) {
            throw new IllegalArgumentException("range start port must be at least 1024");
        }
        if (rangeLength <= 0) {
            throw new IllegalArgumentException("range length must be positive");
        }
        if (startIndex < 0) {
            throw new IllegalArgumentException("start index must not be negative");
        }
        if (startIndex >= rangeLength) {
            throw new IllegalArgumentException("start index must be smaller than range length");
        }
        for (int i = 0; i < rangeLength; ++i) {
            int index = (startIndex + i) % rangeLength;
            int testPort = rangeStartPort + index;
            if (KSEngineTools.isSocketInUse(host, testPort)) continue;
            return testPort;
        }
        return -1;
    }

    private static boolean isSocketInUse(String host, int port) {
        boolean bl;
        Socket socket = new Socket(host, port);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    private static XPathExpression createXPathExpression(String expression) {
        try {
            return X_PATH.compile(expression);
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.SEVERE, "Failed to init XPath expression for KS engine - cannot read results", e);
            return null;
        }
    }

    private static Pattern createRegularExpression(String expression) {
        try {
            return Pattern.compile(expression);
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.SEVERE, "Failed to init regular expression for KS engine - cannot read results", e);
            return null;
        }
    }

    private static String getKSEngineSystemJarName() {
        Object name = "ksengine-";
        switch (SystemInfoUtilities.getOperatingSystem()) {
            case WINDOWS: {
                name = (String)name + "win64";
                break;
            }
            case OSX: {
                name = (String)name + "mac";
                break;
            }
            default: {
                name = (String)name + "linux";
            }
        }
        return (String)name + "-" + PlatformUtilities.getKsEngineVersion() + ".jar";
    }

    private static Path getJarPath() throws IOException {
        String classpath = System.getProperty("java.class.path");
        String[] classPathValues = classpath.split(File.pathSeparator);
        String systemJarName = KSEngineTools.getKSEngineSystemJarName();
        for (String classPath : classPathValues) {
            if (!classPath.endsWith(systemJarName)) continue;
            return Paths.get(classPath, new String[0]);
        }
        throw new IOException("System specific jar '" + systemJarName + "' not found on classpath");
    }

    private static InternalKSEngineInstaller.EngineZipStreamProvider createJarPathProvider() {
        return () -> {
            Path zipPath = null;
            try {
                zipPath = KSEngineTools.getJarPath();
            }
            catch (IOException e) {
                throw new KSEngineInstallationException("engine zip not found", e);
            }
            try {
                return Files.newInputStream(zipPath, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new KSEngineInstallationException("failed to create zip stream", e);
            }
        };
    }

    private static /* synthetic */ KSEngineTools[] $values() {
        return new KSEngineTools[0];
    }

    static {
        $VALUES = KSEngineTools.$values();
        X_PATH = XPathFactory.newInstance().newXPath();
        RESULT_ID_PATTERN = KSEngineTools.createRegularExpression(KS_RESULT_ID_REGEX);
        KS_UNICODE_PATTERN = KSEngineTools.createRegularExpression(KS_UNICODE_REGEX);
        KS_EDIT_SPLIT_PATTERN = KSEngineTools.createRegularExpression(KS_SPLIT_GROUPING_REGEX);
        KS_EDIT_SPLIT_TYPE_PATTERN = KSEngineTools.createRegularExpression(KS_SPLIT_TYPE_REGEX);
        XPATH_EXPRESSION_COLUMNS = KSEngineTools.createXPathExpression(KS_RESULT_XPATH_COLUMNS);
        XPATH_EXPRESSION_ROWS = KSEngineTools.createXPathExpression(KS_RESULT_XPATH_ROWS);
        XPATH_EXPRESSION_SPLIT_REPORT_SPLITS = KSEngineTools.createXPathExpression(KS_SPLIT_REPORT_XPATH_SPLITS);
        XPATH_EXPRESSION_SPLIT_REPORT_SPLIT_VALUES = KSEngineTools.createXPathExpression(KS_SPLIT_REPORT_XPATH_SPLIT_VALUES);
        KS_BLACKLISTED_STORAGE_STRINGS = new String[]{"/", "\\", ":", "*", "?", "|", "<", ">", "[", "]", "(", ")", "{", "}", "+", "#", "&", "!", "%", "`", "'", "\"", "@", "$", "^", ",", ".", ";", "="};
        KS_BLACKLISTED_COLUMN_STRINGS = new String[]{"\"", "`", "'", "[", "]"};
        KS_VALUE_TYPES = Set.of("missing", "null", "other", "default", "bool", "integer", "real", "string", "time", "time-stamp", "date", "time-of-day", "angle", "float", "guid", "unknown");
        KS_XML_REPLACEMENTS = new HashMap<Character, String>();
        String format = "&#x%02X;";
        for (int i = 0; i < 32; ++i) {
            KS_XML_REPLACEMENTS.put(Character.valueOf((char)i), String.format(format, i));
        }
        KS_XML_REPLACEMENTS.put(Character.valueOf('>'), "&gt;");
        KS_XML_REPLACEMENTS.put(Character.valueOf('<'), "&lt;");
        KS_XML_REPLACEMENTS.put(Character.valueOf('&'), "&amp;");
        KS_XML_REPLACEMENTS.put(Character.valueOf('\''), "&apos;");
        KS_XML_REPLACEMENTS.put(Character.valueOf('\"'), "&quot;");
        KS_XML_REPLACEMENTS.put(Character.valueOf('['), String.format(format, 91));
        KS_XML_REPLACEMENTS.put(Character.valueOf(']'), String.format(format, 93));
    }
}

