/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client;

import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.gui.look.icons.IconFactory;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.ListCellRenderer;

public abstract class AbstractPackageDescriptorListCellRenderer
implements ListCellRenderer<Object> {
    private static RenderingHints HI_QUALITY_HINTS = new RenderingHints(null);
    private Map<String, Icon> icons = new HashMap<String, Icon>();

    protected Icon getIcon(PackageDescriptor pd) {
        if (pd.getIcon() == null) {
            return null;
        }
        Icon result = this.icons.get(pd.getPackageId());
        if (result == null) {
            result = new ImageIcon(pd.getIcon());
            this.icons.put(pd.getPackageId(), result);
        }
        return result;
    }

    protected Icon getResizedIcon(Icon originalIcon) {
        if (originalIcon == null) {
            return IconFactory.getEmptyIcon48x48();
        }
        int width = originalIcon.getIconWidth();
        int height = originalIcon.getIconHeight();
        if (width != 48) {
            double scale = 48.0 / (double)width;
            BufferedImage bi = new BufferedImage((int)(scale * (double)width), (int)(scale * (double)height), 2);
            Graphics2D g = bi.createGraphics();
            g.setRenderingHints(HI_QUALITY_HINTS);
            g.scale(scale, scale);
            originalIcon.paintIcon(null, g, 0, 0);
            g.dispose();
            return new ImageIcon(bi);
        }
        return originalIcon;
    }

    static {
        HI_QUALITY_HINTS.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        HI_QUALITY_HINTS.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        HI_QUALITY_HINTS.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }
}

