/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client;

import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.deployment.client.wsimport.UpdateService;
import com.rapidminer.deployment.update.client.MarketplaceUpdateManager;
import com.rapidminer.deployment.update.client.PackageListCellRenderer;
import com.rapidminer.gui.look.Colors;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.RMUrlHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConfirmLicensesDialog
extends ButtonDialog {
    private static final long serialVersionUID = 4276757146820898347L;
    private JButton okButton;
    private JEditorPane licensePane = new JEditorPane("text/html", "");
    private static final int LIST_WIDTH = 330;
    private JList<PackageDescriptor> selectedForInstallList;
    private JList<PackageDescriptor> dependentPackages;
    private ResourceLabel licenseLabel;
    private Map<String, String> licenseNameToLicenseTextMap;
    private static String LOADING_LICENSE_TEXT = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" dir=\"ltr\" lang=\"en\" xml:lang=\"en\"><head><table cellpadding=0 cellspacing=0><tr><td><img src=\"" + SwingTools.getIconPath((String)"48/hourglass.png") + "\" /></td><td width=\"5\"></td><td>" + I18N.getGUILabel((String)"loading_license", (Object[])new Object[0]) + "</td></tr></table></head></html>";
    private static String ERROR_LOADING_LICENSE_TEXCT = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" dir=\"ltr\" lang=\"en\" xml:lang=\"en\"><head><table cellpadding=0 cellspacing=0><tr><td><img src=\"" + SwingTools.getIconPath((String)"48/error.png") + "\" /></td><td width=\"5\"></td><td>" + I18N.getGUILabel((String)"error_loading_license", (Object[])new Object[0]) + "</td></tr></table></head></html>";
    private boolean licenseLoadingFailed = true;
    private JCheckBox acceptReject;

    public ConfirmLicensesDialog(Dialog owner, Map<PackageDescriptor, Set<PackageDescriptor>> dependency, Map<String, String> licenseNameToLicenseTextMap) {
        super((Window)owner, "confirm_licenses", Dialog.ModalityType.APPLICATION_MODAL, new Object[]{"updates"});
        if (licenseNameToLicenseTextMap != null) {
            this.licenseNameToLicenseTextMap = licenseNameToLicenseTextMap;
            this.licenseLoadingFailed = false;
        } else {
            this.licenseNameToLicenseTextMap = new HashMap<String, String>();
        }
        JPanel main = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 23;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridwidth = -1;
        c.gridx = 0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 2, 0);
        ResourceLabel label = new ResourceLabel("selected_packages", new Object[0]);
        label.setFont(label.getFont().deriveFont(1));
        main.add((Component)label, c);
        Set<PackageDescriptor> selectedPackages = dependency.keySet();
        this.selectedForInstallList = new JList<PackageDescriptor>(selectedPackages.toArray(new PackageDescriptor[0]));
        label.setLabelFor(this.selectedForInstallList);
        HashMap<PackageDescriptor, HashSet<PackageDescriptor>> invertedDependency = new HashMap<PackageDescriptor, HashSet<PackageDescriptor>>();
        for (PackageDescriptor source : selectedPackages) {
            for (PackageDescriptor dep : dependency.get(source)) {
                if (!invertedDependency.containsKey(dep)) {
                    invertedDependency.put(dep, new HashSet());
                    ((HashSet)invertedDependency.get(dep)).add(source);
                    continue;
                }
                ((HashSet)invertedDependency.get(dep)).add(source);
            }
        }
        Set depPackages = invertedDependency.keySet();
        this.dependentPackages = new JList<PackageDescriptor>(depPackages.toArray(new PackageDescriptor[0]));
        c.gridx = 0;
        c.gridy = -1;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        ExtendedJScrollPane selectedForInstallPane = new ExtendedJScrollPane(this.selectedForInstallList);
        selectedForInstallPane.setMinimumSize(new Dimension(330, 100));
        selectedForInstallPane.setPreferredSize(new Dimension(330, 100));
        selectedForInstallPane.setHorizontalScrollBarPolicy(31);
        selectedForInstallPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY));
        this.selectedForInstallList.addListSelectionListener(new LicenseListSelectionListener(this.dependentPackages));
        PackageListCellRenderer sourceCellRenderer = new PackageListCellRenderer(null);
        this.selectedForInstallList.setCellRenderer(sourceCellRenderer);
        main.add((Component)selectedForInstallPane, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 0, 0);
        ResourceLabel dependentLabel = new ResourceLabel("dependent_packages", new Object[0]);
        dependentLabel.setFont(dependentLabel.getFont().deriveFont(1));
        dependentLabel.setLabelFor(this.dependentPackages);
        main.add((Component)dependentLabel, c);
        c.gridx = 0;
        c.gridy = -1;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        ExtendedJScrollPane dependentPackagesPane = new ExtendedJScrollPane(this.dependentPackages);
        dependentPackagesPane.setMinimumSize(new Dimension(330, 100));
        dependentPackagesPane.setPreferredSize(new Dimension(330, 100));
        dependentPackagesPane.setHorizontalScrollBarPolicy(31);
        dependentPackagesPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY));
        this.dependentPackages.addListSelectionListener(new LicenseListSelectionListener(this.selectedForInstallList));
        PackageListCellRenderer depCellRenderer = new PackageListCellRenderer(invertedDependency);
        this.dependentPackages.setCellRenderer(depCellRenderer);
        main.add((Component)dependentPackagesPane, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 10, 1, 0);
        this.licenseLabel = new ResourceLabel("license_label", new Object[0]);
        main.add((Component)this.licenseLabel, c);
        c.gridx = 1;
        c.gridy = -1;
        c.gridheight = 4;
        c.insets = new Insets(0, 10, 1, 0);
        this.licensePane.setEditable(false);
        this.licensePane.setBackground(Colors.PANEL_BACKGROUND);
        JScrollPane scrollPane = new JScrollPane(this.licensePane);
        scrollPane.setPreferredSize(new Dimension(400, 400));
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY));
        main.add((Component)scrollPane, c);
        this.licensePane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    RMUrlHandler.handleUrl((String)e.getDescription());
                }
            }
        });
        this.acceptReject = new JCheckBox((Action)new ResourceAction("accept_license", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void loggedActionPerformed(ActionEvent e) {
                if (ConfirmLicensesDialog.this.acceptReject.isSelected()) {
                    ConfirmLicensesDialog.this.enableButtons();
                } else {
                    ConfirmLicensesDialog.this.okButton.setEnabled(false);
                }
            }
        });
        this.okButton = this.makeOkButton("update.install");
        this.okButton.setText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.update.install.label", (Object[])new Object[]{selectedPackages.size() + depPackages.size()}));
        this.okButton.setEnabled(false);
        this.layoutDefault(main, 9, new AbstractButton[]{this.acceptReject, this.okButton, this.makeCancelButton("skip_install")});
        this.enableButtons();
    }

    private void setInitialSelection() {
        this.selectedForInstallList.setSelectedIndex(0);
    }

    private void enableButtons() {
        this.okButton.setEnabled(this.acceptReject.isSelected() && !this.licenseLoadingFailed);
        this.acceptReject.setEnabled(!this.licenseLoadingFailed);
    }

    private void setLicensePaneContent(PackageDescriptor desc) {
        this.licenseLabel.setText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.license_label.label", (Object[])new Object[]{desc.getName()}));
        final String licenseName = desc.getLicenseName();
        String licenseText = this.licenseNameToLicenseTextMap.get(licenseName);
        if (licenseText != null) {
            this.setLicenseText(licenseText);
        } else {
            this.licensePane.setText(LOADING_LICENSE_TEXT);
            new Thread("fetching-license"){

                @Override
                public void run() {
                    UpdateService service = null;
                    try {
                        service = MarketplaceUpdateManager.getService();
                        String licenseText = service.getLicenseTextHtml(licenseName);
                        ConfirmLicensesDialog.this.licenseNameToLicenseTextMap.put(licenseName, licenseText);
                        ConfirmLicensesDialog.this.licenseLoadingFailed = false;
                        ConfirmLicensesDialog.this.setLicenseText(licenseText);
                    }
                    catch (Exception e) {
                        ConfirmLicensesDialog.this.licenseLoadingFailed = true;
                        ConfirmLicensesDialog.this.setLicenseText(ERROR_LOADING_LICENSE_TEXCT);
                    }
                    ConfirmLicensesDialog.this.enableButtons();
                }
            }.start();
        }
    }

    private void setLicenseText(final String licenseText) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfirmLicensesDialog.this.licensePane.setText(licenseText);
                ConfirmLicensesDialog.this.licensePane.setCaretPosition(0);
            }
        });
    }

    public static boolean confirm(Dialog owner, Map<PackageDescriptor, Set<PackageDescriptor>> dependency, Map<String, String> licenseNameToLicenseTextMap) {
        ConfirmLicensesDialog d = new ConfirmLicensesDialog(owner, dependency, licenseNameToLicenseTextMap);
        d.setInitialSelection();
        d.setVisible(true);
        return d.wasConfirmed();
    }

    private class LicenseListSelectionListener
    implements ListSelectionListener {
        private JList<PackageDescriptor> otherList;

        public LicenseListSelectionListener(JList<PackageDescriptor> otherList) {
            this.otherList = otherList;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            JList source;
            if (!e.getValueIsAdjusting() && !(source = (JList)e.getSource()).isSelectionEmpty()) {
                if (!this.otherList.isSelectionEmpty()) {
                    this.otherList.clearSelection();
                }
                PackageDescriptor desc = (PackageDescriptor)source.getSelectedValue();
                try {
                    ConfirmLicensesDialog.this.setLicensePaneContent(desc);
                }
                catch (Exception e1) {
                    SwingTools.showSimpleErrorMessage((Window)((Object)ConfirmLicensesDialog.this), (String)"error_installing_update", (Throwable)e1, (Object[])new Object[]{e1.getMessage()});
                }
            }
        }
    }
}

