/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client;

import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.ManageExtensionsDialogAction;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.plugin.ManagedExtension;
import com.rapidminer.tools.plugin.Plugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ExtensionDialog
extends ButtonDialog {
    public static final Action MANAGE_EXTENSIONS = new ManageExtensionsDialogAction();
    private static final long serialVersionUID = 1L;
    private boolean changed = false;

    public ExtensionDialog() {
        super((Window)ApplicationFrame.getApplicationFrame(), "manage_extensions", Dialog.ModalityType.MODELESS, new Object[0]);
        Collection allExtensions = ManagedExtension.getAll();
        this.changed = false;
        if (allExtensions.isEmpty()) {
            ResourceLabel label = new ResourceLabel("no_extensions_installed", new Object[0]);
            label.setPreferredSize(new Dimension(300, 100));
            this.layoutDefault((JComponent)label, new AbstractButton[]{this.makeCloseButton()});
            return;
        }
        final JPanel main = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        Set blockedExtensions = allExtensions.stream().filter(ext -> !Plugin.isExtensionWhitelisted((String)ext.getPackageId())).collect(Collectors.toSet());
        boolean anyBlockedExtensions = !blockedExtensions.isEmpty();
        for (final ManagedExtension ext2 : allExtensions) {
            JPanel namePanel;
            c.gridwidth = 1;
            c.weightx = 0.7;
            c.insets = new Insets(5, 0, 0, 5);
            boolean extensionIsAllowed = !anyBlockedExtensions || !blockedExtensions.contains(ext2);
            final JCheckBox activate = new JCheckBox(ext2.getName());
            if (extensionIsAllowed) {
                namePanel = null;
                main.add((Component)activate, c);
            } else {
                ResourceLabel adminLockLabel = new ResourceLabel("incompatible_extension.blacklist", new Object[0]);
                namePanel = new JPanel(new BorderLayout(5, 0));
                namePanel.setOpaque(false);
                namePanel.add((Component)activate, "Center");
                namePanel.add((Component)adminLockLabel, "East");
                main.add((Component)namePanel, c);
            }
            c.weightx = 0.3;
            c.gridwidth = -1;
            final JComboBox<VersionNumber> versionCombo = new JComboBox<VersionNumber>(ext2.getInstalledVersions());
            main.add(versionCombo, c);
            final JButton deleteButton = new JButton();
            ResourceAction uninstallAction = new ResourceAction(true, "uninstall_extension", new Object[0]){
                private static final long serialVersionUID = 1L;

                public void loggedActionPerformed(ActionEvent e) {
                    if (SwingTools.showConfirmDialog((Window)((Object)ExtensionDialog.this), (String)"really_uninstall_extension", (int)0, (Object[])new Object[]{ext2.getName() + " v." + ext2.getSelectedVersion()}) != 0) {
                        return;
                    }
                    String selectedVersion = ext2.getSelectedVersion().getShortLongVersion();
                    ExtensionDialog.this.changed = true;
                    if (!ext2.uninstallActiveVersion()) {
                        SwingTools.showVerySimpleErrorMessage((Window)((Object)ExtensionDialog.this), (String)"error_uninstalling_extension", (Object[])new Object[0]);
                        return;
                    }
                    activate.setSelected(false);
                    versionCombo.removeItem(selectedVersion);
                    if (ManagedExtension.get((String)ext2.getPackageId()) == null) {
                        main.remove(namePanel != null ? namePanel : activate);
                        main.remove(versionCombo);
                        main.remove(deleteButton);
                    }
                }
            };
            deleteButton.setAction((Action)uninstallAction);
            c.gridwidth = 0;
            c.weightx = 0.0;
            c.insets = new Insets(5, 0, 0, 0);
            main.add((Component)deleteButton, c);
            boolean extensionIsActive = ext2.isActive() && extensionIsAllowed;
            activate.setSelected(extensionIsActive);
            activate.setEnabled(extensionIsAllowed);
            versionCombo.setEnabled(extensionIsActive);
            versionCombo.setSelectedItem(ext2.getSelectedVersion());
            if (!extensionIsAllowed) continue;
            activate.addActionListener(e -> {
                this.changed = true;
                versionCombo.setEnabled(activate.isSelected());
                ext2.setActive(activate.isSelected());
            });
            versionCombo.addActionListener(e -> {
                this.changed = true;
                ext2.setSelectedVersion((VersionNumber)versionCombo.getSelectedItem());
            });
        }
        c.gridwidth = 0;
        c.weighty = 1.0;
        main.add((Component)new JPanel(), c);
        ExtendedJScrollPane mainScrollPane = new ExtendedJScrollPane((Component)main);
        if (mainScrollPane.getPreferredSize().getHeight() < 50.0) {
            mainScrollPane.setPreferredSize(new Dimension((int)mainScrollPane.getPreferredSize().getWidth(), 50));
        }
        mainScrollPane.setBorder(null);
        this.layoutDefault((JComponent)mainScrollPane, new AbstractButton[]{this.makeCloseButton()});
    }

    protected void close() {
        if (this.changed) {
            ManagedExtension.saveConfiguration();
            if (SwingTools.showConfirmDialog((Window)((Object)this), (String)"manage_extensions.restart", (int)0, (Object[])new Object[0]) == 0) {
                RapidMinerGUI.getMainFrame().exit(true);
            }
        }
        super.close();
    }
}

