/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class InMemoryZipFile {
    private Map<String, byte[]> contents = new HashMap<String, byte[]>();

    public InMemoryZipFile(byte[] zipBuffer) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(zipBuffer);
             ZipInputStream zin = new ZipInputStream(bais);){
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                int length;
                if (entry.isDirectory()) continue;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] buf = new byte[10240];
                while ((length = zin.read(buf)) != -1) {
                    buffer.write(buf, 0, length);
                }
                zin.closeEntry();
                this.contents.put(entry.getName(), buffer.toByteArray());
            }
        }
    }

    public Set<String> entryNames() {
        return this.contents.keySet();
    }

    public byte[] getContents(String name) {
        return this.contents.get(name);
    }

    public boolean containsEntry(String name) {
        return this.contents.containsKey(name);
    }
}

