/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client;

import com.rapidminer.RapidMiner;
import com.rapidminer.deployment.client.wsimport.AccountService;
import com.rapidminer.deployment.client.wsimport.AccountServiceService;
import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.deployment.client.wsimport.UpdateService;
import com.rapidminer.deployment.client.wsimport.UpdateServiceException_Exception;
import com.rapidminer.deployment.client.wsimport.UpdateServiceService;
import com.rapidminer.deployment.update.client.ChecksumException;
import com.rapidminer.deployment.update.client.InMemoryZipFile;
import com.rapidminer.deployment.update.client.UpdateConfirmDialog;
import com.rapidminer.deployment.update.client.UpdateDialog;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.gui.tools.dialogs.ExtendedErrorDialog;
import com.rapidminer.settings.Telemetry;
import com.rapidminer.tools.DirectoryService;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.IOTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.PlatformUtilities;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.RMUrlHandler;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.WebServiceTools;
import com.rapidminer.tools.io.ProgressReportingInputStream;
import com.rapidminer.tools.plugin.ManagedExtension;
import com.rapidminer.tools.update.internal.UpdateManager;
import com.rapidminer.tools.usagestats.ActionStatisticsCollector;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.BooleanSupplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.SwingUtilities;
import javax.xml.namespace.QName;

public class MarketplaceUpdateManager
implements UpdateManager {
    public static final PlatformUtilities.Platform TARGET_PLATFORM;
    public static final boolean DEVELOPMENT_BUILD;
    private static final String BASE_VERSION_QUERY = "?baseVersion=";
    private final UpdateService service;
    private static UpdateService theService;
    private static URI lastUsedUri;
    private static AccountService accountService;
    private static String packageIdRapidMiner;

    public MarketplaceUpdateManager(UpdateService service) {
        this.service = service;
    }

    private InputStream openStream(URL url, ProgressListener listener, int minProgress, int maxProgress) throws IOException {
        InputStream urlIn;
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        WebServiceTools.setURLConnectionDefaults((URLConnection)con);
        con.setDoInput(true);
        con.setDoOutput(false);
        String lengthStr = con.getHeaderField("Content-Length");
        try {
            urlIn = con.getInputStream();
        }
        catch (IOException e) {
            throw new IOException(con.getResponseCode() + ": " + con.getResponseMessage(), e);
        }
        if (lengthStr == null || lengthStr.isEmpty()) {
            LogService.getRoot().log(Level.WARNING, "com.rapid_i.deployment.update.client.UpdateManager.sending_content_length_error");
            return urlIn;
        }
        try {
            long length = Long.parseLong(lengthStr);
            return new ProgressReportingInputStream(urlIn, listener, minProgress, maxProgress, length);
        }
        catch (NumberFormatException e) {
            LogService.getRoot().log(Level.WARNING, I18N.getMessage((ResourceBundle)LogService.getRoot().getResourceBundle(), (String)"com.rapid_i.deployment.update.client.UpdateManager.sending_illegal_content_length_error", (Object[])new Object[]{lengthStr}), e);
            return urlIn;
        }
    }

    public List<PackageDescriptor> performUpdates(List<PackageDescriptor> downloadList, ProgressListener progressListener) throws IOException, UpdateServiceException_Exception {
        downloadList.removeIf(desc -> {
            boolean remove;
            boolean bl = remove = "STAND_ALONE".equals(desc.getPackageTypeName()) && DEVELOPMENT_BUILD;
            if (remove) {
                SwingTools.showVerySimpleErrorMessageAndWait((String)"update_error_development_build", (Object[])new Object[0]);
            }
            return remove;
        });
        int i = 0;
        int failedLoads = 0;
        int availableDownloads = downloadList.size();
        int minProgress = 20;
        LinkedList<PackageDescriptor> installedPackage = new LinkedList<PackageDescriptor>();
        try {
            for (PackageDescriptor desc2 : downloadList) {
                String urlString = this.service.getDownloadURL(desc2.getPackageId(), desc2.getVersion(), desc2.getPlatformName());
                int maxProgress = minProgress + (100 - minProgress) / (availableDownloads - i);
                boolean incremental = MarketplaceUpdateManager.isIncrementalUpdate();
                if ("RAPIDMINER_PLUGIN".equals(desc2.getPackageTypeName())) {
                    ManagedExtension extension = ManagedExtension.getOrCreate((String)desc2.getPackageId(), (String)desc2.getName(), (String)desc2.getLicenseName());
                    VersionNumber baseVersion = extension.getLatestInstalledVersionBefore(desc2.getVersion());
                    URL url = MarketplaceUpdateManager.getUpdateServerURI(urlString + (String)((incremental &= baseVersion != null) ? BASE_VERSION_QUERY + URLEncoder.encode(baseVersion.getLongVersion(), "UTF-8") : "")).toURL();
                    boolean successful = false;
                    if (incremental) {
                        int incMaxProgress = minProgress + (100 - minProgress) / (availableDownloads - i) / 2;
                        LogService.getRoot().log(Level.INFO, "com.rapid_i.deployment.update.client.UpdateManager.updating_package_id_incrementally", desc2.getPackageId());
                        try {
                            this.updatePluginIncrementally(extension, this.openStream(url, progressListener, minProgress, incMaxProgress), baseVersion.getLongVersion(), desc2.getVersion(), urlString + BASE_VERSION_QUERY + URLEncoder.encode(baseVersion.getLongVersion(), "UTF-8") + "&md5");
                            successful = true;
                        }
                        catch (ChecksumException | IOException e) {
                            LogService.getRoot().warning("com.rapid_i.deployment.update.client.UpdateManager.incremental_update_error");
                            incremental = false;
                            minProgress = incMaxProgress;
                            url = MarketplaceUpdateManager.getUpdateServerURI(urlString).toURL();
                        }
                    }
                    if (!incremental) {
                        LogService.getRoot().log(Level.INFO, "com.rapid_i.deployment.update.client.UpdateManager.updating_package_id", desc2.getPackageId());
                        try {
                            this.updatePlugin(extension, this.openStream(url, progressListener, minProgress, maxProgress), desc2.getVersion(), urlString + "?md5");
                            successful = true;
                        }
                        catch (ChecksumException | IOException e) {
                            ++failedLoads;
                            this.reportChecksumOrDownloadError(e, desc2.getName());
                        }
                    }
                    if (successful) {
                        installedPackage.add(desc2);
                        extension.addAndSelectVersion(desc2.getVersion());
                    } else if (baseVersion == null) {
                        ManagedExtension.remove((String)desc2.getPackageId());
                    }
                } else if ("STAND_ALONE".equals(desc2.getPackageTypeName())) {
                    if (DEVELOPMENT_BUILD || MarketplaceUpdateManager.useOSXUpdateMechansim()) {
                        if (!DEVELOPMENT_BUILD) continue;
                        SwingTools.showVerySimpleErrorMessageAndWait((String)"update_error_development_build", (Object[])new Object[0]);
                        continue;
                    }
                    URL url = MarketplaceUpdateManager.getUpdateServerURI(urlString + (String)(incremental ? BASE_VERSION_QUERY + URLEncoder.encode(RapidMiner.getLongTechnicalVersion(), "UTF-8") : "")).toURL();
                    LogService.getRoot().info("com.rapid_i.deployment.update.client.UpdateManager.updating_rapidminer_core");
                    try {
                        this.updateRapidMiner(this.openStream(url, progressListener, minProgress, maxProgress), desc2.getVersion(), urlString + (String)(incremental ? BASE_VERSION_QUERY + URLEncoder.encode(RapidMiner.getLongTechnicalVersion(), "UTF-8") + "&md5" : "?md5"));
                        installedPackage.add(desc2);
                    }
                    catch (ChecksumException | IOException e) {
                        ++failedLoads;
                        this.reportChecksumOrDownloadError(e, desc2.getName());
                    }
                } else {
                    SwingTools.showVerySimpleErrorMessageAndWait((String)"updatemanager.unknown_package_type", (Object[])new Object[]{desc2.getName(), desc2.getPackageTypeName()});
                }
                ++i;
                progressListener.setCompleted(maxProgress);
                minProgress = maxProgress;
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        finally {
            progressListener.complete();
        }
        if (failedLoads > 0) {
            String errorKey = "updatemanager." + (failedLoads == availableDownloads ? "update_failed" : "updates_installed_partially");
            SwingTools.showVerySimpleErrorMessageAndWait((String)errorKey, (Object[])new Object[]{availableDownloads - failedLoads, availableDownloads});
        }
        for (PackageDescriptor p : installedPackage) {
            ActionStatisticsCollector.INSTANCE.log("marketplace", "extension_installation", p.getPackageId());
        }
        return installedPackage;
    }

    private void reportChecksumOrDownloadError(Exception e, String failedPackageName) {
        String errorKey = e instanceof ChecksumException ? "update_md5_error" : (e instanceof IOException ? "error_downloading_package" : "");
        LogService.getRoot().log(Level.INFO, I18N.getMessage((ResourceBundle)LogService.getRoot().getResourceBundle(), (String)"com.rapid_i.deployment.update.client.UpdateManager.md5_failed", (Object[])new Object[]{failedPackageName, e.getMessage()}), e);
        try {
            SwingUtilities.invokeAndWait(() -> {
                ExtendedErrorDialog dialog = new ExtendedErrorDialog((Window)RapidMinerGUI.getMainFrame(), errorKey, (Throwable)e, true, new Object[]{failedPackageName, e.getMessage()});
                dialog.setModal(true);
                dialog.setVisible(true);
            });
        }
        catch (InvocationTargetException e1) {
            LogService.getRoot().log(Level.WARNING, "Error showing error message: " + e, e);
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePlugin(ManagedExtension extension, InputStream updateIn, String newVersion, String md5Adress) throws IOException, ChecksumException {
        File outFile = extension.getDestinationFile(newVersion);
        FileOutputStream out = new FileOutputStream(outFile);
        try {
            IOTools.copyStreamSynchronously((InputStream)updateIn, (OutputStream)out, (boolean)true);
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException iOException) {}
        }
        if (!this.compareMD5(outFile, md5Adress)) {
            Tools.delete((File)outFile);
            throw new ChecksumException();
        }
    }

    private void updateRapidMiner(InputStream openStream, String version, String md5adress) throws IOException, ChecksumException {
        File updateRootDir;
        if (DEVELOPMENT_BUILD) {
            SwingTools.showVerySimpleErrorMessage((String)"update_error_development_build", (Object[])new Object[0]);
        }
        if (!(updateRootDir = DirectoryService.resolveWorkingDir((String)"update", (String[])new String[0]).toFile()).exists() && !updateRootDir.mkdir()) {
            throw new IOException("Cannot create update directory. Please ensure you have administrator permissions.");
        }
        if (!updateRootDir.canWrite()) {
            throw new IOException("Cannot write to update directory. Please ensure you have administrator permissions.");
        }
        File updateFile = new File(updateRootDir, "rmupdate-" + version + ".jar");
        IOTools.copyStreamSynchronously((InputStream)openStream, (OutputStream)new FileOutputStream(updateFile), (boolean)true);
        if (!this.compareMD5(updateFile, md5adress)) {
            Tools.delete((File)updateFile);
            Tools.delete((File)updateRootDir);
            throw new ChecksumException();
        }
        File ruInstall = new File(updateRootDir, "RUinstall");
        try (ZipFile zip = new ZipFile(updateFile);){
            Enumeration<? extends ZipEntry> en = zip.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if ("META-INF/UPDATE".equals(name)) {
                    IOTools.copyStreamSynchronously((InputStream)zip.getInputStream(entry), (OutputStream)new FileOutputStream(new File(updateRootDir, "UPDATE")), (boolean)true);
                    continue;
                }
                if (name.startsWith("rapidminer/")) {
                    name = name.substring("rapidminer/".length());
                } else if (name.startsWith("rapidminer-studio/")) {
                    name = name.substring("rapidminer-studio/".length());
                }
                File dest = new File(ruInstall, name);
                File parent = dest.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                IOTools.copyStreamSynchronously((InputStream)zip.getInputStream(entry), (OutputStream)new FileOutputStream(dest), (boolean)true);
            }
        }
        updateFile.delete();
        LogService.getRoot().log(Level.INFO, "com.rapid_i.deployment.update.client.UpdateManager.prepared_rapidminer_for_update");
    }

    private void updatePluginIncrementally(ManagedExtension extension, InputStream diffJarIn, String fromVersion, String newVersion, String md5Adress) throws IOException, ChecksumException {
        ByteArrayOutputStream diffJarBuffer = new ByteArrayOutputStream();
        IOTools.copyStreamSynchronously((InputStream)diffJarIn, (OutputStream)diffJarBuffer, (boolean)true);
        byte[] downloadedFile = diffJarBuffer.toByteArray();
        LogService.getRoot().log(Level.FINE, "com.rapid_i.deployment.update.client.UpdateManager.downloaded_incremental_zip");
        InMemoryZipFile diffJar = new InMemoryZipFile(downloadedFile);
        if (!this.compareMD5(downloadedFile, md5Adress)) {
            throw new ChecksumException();
        }
        HashSet<String> toDelete = new HashSet<String>();
        byte[] updateEntry = diffJar.getContents("META-INF/UPDATE");
        if (updateEntry == null) {
            throw new IOException("META-INFO/UPDATE entry missing");
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(updateEntry);
             InputStreamReader isr = new InputStreamReader((InputStream)bais, "UTF-8");
             BufferedReader updateReader = new BufferedReader(isr);){
            String line;
            while ((line = updateReader.readLine()) != null) {
                String[] split = line.split(" ", 2);
                if (split.length != 2) {
                    diffJarBuffer.close();
                    throw new IOException("Illegal entry in update script: " + line);
                }
                if ("DELETE".equals(split[0])) {
                    toDelete.add(split[1].trim());
                    continue;
                }
                diffJarBuffer.close();
                throw new IOException("Illegal entry in update script: " + line);
            }
        }
        LogService.getRoot().log(Level.FINE, "com.rapid_i.deployment.update.client.UpdateManager.extracted_update_script", toDelete.size());
        HashSet<String> allNames = new HashSet<String>();
        allNames.addAll(diffJar.entryNames());
        try (JarFile fromJar = extension.findArchive(fromVersion);){
            Enumeration<JarEntry> e = fromJar.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                allNames.add(entry.getName());
            }
            LogService.getRoot().log(Level.INFO, "com.rapid_i.deployment.update.client.UpdateManager.extracted_entry_names", allNames.size());
            File newFile = extension.getDestinationFile(newVersion);
            try (FileOutputStream fos = new FileOutputStream(newFile);
                 ZipOutputStream newJar = new ZipOutputStream(fos);
                 JarFile oldArchive = extension.findArchive();){
                for (String name : allNames) {
                    if (toDelete.contains(name)) {
                        LogService.getRoot().log(Level.FINEST, "com.rapid_i.deployment.update.client.UpdateManager.delete_name", name);
                        continue;
                    }
                    newJar.putNextEntry(new ZipEntry(name));
                    if (diffJar.containsEntry(name)) {
                        newJar.write(diffJar.getContents(name));
                        LogService.getRoot().log(Level.FINEST, "com.rapid_i.deployment.update.client.UpdateManager.update_name", name);
                    } else {
                        ZipEntry oldEntry = ((ZipFile)oldArchive).getEntry(name);
                        IOTools.copyStreamSynchronously((InputStream)((ZipFile)oldArchive).getInputStream(oldEntry), (OutputStream)newJar, (boolean)false);
                        LogService.getRoot().log(Level.FINEST, "com.rapid_i.deployment.update.client.UpdateManager.store_name", name);
                    }
                    newJar.closeEntry();
                }
                newJar.finish();
            }
        }
    }

    public static String getBaseUrl() {
        String property = ParameterService.getParameterValue((String)"rapidminer.update.url");
        if (property == null) {
            return "https://marketplace.rapidminer.com/UpdateServer";
        }
        if (property.equals("http://marketplace.rapid-i.com:80/UpdateServer")) {
            property = "https://marketplace.rapidminer.com/UpdateServer";
            ParameterService.setParameterValue((String)"rapidminer.update.url", (String)"https://marketplace.rapidminer.com/UpdateServer");
        }
        return property;
    }

    public static URI getUpdateServerURI(String suffix) throws URISyntaxException {
        return new URI(MarketplaceUpdateManager.getBaseUrl() + suffix);
    }

    public static boolean isIncrementalUpdate() {
        return !"false".equals(ParameterService.getParameterValue((String)"rapidminer.update.incremental"));
    }

    public static synchronized UpdateService getService() throws URISyntaxException, IOException {
        URI uri = MarketplaceUpdateManager.getUpdateServerURI("/UpdateServiceService?wsdl");
        if (theService == null || lastUsedUri != null && !lastUsedUri.equals(uri)) {
            UpdateServiceService uss;
            try {
                uss = new UpdateServiceService(uri.toURL(), new QName("http://ws.update.deployment.rapid_i.com/", "UpdateServiceService"));
            }
            catch (RuntimeException e) {
                throw new IOException(e);
            }
            try {
                theService = uss.getUpdateServicePort();
            }
            catch (Error e) {
                throw new IOException(e);
            }
        }
        lastUsedUri = uri;
        return theService;
    }

    public static synchronized void resetService() {
        lastUsedUri = null;
        theService = null;
    }

    public static boolean isAccountServiceCreated() {
        return accountService != null;
    }

    public static void clearAccountSerive() {
        accountService = null;
        WebServiceTools.clearAuthCache();
    }

    public static synchronized AccountService getAccountService() throws MalformedURLException, URISyntaxException {
        URI uri = MarketplaceUpdateManager.getUpdateServerURI("/AccountService?wsdl");
        if (accountService == null) {
            AccountServiceService ass = new AccountServiceService(uri.toURL(), new QName("http://ws.update.deployment.rapid_i.com/", "AccountServiceService"));
            accountService = ass.getAccountServicePort();
        }
        return accountService;
    }

    public static void saveLastUpdateCheckDate() {
        File file = DirectoryService.resolveWorkingDir((String)"updatecheck.date", (String[])new String[0]).toFile();
        try (FileWriter fw = new FileWriter(file);
             PrintWriter out = new PrintWriter(fw);){
            out.println(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to save update timestamp: " + e, e);
        }
    }

    private String getServerMD5(InputStream md5Stream) throws IOException {
        byte[] md5Hash = new byte[]{};
        try {
            ByteArrayOutputStream md5Buffer = new ByteArrayOutputStream();
            IOTools.copyStreamSynchronously((InputStream)md5Stream, (OutputStream)md5Buffer, (boolean)true);
            md5Hash = md5Buffer.toByteArray();
        }
        catch (IOException e) {
            md5Stream.close();
            throw new IOException("failure while downloading the hash from Server: " + e.getMessage());
        }
        return new String(md5Hash);
    }

    private boolean compareMD5(File toCompare, String urlString) {
        if (urlString == null || toCompare == null || urlString.isEmpty()) {
            throw new IllegalArgumentException("parameter is empty");
        }
        try {
            String serverMD5;
            String localMD5 = MarketplaceUpdateManager.getMD5hash(toCompare);
            URL url = MarketplaceUpdateManager.getUpdateServerURI(urlString).toURL();
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            WebServiceTools.setURLConnectionDefaults((URLConnection)con);
            con.setDoInput(true);
            con.setDoOutput(false);
            try {
                serverMD5 = this.getServerMD5(con.getInputStream());
            }
            catch (IOException e) {
                throw new IOException(con.getResponseCode() + ": " + con.getResponseMessage(), e);
            }
            return serverMD5.compareTo(localMD5) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean compareMD5(byte[] toCompare, String urlString) {
        if (urlString == null || toCompare == null || urlString.isEmpty()) {
            throw new IllegalArgumentException("parameter is empty");
        }
        String localMD5 = MarketplaceUpdateManager.getMD5hash(toCompare);
        try {
            String serverMD5;
            URL url = MarketplaceUpdateManager.getUpdateServerURI(urlString).toURL();
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            WebServiceTools.setURLConnectionDefaults((URLConnection)con);
            con.setDoInput(true);
            con.setDoOutput(false);
            try {
                serverMD5 = this.getServerMD5(con.getInputStream());
            }
            catch (IOException e) {
                throw new IOException(con.getResponseCode() + ": " + con.getResponseMessage(), e);
            }
            return serverMD5.compareTo(localMD5) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getMD5hash(File toHash) throws FileNotFoundException {
        return MarketplaceUpdateManager.getMD5hash(new FileInputStream(toHash));
    }

    public static String getMD5hash(byte[] toHash) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(toHash, 0, toHash.length);
            byte[] md5sum = digest.digest();
            StringBuilder hex = new StringBuilder();
            for (byte one : md5sum) {
                hex.append(Integer.toHexString(one & 0xFF | 0x100).toLowerCase().substring(1, 3));
            }
            return hex.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("No implementation of MD5 found.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMD5hash(InputStream toHash) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            int read = 0;
            try {
                while ((read = toHash.read(buffer)) > 0) {
                    digest.update(buffer, 0, read);
                }
                byte[] md5sum = digest.digest();
                StringBuilder hex = new StringBuilder();
                for (byte one : md5sum) {
                    hex.append(Integer.toHexString(one & 0xFF | 0x100).toLowerCase().substring(1, 3));
                }
                String string = hex.toString();
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to process file for MD5", e);
            }
            finally {
                try {
                    toHash.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close input stream for MD5 calculation", e);
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("No implementation of MD5 found.");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Date loadLastUpdateCheckDate() {
        File file = DirectoryService.resolveWorkingDir((String)"updatecheck.date", (String[])new String[0]).toFile();
        if (!file.exists()) {
            return null;
        }
        try (FileReader fr = new FileReader(file);){
            String date;
            BufferedReader in;
            block15: {
                Date date2;
                in = new BufferedReader(fr);
                try {
                    date = in.readLine();
                    if (date != null) break block15;
                    date2 = null;
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                in.close();
                return date2;
            }
            Date date3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date);
            in.close();
            return date3;
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, I18N.getMessage((ResourceBundle)LogService.getRoot().getResourceBundle(), (String)"com.rapid_i.deployment.update.client.UpdateManager.reading_update_check_error", (Object[])new Object[0]), e);
            return null;
        }
    }

    public static void checkForUpdates() {
        if (Telemetry.MARKETPLACE.isDenied()) {
            LogService.getRoot().config("com.rapidminer.deployment.update.client.UpdateManager.accessing_online_services_disallowed");
            return;
        }
        String updateProperty = ParameterService.getParameterValue((String)"rapidminer.update.check");
        BooleanSupplier allowUpdate = () -> Boolean.valueOf(ParameterService.getParameterValue((String)"rapidminer.disallow.studio.update")) == false;
        if (!Tools.booleanValue((String)updateProperty, (boolean)true) || !allowUpdate.getAsBoolean()) {
            return;
        }
        boolean check = true;
        final Date lastCheckDate = MarketplaceUpdateManager.loadLastUpdateCheckDate();
        if (lastCheckDate != null) {
            Calendar lastCheck = Calendar.getInstance();
            lastCheck.setTime(lastCheckDate);
            Calendar currentDate = Calendar.getInstance();
            currentDate.add(6, -1);
            if (!lastCheck.before(currentDate)) {
                check = false;
                LogService.getRoot().log(Level.CONFIG, "com.rapid_i.deployment.update.client.UpdateManager.ignoring_update_check_last_checkdate", lastCheckDate);
            }
        }
        if (!check) {
            return;
        }
        new ProgressThread("check_for_updates"){

            public void run() {
                String latestRMVersion;
                LogService.getRoot().info("com.rapid_i.deployment.update.client.UpdateManager.update_checking");
                boolean updatesExist = false;
                try {
                    latestRMVersion = MarketplaceUpdateManager.getService().getLatestVersion("rapidminer-studio-6", TARGET_PLATFORM.toString(), RapidMiner.getLongTechnicalVersion());
                    updatesExist = latestRMVersion != null && !RapidMiner.getTechnicalVersion().isAtLeast(new VersionNumber(latestRMVersion));
                }
                catch (Exception e) {
                    LogService.getRoot().log(Level.WARNING, I18N.getMessage((ResourceBundle)LogService.getRoot().getResourceBundle(), (String)"com.rapid_i.deployment.update.client.UpdateManager.checking_for_updates_error", (Object[])new Object[]{e}), e);
                    return;
                }
                MarketplaceUpdateManager.saveLastUpdateCheckDate();
                if (updatesExist) {
                    String newVersion;
                    try {
                        newVersion = new VersionNumber(latestRMVersion).toString();
                    }
                    catch (VersionNumber.VersionNumberException e) {
                        newVersion = latestRMVersion;
                    }
                    UpdateConfirmDialog dialog = new UpdateConfirmDialog(newVersion);
                    dialog.setVisible(true);
                } else {
                    LogService.getRoot().log(Level.INFO, "com.rapid_i.deployment.update.client.UpdateManager.no_updates_aviable", lastCheckDate);
                }
            }
        }.start();
    }

    protected static boolean useOSXUpdateMechansim() {
        return PlatformUtilities.getReleasePlatform() == PlatformUtilities.Platform.OSX;
    }

    protected static void openOSXDownloadURL() {
        RMUrlHandler.openInBrowser((String)I18N.getGUILabel((String)"update.osx.url", (Object[])new Object[0]));
    }

    public void installSelectedPackages(List<String> selectedPackages) {
        UpdateDialog updateDialog = new UpdateDialog(selectedPackages.toArray(new String[selectedPackages.size()]));
        updateDialog.installSelectedPackages();
    }

    public void showUpdateDialog(boolean selectUpdateTab, String ... preselectedExtensions) {
        UpdateDialog.showUpdateDialog(selectUpdateTab, null, preselectedExtensions);
    }

    public String getExtensionIdForOperatorPrefix(String forPrefix) throws MalformedURLException, URISyntaxException, IOException {
        try {
            return MarketplaceUpdateManager.getService().getRapidMinerExtensionForOperatorPrefix(forPrefix);
        }
        catch (RuntimeException e) {
            throw new IOException("Unable to connect to the RapidMiner Marketplace.", e);
        }
    }

    public String getLatestVersion(String extensionId, String targetPlatform, String rapidMinerStudioVersion) throws MalformedURLException, URISyntaxException, IOException {
        try {
            return MarketplaceUpdateManager.getService().getLatestVersion(extensionId, targetPlatform, rapidMinerStudioVersion);
        }
        catch (UpdateServiceException_Exception | RuntimeException e) {
            throw new IOException("Unable to connect to the RapidMiner Marketplace.", e);
        }
    }

    public String getExtensionName(String extensionId, String latestVersion, String targetPlatform) throws MalformedURLException, URISyntaxException, IOException {
        PackageDescriptor desc;
        try {
            desc = MarketplaceUpdateManager.getService().getPackageInfo(extensionId, latestVersion, targetPlatform);
        }
        catch (UpdateServiceException_Exception | RuntimeException e) {
            throw new IOException("Unable to connect to the RapidMiner Marketplace.", e);
        }
        if (desc != null) {
            return desc.getName();
        }
        return null;
    }

    static {
        PlatformUtilities.Platform platform = PlatformUtilities.getReleasePlatform();
        if (platform == null || RapidMiner.getDisplayVersion().isDevelopmentBuild()) {
            LogService.getRoot().log(Level.WARNING, "com.rapid_i.deployment.update.client.UpdateManager.error_development_build");
            TARGET_PLATFORM = PlatformUtilities.Platform.ANY;
            DEVELOPMENT_BUILD = true;
        } else {
            TARGET_PLATFORM = platform == PlatformUtilities.Platform.OSX ? PlatformUtilities.Platform.ANY : platform;
            DEVELOPMENT_BUILD = false;
        }
        theService = null;
        lastUsedUri = null;
        packageIdRapidMiner = "rapidminer-studio-6";
    }
}

