/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client;

import com.rapidminer.RapidMiner;
import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.deployment.client.wsimport.UpdateService;
import com.rapidminer.deployment.update.client.MarketplaceUpdateManager;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.FileUtils;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.plugin.Dependency;
import com.rapidminer.tools.plugin.ManagedExtension;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PackageDescriptorCache {
    private final Map<String, PackageDescriptor> descriptors = new HashMap<String, PackageDescriptor>();
    private final Map<String, String> packageChanges = new HashMap<String, String>();
    private UpdateService updateService = null;
    private Exception lastException = null;

    public PackageDescriptor getPackageInfo(String packageId) {
        if (this.descriptors.containsKey(packageId)) {
            return this.descriptors.get(packageId);
        }
        this.fetchPackageInfo(packageId);
        if (this.descriptors.containsKey(packageId)) {
            return this.descriptors.get(packageId);
        }
        return null;
    }

    public String getPackageChanges(String packageId) {
        if (this.packageChanges.containsKey(packageId)) {
            return this.packageChanges.get(packageId);
        }
        try {
            ManagedExtension ext = ManagedExtension.get((String)packageId);
            String installedVersion = ext != null ? ext.getLatestInstalledVersion().getLongVersion() : null;
            PackageDescriptor packageDescriptior = this.descriptors.get(packageId);
            Object fromVersion = "";
            Object toVersion = "";
            if (installedVersion != null) {
                fromVersion = "?baseVersion=" + installedVersion;
            }
            if (packageDescriptior != null && packageDescriptior.getVersion() != null) {
                toVersion = installedVersion == null ? "?" : "&";
                toVersion = (String)toVersion + "toVersion=" + packageDescriptior.getVersion();
            }
            URI changesURI = MarketplaceUpdateManager.getUpdateServerURI("/download/changes/" + packageId + (String)fromVersion + (String)toVersion);
            String changes = FileUtils.readText((InputStream)changesURI.toURL().openStream());
            this.packageChanges.put(packageId, changes);
            return changes;
        }
        catch (Exception e) {
            this.packageChanges.put(packageId, null);
            return null;
        }
    }

    private void fetchPackageInfo(String packageId) {
        this.initUpdateService();
        if (this.updateService != null) {
            try {
                String targetPlatform = MarketplaceUpdateManager.TARGET_PLATFORM.toString();
                if (!"rapidminer-studio-6".equals(packageId)) {
                    targetPlatform = "ANY";
                }
                PackageDescriptor descriptor = this.updateService.getPackageInfo(packageId, this.updateService.getLatestVersion(packageId, targetPlatform, RapidMiner.getLongTechnicalVersion()), targetPlatform);
                this.descriptors.put(packageId, descriptor);
                if (descriptor != null && descriptor.getDependencies() != null) {
                    List dependencies = Dependency.parse((String)descriptor.getDependencies());
                    for (Dependency dependency : dependencies) {
                        this.getPackageInfo(dependency.getPluginExtensionId());
                    }
                }
            }
            catch (Exception e) {
                if (this.lastException == null || e.getMessage() == null || !e.getMessage().equals(this.lastException.getMessage())) {
                    SwingTools.showVerySimpleErrorMessage((String)"failed_update_server", (Object[])new Object[]{e, MarketplaceUpdateManager.getBaseUrl()});
                    this.lastException = e;
                }
                Logger.getLogger(PackageDescriptorCache.class.getName()).log(Level.WARNING, I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.dialog.error.failed_update_server_simple.message", (Object[])new Object[0]));
            }
        }
    }

    private void initUpdateService() {
        if (this.updateService == null) {
            try {
                this.updateService = MarketplaceUpdateManager.getService();
            }
            catch (Exception e) {
                SwingTools.showVerySimpleErrorMessage((String)"failed_update_server", (Object[])new Object[]{e, MarketplaceUpdateManager.getBaseUrl()});
            }
        }
    }

    public UpdateService getUpdateService() {
        this.initUpdateService();
        return this.updateService;
    }

    public boolean hasError() {
        return this.lastException != null;
    }
}

