/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client;

import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.deployment.update.client.AbstractPackageDescriptorListCellRenderer;
import com.rapidminer.gui.look.Colors;
import com.rapidminer.tools.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class PackageListCellRenderer
extends AbstractPackageDescriptorListCellRenderer {
    private static final String DIV_OPEN = "<div>";
    private static final String DIV_OPEN_STYLE = "<div style=";
    private static final String DIV_CLOSE = "</div>";
    private final HashMap<PackageDescriptor, HashSet<PackageDescriptor>> dependencyMap;

    public PackageListCellRenderer(HashMap<PackageDescriptor, HashSet<PackageDescriptor>> dependecyMap) {
        this.dependencyMap = dependecyMap;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel panel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                if (d == null) {
                    return null;
                }
                d.width = 10;
                return d;
            }
        };
        JLabel label = new JLabel();
        panel.setLayout(new FlowLayout(0));
        panel.add(label);
        panel.setOpaque(true);
        if (isSelected && value instanceof PackageDescriptor) {
            panel.setBackground(Colors.TEXT_HIGHLIGHT_BACKGROUND);
        } else {
            panel.setBackground(Colors.TEXTFIELD_BACKGROUND);
        }
        if (value instanceof PackageDescriptor) {
            PackageDescriptor desc = (PackageDescriptor)value;
            Icon packageIcon = this.getResizedIcon(this.getIcon(desc));
            String text = "<html><body style='width: " + (300 - packageIcon.getIconWidth()) + "px;'>";
            text = text + "<div><strong>" + desc.getName() + "</strong> " + desc.getVersion() + DIV_CLOSE;
            String licenseName = desc.getLicenseName().startsWith("custom:") ? I18N.getGUILabel((String)"custom_license_type", (Object[])new Object[0]) : desc.getLicenseName();
            text = text + "<div style='margin-top:5px;'>" + this.getLicenseType(licenseName) + DIV_CLOSE;
            if (this.dependencyMap != null && !this.dependencyMap.get(desc).isEmpty()) {
                text = text + "<div style='margin-top:5px;'>" + this.getSourcePackages(desc) + DIV_CLOSE;
            }
            text = text + "</body></html>";
            label.setIcon(packageIcon);
            label.setVerticalTextPosition(1);
            label.setForeground(Colors.TEXT_HIGHLIGHT_FOREGROUND);
            label.setText(text);
        }
        return panel;
    }

    private String getSourcePackages(PackageDescriptor desc) {
        StringBuilder text = new StringBuilder();
        boolean first = true;
        for (PackageDescriptor dep : this.dependencyMap.get(desc)) {
            if (!first) {
                text.append(", ");
            } else {
                first = false;
            }
            text.append(dep.getName());
        }
        return I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.required_by", (Object[])new Object[]{text.toString()});
    }

    private String getLicenseType(String licenseName) {
        return I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.license_type", (Object[])new Object[]{licenseName});
    }
}

