/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client;

import com.rapidminer.deployment.update.client.MarketplaceUpdateManager;
import com.rapidminer.deployment.update.client.UpdateDialog;
import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.renderer.html.HTMLRenderer;
import com.rapidminer.gui.renderer.html.HTMLRendererRegistry;
import com.rapidminer.gui.tools.MultiSwingWorker;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.gui.tools.dialogs.ConfirmDialog;
import com.rapidminer.tools.FontTools;
import com.rapidminer.tools.update.internal.UpgradeNotificationService;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;

public class UpdateConfirmDialog
extends ConfirmDialog {
    private static final long serialVersionUID = 1L;
    private static final String LOOK_AND_FEEL_CSS = "*{cursor: default;} a{cursor: initial;} body{-webkit-touch-callout: none; -webkit-user-select: none; padding: 10px 18px; margin: 0px; display: inline-block; background-color: rgba(%1$d, %2$d, %3$d , %4$.2f); font-family: \"%5$s\", \"Helvetica Neue\", \"Segoe UI\"; font-size: %6$spx;}";
    private static final Logger LOGGER = Logger.getLogger(UpdateConfirmDialog.class.getName());
    private static final double FONT_SCALE = MarketplaceUpdateManager.useOSXUpdateMechansim() ? 1.0 : 1.1;
    private static final float COLOR_CONVERSION = 255.0f;
    private boolean isVisible = false;
    private boolean isLoaded = false;
    private transient HTMLRenderer htmlRenderer;

    UpdateConfirmDialog(String rmVersion) {
        super((Window)ApplicationFrame.getApplicationFrame(), MarketplaceUpdateManager.useOSXUpdateMechansim() ? "updates_exist_osx" : "updates_exist", 0, false, new Object[]{rmVersion});
        new LoadAndDisplayHTMLMessage(new VersionNumber(rmVersion)).start();
    }

    private String getLookAndFeelCss() {
        Font font = FontTools.getFont((String)this.getFont().getFamily(), (int)this.getFont().getStyle(), (int)this.getFont().getSize());
        Color color = this.getContentPane().getBackground();
        return String.format(LOOK_AND_FEEL_CSS, color.getRed(), color.getGreen(), color.getBlue(), Float.valueOf((float)color.getAlpha() / 255.0f), font.getFamily(), (double)font.getSize() * FONT_SCALE);
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
        if (!visible) {
            super.setVisible(false);
        } else {
            this.updateVisibility();
        }
    }

    private void setLoaded() {
        this.isLoaded = true;
        this.updateVisibility();
    }

    private void updateVisibility() {
        if (this.isVisible && this.isLoaded) {
            super.setVisible(true);
        }
    }

    protected JButton makeYesButton() {
        String i18n = MarketplaceUpdateManager.useOSXUpdateMechansim() ? "update.osx.confirm.yes" : "update.confirm.yes";
        JButton yesButton = new JButton((Action)new ResourceAction(i18n, new Object[0]){
            private static final long serialVersionUID = -8887199234055845095L;

            public void loggedActionPerformed(ActionEvent e) {
                UpdateConfirmDialog.this.returnOption = 0;
                UpdateConfirmDialog.this.yes();
                if (MarketplaceUpdateManager.useOSXUpdateMechansim()) {
                    MarketplaceUpdateManager.openOSXDownloadURL();
                } else {
                    UpdateDialog.showUpdateDialog(true, null, new String[0]);
                }
            }
        });
        this.getRootPane().setDefaultButton(yesButton);
        return yesButton;
    }

    protected JButton makeNoButton() {
        return this.makeNoButtonInternal("update.confirm.no");
    }

    public void dispose() {
        try (HTMLRenderer autoCloseable = this.htmlRenderer;){
            super.dispose();
        }
    }

    private class LoadAndDisplayHTMLMessage
    extends MultiSwingWorker<String, VersionNumber> {
        private final VersionNumber versionNumber;

        LoadAndDisplayHTMLMessage(VersionNumber targetVersion) {
            this.versionNumber = targetVersion;
        }

        protected String doInBackground() {
            return UpgradeNotificationService.INSTANCE.getMessage(this.versionNumber);
        }

        protected void done() {
            Object message = null;
            try {
                message = (String)this.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.log(Level.FINE, "Loading of the Upgrade Message failed.", e);
            }
            if (message == null || ((String)message).trim().isEmpty()) {
                UpdateConfirmDialog.this.setLoaded();
                return;
            }
            String css = "<style>" + UpdateConfirmDialog.this.getLookAndFeelCss() + "</style>";
            String headTag = "<head>";
            message = ((String)message).contains("<head>") ? ((String)message).replace("<head>", "<head>" + css) : css + (String)message;
            UpdateConfirmDialog.this.htmlRenderer = HTMLRendererRegistry.HTML.getRenderer((String)message);
            JComponent view = UpdateConfirmDialog.this.htmlRenderer.getComponent();
            view.setPreferredSize(new Dimension(50, 50));
            UpdateConfirmDialog.this.add(view, "Center");
            UpdateConfirmDialog.this.revalidate();
            UpdateConfirmDialog.this.pack();
            UpdateConfirmDialog.this.setDefaultLocation();
            UpdateConfirmDialog.this.setLoaded();
        }
    }
}

