/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client;

import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.deployment.client.wsimport.UpdateService;
import com.rapidminer.deployment.update.client.ConfirmLicensesDialog;
import com.rapidminer.deployment.update.client.MarketplaceUpdateManager;
import com.rapidminer.deployment.update.client.PackageDescriptorCache;
import com.rapidminer.deployment.update.client.UpdatePackagesModel;
import com.rapidminer.deployment.update.client.UpdatePanel;
import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.MarketplaceDialogAction;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ProgressThreadStoppedException;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.NetTools;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.plugin.Dependency;
import com.rapidminer.tools.plugin.ManagedExtension;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.ws.WebServiceException;

public class UpdateDialog
extends ButtonDialog {
    private static final long serialVersionUID = 1L;
    public static final Action UPDATE_ACTION;
    public static final Action UPDATE_TAB_ACTION;
    private final UpdatePanel ulp;
    private final UpdatePackagesModel updateModel;
    private InstallButton installButton;
    private final PackageDescriptorCache packageDescriptorCache = new PackageDescriptorCache();
    private boolean isConfirmed = false;
    private List<PackageDescriptor> installablePackageList;
    private final JButton closeButton;

    public UpdateDialog(String[] preselectedExtensions) {
        this(false, preselectedExtensions);
    }

    public UpdateDialog(boolean onlyUpdateTab, String[] preselectedExtensions) {
        super((Window)ApplicationFrame.getApplicationFrame(), "update", Dialog.ModalityType.APPLICATION_MODAL, new Object[0]);
        this.updateModel = new UpdatePackagesModel(this.packageDescriptorCache);
        this.ulp = new UpdatePanel(this, this.packageDescriptorCache, preselectedExtensions, this.updateModel, onlyUpdateTab);
        this.closeButton = this.makeCloseButton();
        this.layoutDefault(this.ulp, 9, new AbstractButton[]{this.makeOkButton(), this.closeButton});
    }

    protected JButton makeOkButton(String i18nKey) {
        ResourceAction okAction = new ResourceAction(i18nKey, new Object[0]){
            private static final long serialVersionUID = 1L;

            public void loggedActionPerformed(ActionEvent e) {
                UpdateDialog.this.wasConfirmed = true;
                UpdateDialog.this.ok();
            }
        };
        this.installButton = new InstallButton((Action)okAction);
        this.getRootPane().setDefaultButton(this.installButton);
        this.installButton.setEnabled(false);
        this.updateModel.addObserver(this.installButton);
        return this.installButton;
    }

    protected JPanel makeButtonPanel(AbstractButton ... buttons) {
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel buttonPanelRight = new JPanel(new FlowLayout(2, 6, 6));
        for (AbstractButton button : buttons) {
            if (button == null) continue;
            buttonPanelRight.add(button);
        }
        buttonPanel.add((Component)buttonPanelRight, "Center");
        return buttonPanel;
    }

    public void installSelectedPackages() {
        this.ulp.startUpdate();
    }

    public static void showUpdateDialogForSpecificExtension(final String extensionId) {
        new ProgressThread("open_marketplace_dialog", true){

            public void run() {
                this.getProgressListener().setTotal(100);
                this.getProgressListener().setCompleted(33);
                if (!UpdateDialog.prepareMarketplaceService()) {
                    return;
                }
                this.getProgressListener().setCompleted(66);
                SwingUtilities.invokeLater(() -> {
                    UpdateDialog updateDialog = new UpdateDialog(new String[0]);
                    updateDialog.displayExtensionById(extensionId);
                    updateDialog.setVisible(true);
                });
                this.getProgressListener().complete();
            }
        }.start();
    }

    public static void showUpdateDialog(final boolean selectUpdateTab, final String keyword, final String ... preselectedExtensions) {
        new ProgressThread("open_marketplace_dialog", true){

            public void run() {
                this.getProgressListener().setTotal(100);
                this.getProgressListener().setCompleted(33);
                if (!UpdateDialog.prepareMarketplaceService()) {
                    return;
                }
                this.getProgressListener().setCompleted(66);
                LinkedList<String> preselected = null;
                if (preselectedExtensions != null) {
                    preselected = new LinkedList<String>();
                    PackageDescriptorCache tempCache = new PackageDescriptorCache();
                    for (String preSelExtId : preselectedExtensions) {
                        VersionNumber installed;
                        ManagedExtension ext;
                        PackageDescriptor desc = tempCache.getPackageInfo(preSelExtId);
                        if (desc != null && (ext = ManagedExtension.get((String)desc.getPackageId())) != null && (installed = ext.getLatestInstalledVersion()) != null) {
                            VersionNumber other = null;
                            try {
                                other = new VersionNumber(desc.getVersion());
                            }
                            catch (VersionNumber.VersionNumberException vne) {
                                LogService.getRoot().log(Level.WARNING, "com.rapidminer.deployment.update.client.UpdateDialog.malformed_version", new Object[]{desc.getName(), desc.getPackageId(), vne.getLocalizedMessage()});
                            }
                            boolean upToDate = installed.isAtLeast(other);
                            if (upToDate) {
                                if (preselectedExtensions.length != 1) continue;
                                HashSet<String> installSet = new HashSet<String>(Arrays.asList(preselectedExtensions));
                                Set<Dependency> dependencies = UpdateDialog.collectDependency(desc, installSet, tempCache);
                                if (dependencies.isEmpty()) {
                                    SwingTools.showMessageDialog((String)"marketplace.extension_up_to_date", (Object[])new Object[]{desc.getName()});
                                    this.getProgressListener().complete();
                                    return;
                                }
                            }
                        }
                        preselected.add(preSelExtId);
                    }
                }
                String[] preSelExts = preselected != null ? preselected.toArray(new String[0]) : preselectedExtensions;
                this.getProgressListener().setCompleted(100);
                SwingUtilities.invokeLater(() -> {
                    final UpdateDialog updateDialog = new UpdateDialog(preSelExts);
                    if (selectUpdateTab) {
                        updateDialog.showUpdateTab();
                    } else if (keyword != null) {
                        updateDialog.search(keyword);
                        updateDialog.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowOpened(WindowEvent e) {
                                updateDialog.ok();
                            }
                        });
                    }
                    if (preSelExts != null && preSelExts.length > 0) {
                        updateDialog.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowOpened(WindowEvent e) {
                                updateDialog.ok();
                            }
                        });
                    }
                    updateDialog.setVisible(true);
                });
                this.getProgressListener().complete();
            }
        }.start();
    }

    private void showUpdateTab() {
        this.ulp.selectUpdatesTab();
    }

    private void displayExtensionById(String extensionId) {
        this.ulp.displayExtensionById(extensionId);
    }

    private static boolean prepareMarketplaceService() {
        try {
            MarketplaceUpdateManager.resetService();
            MarketplaceUpdateManager.getService();
            return true;
        }
        catch (WebServiceException e) {
            SwingTools.showVerySimpleErrorMessage((String)"failed_update_server_simple", (Object[])new Object[0]);
            LogService.getRoot().log(Level.WARNING, "com.rapid_i.deployment.update.client.UpdateDialog.could_not_connect", e);
            return false;
        }
        catch (Exception e) {
            SwingTools.showSimpleErrorMessage((String)"failed_update_server", (Throwable)e, (Object[])new Object[]{MarketplaceUpdateManager.getBaseUrl()});
            LogService.getRoot().log(Level.WARNING, "com.rapid_i.deployment.update.client.UpdateDialog.could_not_connect", e);
            return false;
        }
    }

    public void startUpdate(final List<PackageDescriptor> downloadList) {
        this.installButton.setEnabled(false);
        new ProgressThread("resolving_dependencies", true){

            public void run() {
                try {
                    SwingUtilities.invokeLater(() -> UpdateDialog.this.closeButton.setEnabled(false));
                    this.getProgressListener().setTotal(100);
                    Map<PackageDescriptor, Set<PackageDescriptor>> dependency = UpdateDialog.resolveDependency(downloadList, UpdateDialog.this.packageDescriptorCache);
                    UpdateDialog.this.installablePackageList = UpdateDialog.getPackagesForInstallation(dependency);
                    this.getProgressListener().setCompleted(30);
                    if (!UpdateDialog.this.installablePackageList.isEmpty()) {
                        Map<String, String> licenseNameToLicenseTextMap = UpdateDialog.collectLicenses(UpdateDialog.this.installablePackageList, this.getProgressListener());
                        SwingUtilities.invokeLater(() -> {
                            UpdateDialog.this.isConfirmed = ConfirmLicensesDialog.confirm((Dialog)((Object)UpdateDialog.this), dependency, licenseNameToLicenseTextMap);
                            new ProgressThread("installing_updates", true){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    try {
                                        if (UpdateDialog.this.isConfirmed) {
                                            this.getProgressListener().setTotal(100);
                                            this.getProgressListener().setCompleted(20);
                                            UpdateService service = MarketplaceUpdateManager.getService();
                                            MarketplaceUpdateManager um = new MarketplaceUpdateManager(service);
                                            List<PackageDescriptor> installedPackages = um.performUpdates(UpdateDialog.this.installablePackageList, this.getProgressListener());
                                            UpdateDialog.this.updateModel.clearFromSelectionMap(installedPackages);
                                            UpdateDialog.this.ulp.validate();
                                            UpdateDialog.this.ulp.repaint();
                                            new Thread(() -> {
                                                if (installedPackages.size() > 0) {
                                                    int confirmation = SwingTools.showConfirmDialog((Window)((Object)UpdateDialog.this), (String)(installedPackages.size() == 1 ? "update.complete_restart" : "update.complete_restart1"), (int)0, (Object[])new Object[]{installedPackages.size()});
                                                    if (confirmation == 0) {
                                                        RapidMinerGUI.getMainFrame().exit(true);
                                                    } else if (confirmation == 1 && installedPackages.size() == UpdateDialog.this.installablePackageList.size()) {
                                                        UpdateDialog.this.dispose();
                                                    }
                                                }
                                            }).start();
                                        }
                                    }
                                    catch (ProgressThreadStoppedException service) {
                                    }
                                    catch (Exception e) {
                                        SwingTools.showSimpleErrorMessage((Window)((Object)UpdateDialog.this), (String)"error_installing_update", (Throwable)e, (Object[])new Object[]{e.getMessage()});
                                    }
                                    finally {
                                        this.getProgressListener().complete();
                                        UpdateDialog.this.installButton.setEnabled(true);
                                    }
                                }
                            }.start();
                        });
                    }
                    SwingUtilities.invokeLater(() -> UpdateDialog.this.closeButton.setEnabled(true));
                }
                catch (Exception e) {
                    SwingTools.showSimpleErrorMessage((Window)((Object)UpdateDialog.this), (String)"error_resolving_dependencies", (Throwable)e, (Object[])new Object[]{e.getMessage()});
                }
                finally {
                    this.getProgressListener().complete();
                    if (UpdateDialog.this.installablePackageList != null && !UpdateDialog.this.installablePackageList.isEmpty()) {
                        UpdateDialog.this.installButton.setEnabled(true);
                    }
                }
            }
        }.start();
    }

    protected void ok() {
        this.ulp.startUpdate();
    }

    private static Map<String, String> collectLicenses(List<PackageDescriptor> installablePackageList, ProgressListener progressListener) throws URISyntaxException, IOException {
        int start = 30;
        int end = 100;
        int range = end - start;
        double perIterationPercent = (double)range * 1.0 / (double)installablePackageList.size();
        int iterCnt = 1;
        HashMap<String, String> licenseNameToLicenseTextMap = new HashMap<String, String>();
        UpdateService service = MarketplaceUpdateManager.getService();
        for (PackageDescriptor packageDescriptor : installablePackageList) {
            String licenseName = packageDescriptor.getLicenseName();
            String licenseText = service.getLicenseTextHtml(licenseName);
            licenseNameToLicenseTextMap.put(licenseName, licenseText);
            progressListener.setCompleted((int)((double)start + (double)iterCnt * perIterationPercent));
            ++iterCnt;
        }
        return licenseNameToLicenseTextMap;
    }

    private static List<PackageDescriptor> getPackagesForInstallation(Map<PackageDescriptor, Set<PackageDescriptor>> dependency) {
        HashSet<PackageDescriptor> installablePackages = new HashSet<PackageDescriptor>();
        for (PackageDescriptor packageDescriptor : dependency.keySet()) {
            installablePackages.add(packageDescriptor);
            installablePackages.addAll((Collection)dependency.get(packageDescriptor));
        }
        return new LinkedList<PackageDescriptor>(installablePackages);
    }

    private static Set<Dependency> collectDependency(PackageDescriptor desc, Set<String> pluginsSelectedForDownload, PackageDescriptorCache packageDescriptorCache) {
        HashSet<Dependency> dependencySet = new HashSet<Dependency>();
        List dependencies = Dependency.parse((String)desc.getDependencies());
        for (Dependency dependency : dependencies) {
            Set<Dependency> dependenciesToAdd = UpdateDialog.getNecessaryDependencies(desc, pluginsSelectedForDownload, dependency, dependencySet, packageDescriptorCache);
            dependencySet.addAll(dependenciesToAdd);
        }
        return dependencySet;
    }

    private static Set<Dependency> getNecessaryDependencies(PackageDescriptor desc, Set<String> selectedDependencies, Dependency dependency, Set<Dependency> knownDependencies, PackageDescriptorCache packageDescriptorCache) {
        VersionNumber installed;
        String packageId = dependency.getPluginExtensionId();
        PackageDescriptor packageInfo = packageDescriptorCache.getPackageInfo(packageId);
        if (packageInfo == null) {
            return Collections.emptySet();
        }
        boolean upToDate = false;
        ManagedExtension ext = ManagedExtension.get((String)packageId);
        if (ext != null && (installed = ext.getLatestInstalledVersion()) != null) {
            VersionNumber other = null;
            try {
                other = new VersionNumber(packageInfo.getVersion());
            }
            catch (VersionNumber.VersionNumberException vne) {
                LogService.getRoot().log(Level.WARNING, "com.rapidminer.deployment.update.client.UpdateDialog.malformed_version", new Object[]{desc.getName(), desc.getPackageId(), vne.getLocalizedMessage()});
            }
            upToDate = installed.isAtLeast(other);
        }
        HashSet<Dependency> dependenciesToAdd = new HashSet<Dependency>();
        if (!(knownDependencies.contains(dependency) || selectedDependencies.contains(packageId) || upToDate)) {
            dependenciesToAdd.add(dependency);
            dependenciesToAdd.addAll(UpdateDialog.collectDependency(packageInfo, selectedDependencies, packageDescriptorCache));
        }
        return dependenciesToAdd;
    }

    public static Map<PackageDescriptor, Set<PackageDescriptor>> resolveDependency(List<PackageDescriptor> downloadList, PackageDescriptorCache packageDescriptorCache) {
        HashMap<PackageDescriptor, Set<PackageDescriptor>> dependentPackageMap = new HashMap<PackageDescriptor, Set<PackageDescriptor>>();
        HashSet<String> pluginsSelectedForDownload = new HashSet<String>();
        for (PackageDescriptor packageDescriptor : downloadList) {
            pluginsSelectedForDownload.add(packageDescriptor.getPackageId());
            dependentPackageMap.put(packageDescriptor, new HashSet());
        }
        for (PackageDescriptor desc : downloadList) {
            Set<Dependency> dependencySet = UpdateDialog.collectDependency(desc, pluginsSelectedForDownload, packageDescriptorCache);
            for (Dependency dependency : dependencySet) {
                ((Set)dependentPackageMap.get(desc)).add(packageDescriptorCache.getPackageInfo(dependency.getPluginExtensionId()));
            }
        }
        return dependentPackageMap;
    }

    public void search(String keyword) {
        this.ulp.search(keyword);
    }

    static {
        NetTools.init();
        UPDATE_ACTION = new MarketplaceDialogAction();
        UPDATE_TAB_ACTION = new MarketplaceDialogAction(true);
    }

    private class InstallButton
    extends JButton
    implements Observer {
        private static final long serialVersionUID = 1L;

        InstallButton(Action a) {
            super(a);
            this.updateButton();
        }

        @Override
        public void update(Observable o, Object arg) {
            if (o instanceof UpdatePackagesModel) {
                this.updateButton();
            }
        }

        private void updateButton() {
            UpdatePackagesModel currentModel = UpdateDialog.this.updateModel;
            if (currentModel.getInstallationList() != null && currentModel.getInstallationList().size() > 0) {
                this.setText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.update.install.label", (Object[])new Object[]{currentModel.getInstallationList().size()}));
                this.setEnabled(true);
            } else {
                this.setText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.update.install.label", (Object[])new Object[]{0}));
                this.setEnabled(false);
            }
        }
    }
}

