/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client;

import com.rapidminer.RapidMiner;
import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.deployment.update.client.AbstractPackageDescriptorListCellRenderer;
import com.rapidminer.deployment.update.client.UpdatePackagesModel;
import com.rapidminer.gui.filter.RMSImageFilter;
import com.rapidminer.gui.look.Colors;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.plugin.ManagedExtension;
import com.rapidminer.tools.plugin.Plugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;

final class UpdateListCellRenderer
extends AbstractPackageDescriptorListCellRenderer {
    private static final String DIV_OPEN = "<div>";
    private static final String DIV_OPEN_STYLE = "<div style=";
    private static final String DIV_CLOSE = "</div>";
    private static final String MARKED_FOR_INSTALL_COLOR = "#0066CC";
    private static final String MARKED_FOR_UPDATE_COLOR = "#3399FF";
    private static final String NOT_INSTALLED_COLOR = "#666666";
    private static final String UP_TO_DATE_COLOR = "#006600";
    private static final String UPDATES_AVAILABLE_COLOR = "#CC9900";
    private static final String NOT_WHITELISTED = "#666666";
    private static final Border BOTTOM_BORDER = BorderFactory.createMatteBorder(0, 0, 1, 0, Colors.TEXTFIELD_BORDER);
    private final UpdatePackagesModel updateModel;

    public UpdateListCellRenderer(UpdatePackagesModel updateModel) {
        this.updateModel = updateModel;
    }

    private String getFirstSentence(String text) {
        if (text != null && text.contains(".")) {
            String[] sentences = text.split("\\.");
            return sentences[0].trim() + ".";
        }
        return text;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String text;
        JPanel panel = new JPanel(){
            private static final long serialVersionUID = 6409307403021306689L;

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                if (d == null) {
                    return d;
                }
                d.width = 10;
                return d;
            }
        };
        JLabel label = new JLabel();
        panel.setLayout(new FlowLayout(0));
        panel.add(label);
        panel.setOpaque(true);
        if (isSelected && value instanceof PackageDescriptor) {
            panel.setBackground(Colors.TEXT_HIGHLIGHT_BACKGROUND);
        } else {
            panel.setBackground(Colors.TEXTFIELD_BACKGROUND);
        }
        if (value instanceof PackageDescriptor) {
            PackageDescriptor desc = (PackageDescriptor)value;
            boolean selectedForInstallation = this.updateModel == null || this.updateModel.isSelectedForInstallation(desc);
            Icon packageIcon = this.getResizedIcon(this.getIcon(desc));
            text = "<html><body style='width: " + (300 - packageIcon.getIconWidth()) + ";'>";
            text = (String)text + "<div><strong>" + desc.getName() + "</strong> " + desc.getVersion() + DIV_CLOSE;
            text = (String)text + DIV_OPEN + this.getFirstSentence(desc.getDescription()) + DIV_CLOSE;
            ManagedExtension ext = ManagedExtension.get((String)desc.getPackageId());
            if (!Plugin.isExtensionWhitelisted((String)desc.getPackageId())) {
                text = (String)text + this.getNotWhitelistedHtml();
                packageIcon = RMSImageFilter.convertIcon(packageIcon);
                panel.setToolTipText(I18N.getGUILabel((String)"plugin_blacklisted.tip", (Object[])new Object[]{desc.getPackageId()}));
                label.setForeground(Color.GRAY);
            } else if (desc.getPackageTypeName().equals("RAPIDMINER_PLUGIN")) {
                if (ext == null) {
                    text = selectedForInstallation ? (String)text + this.getMarkedForInstallationHtml() : (String)text + this.getNotInstalledHtml();
                } else {
                    VersionNumber installed = ext.getLatestInstalledVersion();
                    if (installed != null) {
                        VersionNumber other = null;
                        try {
                            other = new VersionNumber(desc.getVersion());
                        }
                        catch (VersionNumber.VersionNumberException vne) {
                            LogService.getRoot().log(Level.WARNING, "com.rapidminer.deployment.update.client.UpdateListCellRenderer.malformed_version", new Object[]{desc.getName(), desc.getPackageId(), vne.getLocalizedMessage()});
                        }
                        boolean upToDate = installed.isAtLeast(other);
                        text = upToDate ? (String)text + this.getUpToDateHtml() : (selectedForInstallation ? (String)text + this.getMarkedForUpdateHtml() : (String)text + this.getUpdatesAvailableHtml(ext.getLatestInstalledVersion().getShortLongVersion()));
                    } else {
                        text = selectedForInstallation ? (String)text + this.getMarkedForInstallationHtml() : (String)text + this.getNotInstalledHtml();
                    }
                }
            } else if (desc.getPackageTypeName().equals("STAND_ALONE")) {
                VersionNumber myVersion = RapidMiner.getTechnicalVersion();
                VersionNumber other = null;
                try {
                    other = new VersionNumber(desc.getVersion());
                }
                catch (VersionNumber.VersionNumberException vne) {
                    LogService.getRoot().log(Level.WARNING, "com.rapidminer.deployment.update.client.UpdateListCellRenderer.malformed_version", new Object[]{desc.getName(), desc.getPackageId(), vne.getLocalizedMessage()});
                }
                boolean upToDate = myVersion.isAtLeast(other);
                text = selectedForInstallation ? (String)text + this.getMarkedForUpdateHtml() : (upToDate ? (String)text + this.getUpToDateHtml() : (String)text + this.getUpdatesAvailableHtml(myVersion.getShortLongVersion()));
            }
            text = (String)text + "</body></html>";
            label.setIcon(packageIcon);
            label.setVerticalTextPosition(1);
            if (index < list.getModel().getSize() - 1) {
                panel.setBorder(BOTTOM_BORDER);
            }
        } else {
            text = "<html><div style='width:250px;'>" + value.toString() + "</div></html>";
        }
        label.setText(text);
        return panel;
    }

    private String getMarkedForInstallationHtml() {
        return "<div style='" + this.getActionStyle(MARKED_FOR_INSTALL_COLOR) + "'><img src='icon:///16/nav_down.png'/>&nbsp;" + I18N.getGUILabel((String)"marked.for.installation", (Object[])new Object[0]) + DIV_CLOSE;
    }

    private String getUpToDateHtml() {
        return "<div style='" + this.getActionStyle(UP_TO_DATE_COLOR) + "'><img src=\"icon:///16/navigate_check.png\"/>&nbsp;" + I18N.getGUILabel((String)"package.up.to.date", (Object[])new Object[0]) + DIV_CLOSE;
    }

    private String getNotInstalledHtml() {
        return "<div style='" + this.getActionStyle("#666666") + "'>" + I18N.getGUILabel((String)"not.installed", (Object[])new Object[0]) + DIV_CLOSE;
    }

    private String getMarkedForUpdateHtml() {
        return "<div style='" + this.getActionStyle(MARKED_FOR_UPDATE_COLOR) + "'><img src=\"icon:///16/nav_refresh.png\"/>&nbsp;" + I18N.getGUILabel((String)"marked.for.update", (Object[])new Object[0]) + DIV_CLOSE;
    }

    private String getUpdatesAvailableHtml(String installedVersion) {
        return "<div style='" + this.getActionStyle(UPDATES_AVAILABLE_COLOR) + "'><img src=\"icon:///16/nav_up.png\"/>&nbsp;" + I18N.getGUILabel((String)"installed.version", (Object[])new Object[]{installedVersion}) + DIV_CLOSE;
    }

    private String getNotWhitelistedHtml() {
        return "<table border=0 width='100%' cellspacing=0 cellpadding=0 ><tr><td style='" + this.getActionStyle("#666666") + " font-size:12pt;'>" + I18N.getGUILabel((String)"not.whitelisted", (Object[])new Object[0]) + "</td><td align=right><img src=\"icon:///16/lock.png\" /></td></tr></table>";
    }

    private String getActionStyle(String color) {
        return "height:18px;min-height:18px;line-height:18px;vertical-align:middle;color:" + color + ";margin-top:3px;";
    }
}

