/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client;

import com.rapidminer.RapidMiner;
import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.deployment.update.client.MarketplaceUpdateManager;
import com.rapidminer.deployment.update.client.PackageDescriptorCache;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.tools.DateTools;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.plugin.Dependency;
import com.rapidminer.tools.plugin.ManagedExtension;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;

public class UpdatePackagesModel
extends Observable {
    public static final String CUSTOM_LICENSE_PREFIX = "custom:";
    private final Map<PackageDescriptor, Boolean> selectionMap = new HashMap<PackageDescriptor, Boolean>();
    private PackageDescriptorCache cache;

    public UpdatePackagesModel(PackageDescriptorCache cache) {
        this.cache = cache;
    }

    public void setSelectedForInstallation(PackageDescriptor desc, boolean selected) {
        this.selectionMap.put(desc, true);
    }

    public void forceNotifyObservers() {
        this.setChanged();
        this.notifyObservers();
    }

    public void toggleSelectionForInstallation(PackageDescriptor desc) {
        if (desc != null) {
            VersionNumber remoteVersion;
            VersionNumber myVersion;
            boolean select;
            boolean bl = select = !this.isSelectedForInstallation(desc);
            if (this.isUpToDate(desc)) {
                select = false;
            }
            if (!"RAPIDMINER_PLUGIN".equals(desc.getPackageTypeName()) && "STAND_ALONE".equals(desc.getPackageTypeName()) && (myVersion = RapidMiner.getTechnicalVersion()).isAtLeast(remoteVersion = new VersionNumber(desc.getVersion()))) {
                select = false;
            }
            this.selectionMap.put(desc, select);
            this.setChanged();
            this.notifyObservers(desc);
        }
    }

    public void clearFromSelectionMap(List<PackageDescriptor> toClear) {
        for (PackageDescriptor desc : toClear) {
            this.selectionMap.remove(desc);
            this.setChanged();
            this.notifyObservers(desc);
        }
    }

    public boolean isSelectedForInstallation(PackageDescriptor desc) {
        Boolean selected = this.selectionMap.get(desc);
        return selected != null && selected != false;
    }

    public List<PackageDescriptor> getInstallationList() {
        LinkedList<PackageDescriptor> downloadList = new LinkedList<PackageDescriptor>();
        for (Map.Entry<PackageDescriptor, Boolean> entry : this.selectionMap.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            downloadList.add(entry.getKey());
        }
        return downloadList;
    }

    public boolean isUpToDate(PackageDescriptor desc) {
        ManagedExtension ext = ManagedExtension.get((String)desc.getPackageId());
        if (ext != null) {
            VersionNumber remoteVersion = new VersionNumber(desc.getVersion());
            VersionNumber myVersion = ext.getLatestInstalledVersion();
            return myVersion != null && myVersion.isAtLeast(remoteVersion);
        }
        return false;
    }

    public String getExtensionURL(PackageDescriptor descriptor) {
        return MarketplaceUpdateManager.getBaseUrl() + "/faces/product_details.xhtml?productId=" + descriptor.getPackageId();
    }

    public String toString(PackageDescriptor descriptor, String changes) {
        StringBuilder b = new StringBuilder("<html><body>");
        b.append("<h1>");
        b.append(descriptor.getName());
        b.append("</h1><hr/>");
        Date date = new Date(descriptor.getCreationTime().toGregorianCalendar().getTimeInMillis());
        String keyStyle = " style=\"padding-right:5px;color:gray;width:80px;\"";
        b.append("<table style=\"margin:5px 0 10px 5px\"><thead><tr><td " + keyStyle + ">Version</td><td>").append(descriptor.getVersion());
        b.append("</td></tr><tr><td " + keyStyle + ">Release date</td><td>").append(DateTools.INSTANCE.formatDate(date, null));
        b.append("</td></tr><tr><td " + keyStyle + ">File size</td><td>").append(Tools.formatBytes((long)descriptor.getSize())).append("</td></tr>");
        String licenseName = descriptor.getLicenseName().startsWith(CUSTOM_LICENSE_PREFIX) ? I18N.getGUILabel((String)"custom_license_type", (Object[])new Object[0]) : descriptor.getLicenseName();
        b.append("</td></tr><tr><td " + keyStyle + ">License</td><td>").append(licenseName).append("</td></tr>");
        if (descriptor.getDependencies() != null && !descriptor.getDependencies().isEmpty()) {
            b.append("<tr><td " + keyStyle + ">Dependencies</td><td>");
            boolean first = true;
            for (Dependency dependency : Dependency.parse((String)descriptor.getDependencies())) {
                PackageDescriptor packageInfo = this.cache.getPackageInfo(dependency.getPluginExtensionId());
                if (packageInfo == null) continue;
                if (!first) {
                    b.append(", ");
                } else {
                    first = false;
                }
                b.append(packageInfo.getName());
            }
            b.append("</td></tr>");
        }
        b.append("</table><div>").append(descriptor.getLongDescription()).append("</div>");
        if (changes != null && !changes.trim().equals("")) {
            b.append("<h2>Changes</h2>");
            b.append(changes);
        }
        b.append("</body></html>");
        return b.toString();
    }
}

