/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client;

import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.deployment.update.client.PackageDescriptorCache;
import com.rapidminer.deployment.update.client.UpdateDialog;
import com.rapidminer.deployment.update.client.UpdatePackagesModel;
import com.rapidminer.deployment.update.client.UpdatePanelSearchTab;
import com.rapidminer.deployment.update.client.UpdatePanelTab;
import com.rapidminer.deployment.update.client.UpdatePanelUpdatesTab;
import com.rapidminer.deployment.update.client.listmodels.AbstractPackageListModel;
import com.rapidminer.deployment.update.client.listmodels.TopDownloadsPackageListModel;
import com.rapidminer.deployment.update.client.listmodels.TopRatedPackageListModel;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceTabbedPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.NetTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JPanel;

public class UpdatePanel
extends JPanel {
    private final PackageDescriptorCache packageDescriptorCache;
    private final UpdateDialog updateDialog;
    private static final long serialVersionUID = 1L;
    private ResourceTabbedPane updatesTabbedPane = new ResourceTabbedPane("update");
    private UpdatePackagesModel updateModel;
    private transient ProgressThread descriptionFetcher;
    private boolean onlyUpdateTab = false;

    public UpdatePanel(final UpdateDialog dialog, final PackageDescriptorCache packageDescriptorCache, final String[] preselectedExtensions, final UpdatePackagesModel updateModel, boolean onlyUpdateTab) {
        this.packageDescriptorCache = packageDescriptorCache;
        this.updateModel = updateModel;
        this.onlyUpdateTab = onlyUpdateTab;
        if (preselectedExtensions.length > 0) {
            this.descriptionFetcher = new ProgressThread("update.package_description", true){

                public void run() {
                    this.getProgressListener().setTotal(preselectedExtensions.length);
                    int index = 0;
                    for (String pE : preselectedExtensions) {
                        PackageDescriptor desc = packageDescriptorCache.getPackageInfo(pE);
                        if (desc != null) {
                            updateModel.setSelectedForInstallation(desc, true);
                        } else {
                            SwingTools.showVerySimpleErrorMessage((Window)((Object)dialog), (String)"cannot_install_protocol_extension", (Object[])new Object[0]);
                        }
                        this.getProgressListener().setCompleted(++index);
                    }
                    updateModel.forceNotifyObservers();
                }
            };
            this.descriptionFetcher.start();
        }
        this.updateDialog = dialog;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(800, 320));
        this.setMinimumSize(new Dimension(800, 320));
        if (onlyUpdateTab) {
            this.addUpdateTab();
        } else {
            this.addAllTabs();
        }
        this.add((Component)this.updatesTabbedPane, "Center");
    }

    private void addAllTabs() {
        this.updatesTabbedPane.addTabI18N("search", (Component)this.createSearchListPanel(), new String[0]);
        this.updatesTabbedPane.addTabI18N("updates", (Component)this.createUpdatesListPanel(), new String[0]);
        this.updatesTabbedPane.addTabI18N("top_downloads", (Component)this.createUpdateListPanel(new TopDownloadsPackageListModel(this.packageDescriptorCache)), new String[0]);
        this.updatesTabbedPane.addTabI18N("top_rated", (Component)this.createUpdateListPanel(new TopRatedPackageListModel(this.packageDescriptorCache)), new String[0]);
        this.updatesTabbedPane.addChangeListener(e -> {
            UpdatePanelTab currentTab = (UpdatePanelTab)this.updatesTabbedPane.getSelectedComponent();
            currentTab.selectNotify();
        });
    }

    private void addUpdateTab() {
        this.updatesTabbedPane.addTabI18N("updates", (Component)this.createUpdatesListPanel(), new String[0]);
    }

    private JPanel createUpdateListPanel(AbstractPackageListModel listModel) {
        return new UpdatePanelTab(this.updateModel, listModel);
    }

    private JPanel createSearchListPanel() {
        return new UpdatePanelSearchTab(this.updateModel, this.packageDescriptorCache);
    }

    private JPanel createUpdatesListPanel() {
        return new UpdatePanelUpdatesTab(this.updateModel, this.packageDescriptorCache);
    }

    public void startUpdate() {
        ProgressThread update = new ProgressThread("update.installation_list"){

            public void run() {
                List<PackageDescriptor> downloadList = UpdatePanel.this.updateModel.getInstallationList();
                UpdatePanel.this.updateDialog.startUpdate(downloadList);
            }
        };
        if (this.descriptionFetcher != null) {
            update.addDependency(new String[]{this.descriptionFetcher.getID()});
        }
        update.start();
    }

    public void selectUpdatesTab() {
        if (!this.onlyUpdateTab) {
            this.updatesTabbedPane.setSelectedIndex(1);
        }
    }

    public void search(String keyword) {
        Stream<Component> tabsStream = Arrays.stream(this.updatesTabbedPane.getComponents());
        Stream<Component> updatePanelStream = tabsStream.filter(UpdatePanelSearchTab.class::isInstance);
        updatePanelStream.findFirst().map(UpdatePanelSearchTab.class::cast).ifPresent(p -> p.search(keyword));
    }

    public void displayExtensionById(String extensionId) {
        Stream<Component> tabsStream = Arrays.stream(this.updatesTabbedPane.getComponents());
        Stream<Component> updatePanelStream = tabsStream.filter(UpdatePanelSearchTab.class::isInstance);
        updatePanelStream.findFirst().map(UpdatePanelSearchTab.class::cast).ifPresent(p -> p.displayExtensionById(extensionId));
    }

    static {
        NetTools.init();
    }
}

