/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client;

import com.rapidminer.deployment.update.client.PackageDescriptorCache;
import com.rapidminer.deployment.update.client.UpdatePackagesModel;
import com.rapidminer.deployment.update.client.UpdatePanelTab;
import com.rapidminer.deployment.update.client.listmodels.SearchPackageListModel;
import com.rapidminer.gui.look.Colors;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class UpdatePanelSearchTab
extends UpdatePanelTab {
    private static final long serialVersionUID = 1L;
    private JTextField searchField;
    private JButton searchButton;
    private SearchPackageListModel searchModel;
    public final Action searchAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;
        private String oldSearch = "";

        @Override
        public void actionPerformed(ActionEvent e) {
            String value = UpdatePanelSearchTab.this.searchField.getText();
            if (value != null && !value.equals(this.oldSearch)) {
                UpdatePanelSearchTab.this.searchModel.search(value);
                this.oldSearch = value;
                UpdatePanelSearchTab.this.getPackageList().clearSelection();
            }
        }
    };

    public UpdatePanelSearchTab(UpdatePackagesModel updateModel, PackageDescriptorCache packageDescriptorCache) {
        this(updateModel, new SearchPackageListModel(packageDescriptorCache));
    }

    private UpdatePanelSearchTab(UpdatePackagesModel updateModel, SearchPackageListModel model) {
        super(updateModel, model);
        this.searchModel = model;
    }

    @Override
    protected JComponent makeTopPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Colors.TAB_BORDER), BorderFactory.createEmptyBorder(5, 2, 5, 2)));
        this.searchField = new JTextField(12);
        this.searchField.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.field.update.search.tip", (Object[])new Object[0]));
        SwingTools.setPrompt((String)I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.filter_text_field.label", (Object[])new Object[0]), (JTextComponent)this.searchField);
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    UpdatePanelSearchTab.this.searchAction.actionPerformed(null);
                    e.consume();
                }
            }
        });
        this.searchButton = new JButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.dialog.update.tab.search.search_button", (Object[])new Object[0]));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdatePanelSearchTab.this.searchAction.actionPerformed(null);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel.add((Component)this.searchField, gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.fill = 3;
        gbc.weightx = 0.0;
        panel.add((Component)this.searchButton, gbc);
        return panel;
    }

    public void search(String keyword) {
        if (keyword != null) {
            this.searchModel.search(keyword);
            this.getPackageList().clearSelection();
        }
        this.searchField.setText(keyword);
    }

    public void displayExtensionById(String extensionId) {
        if (extensionId != null) {
            this.searchModel.displayExtensionById(extensionId);
            this.getPackageList().clearSelection();
        }
    }
}

