/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client;

import com.rapidminer.RapidMiner;
import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.deployment.update.client.MarketplaceUpdateManager;
import com.rapidminer.deployment.update.client.UpdateListCellRenderer;
import com.rapidminer.deployment.update.client.UpdatePackagesModel;
import com.rapidminer.deployment.update.client.listmodels.AbstractPackageListModel;
import com.rapidminer.gui.look.Colors;
import com.rapidminer.gui.tools.ExtendedHTMLJEditorPane;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.MenuShortcutJList;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.gui.tools.components.LinkRemoteButton;
import com.rapidminer.settings.Telemetry;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.RMUrlHandler;
import com.rapidminer.tools.plugin.ManagedExtension;
import com.rapidminer.tools.plugin.Plugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class UpdatePanelTab
extends JPanel {
    private static final ImageIcon CHECKED_ICON = SwingTools.createIcon((String)"16/checkbox.png");
    private static final ImageIcon UNCHECKED_ICON = SwingTools.createIcon((String)"16/checkbox_unchecked.png");
    private static final long serialVersionUID = 1L;
    private static final int LIST_WIDTH = 330;
    protected UpdatePackagesModel updateModel;
    protected AbstractPackageListModel listModel;
    private final JPanel extensionButtonPane;
    private final ExtendedHTMLJEditorPane displayPane;
    private final SelectForInstallationButton installButton;
    private final LinkRemoteButton updateRMForOSXButton;
    private final LinkRemoteButton extensionHomepageLink;
    private final JList<Object> packageList;
    private PackageDescriptor lastSelected;

    public UpdatePanelTab(final UpdatePackagesModel updateModel, AbstractPackageListModel model) {
        super(new GridBagLayout());
        this.updateModel = updateModel;
        this.listModel = model;
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridheight = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.installButton = new SelectForInstallationButton((Action)new ResourceAction(true, "update.select", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void loggedActionPerformed(ActionEvent e) {
                UpdatePanelTab.this.markForInstallation((PackageDescriptor)UpdatePanelTab.this.getPackageList().getSelectedValue());
            }
        });
        this.installButton.addActionListener(e -> this.installButton.setIcon(this.installButton.isSelected() ? CHECKED_ICON : UNCHECKED_ICON));
        this.installButton.setEnabled(false);
        updateModel.addObserver(this.installButton);
        this.displayPane = new ExtendedHTMLJEditorPane("text/html", "");
        this.displayPane.setBackground((Color)Colors.PANEL_BACKGROUND);
        this.displayPane.installDefaultStylesheet();
        ((HTMLEditorKit)this.displayPane.getEditorKit()).getStyleSheet().addRule("a  {text-decoration:underline; color:blue;}");
        this.setDefaultDescription();
        this.displayPane.setEditable(false);
        this.displayPane.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                RMUrlHandler.openInBrowser((URL)e.getURL());
            }
        });
        this.extensionHomepageLink = new LinkRemoteButton((Action)new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageDescriptor selectedDescriptor = (PackageDescriptor)UpdatePanelTab.this.getPackageList().getSelectedValue();
                if (selectedDescriptor != null) {
                    String url = updateModel.getExtensionURL(selectedDescriptor);
                    RMUrlHandler.openInBrowser((String)url);
                }
            }
        });
        this.packageList = this.createUpdateList();
        ExtendedJScrollPane updateListScrollPane = new ExtendedJScrollPane(this.packageList);
        updateListScrollPane.setMinimumSize(new Dimension(330, 100));
        updateListScrollPane.setPreferredSize(new Dimension(330, 100));
        updateListScrollPane.setBorder(null);
        updateListScrollPane.setHorizontalScrollBarPolicy(31);
        Component topPanel = this.makeTopPanel();
        Component bottomPanel = this.makeBottomPanel();
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)updateListScrollPane, "Center");
        if (topPanel != null) {
            leftPanel.add(topPanel, "North");
            this.add((Component)leftPanel, c);
        }
        if (bottomPanel != null) {
            leftPanel.add(bottomPanel, "South");
            this.add((Component)leftPanel, c);
        }
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        ExtendedJScrollPane jScrollPane = new ExtendedJScrollPane((Component)this.displayPane);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setBorder(null);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.add((Component)jScrollPane, "Center");
        this.extensionButtonPane = new JPanel(new BorderLayout());
        this.extensionButtonPane.setMinimumSize(new Dimension(100, 35));
        this.extensionButtonPane.setPreferredSize(new Dimension(100, 35));
        JPanel extensionButtonPaneLeft = new JPanel(new FlowLayout(0));
        this.updateRMForOSXButton = new LinkRemoteButton((Action)new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MarketplaceUpdateManager.openOSXDownloadURL();
            }
        });
        this.updateRMForOSXButton.setText(I18N.getGUILabel((String)"update.osx.label", (Object[])new Object[0]));
        extensionButtonPaneLeft.add((Component)this.updateRMForOSXButton);
        extensionButtonPaneLeft.add(this.installButton);
        this.extensionButtonPane.add((Component)extensionButtonPaneLeft, "West");
        JPanel extensionButtonPaneRight = new JPanel(new FlowLayout(2));
        this.extensionHomepageLink.setText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.update.extension_homepage.label", (Object[])new Object[0]));
        extensionButtonPaneRight.add((Component)this.extensionHomepageLink);
        this.extensionButtonPane.add((Component)extensionButtonPaneRight, "Center");
        for (Component component : this.extensionButtonPane.getComponents()) {
            component.setVisible(false);
        }
        this.extensionButtonPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
        descriptionPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.LIGHT_GRAY));
        descriptionPanel.add((Component)this.extensionButtonPane, "South");
        this.add((Component)descriptionPanel, c);
    }

    protected Component makeTopPanel() {
        return null;
    }

    protected Component makeBottomPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setMinimumSize(new Dimension(100, 35));
        panel.setPreferredSize(new Dimension(100, 35));
        panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
        return panel;
    }

    private JList<Object> createUpdateList() {
        MenuShortcutJList updateList = new MenuShortcutJList((ListModel)this.listModel, false);
        updateList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateDisplayPane();
            }
        });
        updateList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PackageDescriptor selectedDescriptor = (PackageDescriptor)UpdatePanelTab.this.getPackageList().getSelectedValue();
                    if (selectedDescriptor == null) {
                        return;
                    }
                    if ("rapidminer-studio-6".equals(selectedDescriptor.getPackageId()) && MarketplaceUpdateManager.useOSXUpdateMechansim()) {
                        MarketplaceUpdateManager.openOSXDownloadURL();
                    } else {
                        UpdatePanelTab.this.markForInstallation(selectedDescriptor);
                    }
                }
            }
        });
        updateList.setCellRenderer(new UpdateListCellRenderer(this.updateModel));
        return updateList;
    }

    protected void markForInstallation(PackageDescriptor selectedDescriptor) {
        if (selectedDescriptor == null || this.updateModel.isUpToDate(selectedDescriptor)) {
            return;
        }
        this.updateModel.toggleSelectionForInstallation(selectedDescriptor);
        this.getModel().updateView(selectedDescriptor);
    }

    protected JList<Object> getPackageList() {
        return this.packageList;
    }

    public void selectNotify() {
        this.listModel.update();
    }

    public AbstractPackageListModel getModel() {
        return this.listModel;
    }

    private void setDefaultDescription() {
        if (Telemetry.MARKETPLACE.isDenied()) {
            LogService.getRoot().log(Level.CONFIG, "com.rapidminer.gui.telemetry.accessing_online_services_disallowed");
            return;
        }
        new Thread("Load Default Description"){

            @Override
            public void run() {
                try {
                    String url = I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.marketplace.news.url", (Object[])new Object[0]);
                    UpdatePanelTab.this.displayPane.setPage(url);
                }
                catch (Exception e) {
                    UpdatePanelTab.this.displayPane.setText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.dialog.update_welcome_message.text", (Object[])new Object[]{MarketplaceUpdateManager.getBaseUrl()}));
                }
            }
        }.start();
    }

    private void updateDisplayPane() {
        Object selectedValue = this.packageList.getSelectedValue();
        PackageDescriptor desc = null;
        if (selectedValue instanceof PackageDescriptor) {
            this.lastSelected = desc = (PackageDescriptor)selectedValue;
        } else {
            this.packageList.clearSelection();
            if (this.lastSelected != null) {
                desc = this.lastSelected;
            }
        }
        if (desc == null) {
            return;
        }
        for (Component c : this.extensionButtonPane.getComponents()) {
            c.setVisible(true);
        }
        this.installButton.setVisible(false);
        this.updateRMForOSXButton.setVisible(false);
        this.extensionButtonPane.setVisible(true);
        StyleSheet css = new StyleSheet();
        css.addRule("a  {text-decoration:underline; color:blue;}");
        css.addRule("h1 {font-size: 14px;}");
        css.addRule("h2 {font-size: 11px;font-weight:bold;}");
        css.addRule("div, p, hr { margin-bottom:8px }");
        css.addRule("div.changes-section{padding-left:10px;font-size:9px;color:#444444;}");
        css.addRule(".changes-header-version {margin-top:10px;margin-bottom:5px;color:#111111;}");
        css.addRule("ul {padding-left:10px;}");
        css.addRule("ul li {margin-left:0px;padding-left:0px;}");
        HTMLDocument doc = new HTMLDocument(css);
        this.displayPane.setDocument((Document)doc);
        this.displayPane.setText(this.updateModel.toString(desc, this.listModel.getChanges(desc.getPackageId())));
        this.displayPane.setCaretPosition(0);
        this.installButton.setSelected(this.updateModel.isSelectedForInstallation(desc));
        boolean isInstalled = false;
        boolean isUpToDate = false;
        boolean isRapidMiner = "STAND_ALONE".equals(desc.getPackageTypeName());
        VersionNumber other = null;
        try {
            other = new VersionNumber(desc.getVersion());
        }
        catch (VersionNumber.VersionNumberException vne) {
            LogService.getRoot().log(Level.WARNING, "com.rapidminer.deployment.update.client.UpdatePanelTab.malformed_version", new Object[]{desc.getName(), desc.getPackageId(), vne.getLocalizedMessage()});
        }
        if (isRapidMiner) {
            isUpToDate = RapidMiner.getTechnicalVersion().isAtLeast(other);
            isInstalled = true;
        } else {
            ManagedExtension ext = ManagedExtension.get((String)desc.getPackageId());
            if (ext != null) {
                isInstalled = true;
                VersionNumber installed = ext.getLatestInstalledVersion();
                if (installed != null) {
                    isUpToDate = installed.isAtLeast(other);
                }
            }
        }
        if (isInstalled) {
            this.extensionHomepageLink.setText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.update.extension_homepage.label", (Object[])new Object[0]));
            if (!isUpToDate) {
                if (isRapidMiner && MarketplaceUpdateManager.useOSXUpdateMechansim()) {
                    this.updateRMForOSXButton.setVisible(true);
                } else {
                    this.installButton.setText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.update.select.label", (Object[])new Object[0]));
                    this.installButton.getAction().putValue("MnemonicKey", I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.update.select.mne", (Object[])new Object[0]).toUpperCase().charAt(0));
                    this.installButton.setEnabled(true);
                    this.installButton.setVisible(true);
                    this.installButton.setIcon(this.updateModel.isSelectedForInstallation(desc) ? CHECKED_ICON : UNCHECKED_ICON);
                }
            } else {
                this.installButton.setVisible(false);
            }
        } else {
            this.installButton.setText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.install.select.label", (Object[])new Object[0]));
            this.installButton.getAction().putValue("MnemonicKey", I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.install.select.mne", (Object[])new Object[0]).toUpperCase().charAt(0));
            this.extensionHomepageLink.setText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.update.extension_homepage.label", (Object[])new Object[0]));
            this.installButton.setVisible(true);
            this.installButton.setEnabled(true);
            this.installButton.setIcon(this.updateModel.isSelectedForInstallation(desc) ? CHECKED_ICON : UNCHECKED_ICON);
        }
        if (isRapidMiner) {
            this.extensionHomepageLink.setText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.update.product_homepage.label", (Object[])new Object[0]));
        }
        if (!Plugin.isExtensionWhitelisted((String)desc.getPackageId())) {
            this.installButton.setEnabled(false);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.updateModel.deleteObservers();
    }

    private class SelectForInstallationButton
    extends JToggleButton
    implements Observer {
        private static final long serialVersionUID = 1L;

        public SelectForInstallationButton(Action a) {
            super(a);
        }

        @Override
        public void update(Observable o, Object arg) {
            if (!(o instanceof UpdatePackagesModel) || !(arg instanceof PackageDescriptor)) {
                return;
            }
            UpdatePackagesModel currentModel = (UpdatePackagesModel)o;
            PackageDescriptor desc = (PackageDescriptor)arg;
            Object selectedObject = UpdatePanelTab.this.getPackageList().getSelectedValue();
            if (selectedObject instanceof PackageDescriptor) {
                PackageDescriptor selectedDescriptor = (PackageDescriptor)selectedObject;
                if (desc.getPackageId().equals(selectedDescriptor.getPackageId())) {
                    boolean isSelected = currentModel.isSelectedForInstallation(desc);
                    this.setSelected(isSelected);
                    this.setIcon(isSelected ? CHECKED_ICON : UNCHECKED_ICON);
                }
            }
            UpdatePanelTab.this.listModel.updateView(desc);
        }
    }
}

