/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client;

import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.deployment.update.client.MarketplaceUpdateManager;
import com.rapidminer.deployment.update.client.PackageDescriptorCache;
import com.rapidminer.deployment.update.client.UpdatePackagesModel;
import com.rapidminer.deployment.update.client.UpdatePanelTab;
import com.rapidminer.deployment.update.client.listmodels.AbstractPackageListModel;
import com.rapidminer.deployment.update.client.listmodels.UpdatesPackageListModel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class UpdatePanelUpdatesTab
extends UpdatePanelTab {
    private static final long serialVersionUID = 1L;
    private JButton updateAllButton;
    public final Action selectAllAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.markAllEligible();
        }

        private void markAllEligible() {
            for (String packageName : UpdatePanelUpdatesTab.this.listModel.getAllPackageNames()) {
                PackageDescriptor pd = UpdatePanelUpdatesTab.this.listModel.getCache().getPackageInfo(packageName);
                boolean osxStudioUpdate = UpdatePanelUpdatesTab.this.isOSXStudioUpdate(pd);
                if (UpdatePanelUpdatesTab.this.updateModel.isSelectedForInstallation(pd) || osxStudioUpdate) continue;
                UpdatePanelUpdatesTab.this.markForInstallation(pd);
            }
            UpdatePanelUpdatesTab.this.getModel().updateView();
            UpdatePanelUpdatesTab.this.checkInstallAllEnabled();
        }
    };

    public UpdatePanelUpdatesTab(UpdatePackagesModel updateModel, PackageDescriptorCache packageDescriptorCache) {
        this(updateModel, new UpdatesPackageListModel(packageDescriptorCache));
    }

    private UpdatePanelUpdatesTab(UpdatePackagesModel updateModel, AbstractPackageListModel model) {
        super(updateModel, model);
    }

    private void checkInstallAllEnabled() {
        boolean allSelected = true;
        LinkedList<String> allPackageNames = new LinkedList<String>(this.listModel.getAllPackageNames());
        for (String packageName : allPackageNames) {
            PackageDescriptor pd = this.listModel.getCache().getPackageInfo(packageName);
            allSelected &= this.updateModel.isSelectedForInstallation(pd) || this.isOSXStudioUpdate(pd);
        }
        this.updateAllButton.setEnabled(!allSelected);
    }

    private boolean isOSXStudioUpdate(PackageDescriptor pd) {
        return pd != null && MarketplaceUpdateManager.useOSXUpdateMechansim() && pd.getPackageId().equals("rapidminer-studio-6");
    }

    @Override
    protected JComponent makeBottomPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setMinimumSize(new Dimension(100, 35));
        panel.setPreferredSize(new Dimension(100, 35));
        this.updateAllButton = new JButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.dialog.update.tab.updates.update_all_button", (Object[])new Object[0]));
        this.updateAllButton.setIcon(SwingTools.createIcon((String)"16/checks.png"));
        this.updateAllButton.setEnabled(false);
        this.listModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                UpdatePanelUpdatesTab.this.checkInstallAllEnabled();
            }
        });
        this.updateAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdatePanelUpdatesTab.this.selectAllAction.actionPerformed(null);
            }
        });
        panel.add(this.updateAllButton);
        return panel;
    }
}

