/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client.listmodels;

import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.deployment.update.client.MarketplaceUpdateManager;
import com.rapidminer.deployment.update.client.PackageDescriptorCache;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.ProgressListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;

public abstract class AbstractPackageListModel
extends AbstractListModel<Object> {
    private static final long serialVersionUID = 1L;
    protected PackageDescriptorCache cache;
    protected boolean updatedOnce = false;
    private boolean forceUpdate = false;
    protected boolean fetching = false;
    protected int completed = 0;
    protected List<String> packageNames = new CopyOnWriteArrayList<String>();
    private String noPackagesMessageKey = "gui.dialog.update.tab.no_packages";

    public AbstractPackageListModel(PackageDescriptorCache cache, String noPackagesMessageKey) {
        this.cache = cache;
        this.noPackagesMessageKey = noPackagesMessageKey;
    }

    public void update(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
        this.update();
    }

    public synchronized void update() {
        if (this.shouldUpdate() || this.forceUpdate) {
            this.fetching = true;
            new ProgressThread("fetching_updates", false){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        this.getProgressListener().setTotal(100);
                        AbstractPackageListModel.this.setCompleted(this.getProgressListener(), 5);
                        AbstractPackageListModel.this.packageNames = AbstractPackageListModel.this.fetchPackageNames();
                        AbstractPackageListModel.this.setCompleted(this.getProgressListener(), 25);
                        int a = 0;
                        Iterator<String> it = AbstractPackageListModel.this.packageNames.iterator();
                        int size = AbstractPackageListModel.this.packageNames.size();
                        while (it.hasNext()) {
                            String packageName = it.next();
                            PackageDescriptor desc = AbstractPackageListModel.this.cache.getPackageInfo(packageName);
                            AbstractPackageListModel.this.cache.getPackageChanges(packageName);
                            AbstractPackageListModel.this.setCompleted(this.getProgressListener(), 30 + 70 * ++a / size);
                            if (desc != null && (!"STAND_ALONE".equals(desc.getPackageTypeName()) || "rapidminer-studio-6".equals(desc.getPackageId()))) continue;
                            it.remove();
                        }
                        AbstractPackageListModel.this.modifyPackageList();
                        AbstractPackageListModel.this.updatedOnce = true;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AbstractPackageListModel.this.fetching = false;
                                AbstractPackageListModel.this.fireContentsChanged(this, 0, AbstractPackageListModel.this.packageNames.size() > 0 ? AbstractPackageListModel.this.packageNames.size() : 1);
                            }
                        });
                    }
                    catch (Exception e) {
                        SwingTools.showVerySimpleErrorMessage((String)"failed_update_server", (Object[])new Object[]{e, MarketplaceUpdateManager.getBaseUrl()});
                    }
                    finally {
                        AbstractPackageListModel.this.fetching = false;
                        this.getProgressListener().complete();
                    }
                }
            }.start();
            this.forceUpdate = false;
        }
    }

    protected boolean shouldUpdate() {
        return !this.updatedOnce;
    }

    private void setCompleted(ProgressListener listener, int progress) {
        listener.setCompleted(progress);
        this.completed = progress;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractPackageListModel.this.fireContentsChanged(this, 0, AbstractPackageListModel.this.packageNames.size() > 0 ? AbstractPackageListModel.this.packageNames.size() : 1);
            }
        });
    }

    public abstract List<String> handleFetchPackageNames();

    public List<String> fetchPackageNames() {
        return new ArrayList<String>(this.handleFetchPackageNames());
    }

    public void modifyPackageList() {
    }

    @Override
    public int getSize() {
        if (this.fetching) {
            return 1;
        }
        return this.packageNames.size() > 0 ? this.packageNames.size() : 1;
    }

    @Override
    public Object getElementAt(int index) {
        if (this.fetching) {
            return I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.dialog.update.tab.loading", (Object[])new Object[]{this.completed});
        }
        if (this.packageNames.size() == 0) {
            if (this.cache.hasError()) {
                return I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.dialog.update.tab.no_connection", (Object[])new Object[0]);
            }
            return I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)this.noPackagesMessageKey, (Object[])new Object[0]);
        }
        return this.cache.getPackageInfo(this.packageNames.get(index));
    }

    public List<String> getAllPackageNames() {
        return this.packageNames;
    }

    public PackageDescriptorCache getCache() {
        return this.cache;
    }

    public String getChanges(String packageId) {
        return this.cache.getPackageChanges(packageId);
    }

    public void updateView(PackageDescriptor descr) {
        if (descr != null) {
            int index = this.packageNames.indexOf(descr.getPackageId());
            this.fireContentsChanged(this, index, index);
        }
    }

    public void updateView() {
        this.fireContentsChanged(this, 0, this.packageNames.size() > 0 ? this.packageNames.size() : 1);
    }

    public void add(PackageDescriptor desc) {
        this.packageNames.add(desc.getPackageId());
        this.fireIntervalAdded(this, this.packageNames.size() - 1, this.packageNames.size() - 1);
    }
}

