/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client.listmodels;

import com.rapidminer.deployment.client.wsimport.UpdateService;
import com.rapidminer.deployment.update.client.PackageDescriptorCache;
import com.rapidminer.deployment.update.client.listmodels.AbstractPackageListModel;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.usagestats.ActionStatisticsCollector;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;

public class SearchPackageListModel
extends AbstractPackageListModel {
    private static final long serialVersionUID = 1L;
    private String searchString = "";
    private String idString = "";
    private boolean searched = false;
    private boolean shouldUpdate = false;

    public SearchPackageListModel(PackageDescriptorCache cache) {
        super(cache, "gui.dialog.update.tab.no_search_results");
    }

    public void search(String searchString) {
        this.idString = null;
        if (searchString != null) {
            this.searched = true;
            this.searchString = searchString;
            this.shouldUpdate = true;
            this.update();
            this.shouldUpdate = false;
            ActionStatisticsCollector.INSTANCE.log("marketplace", "search", searchString);
        }
    }

    public void displayExtensionById(String id) {
        this.searchString = null;
        this.idString = id;
        this.shouldUpdate = true;
        this.update();
        this.shouldUpdate = false;
    }

    @Override
    public List<String> handleFetchPackageNames() {
        UpdateService updateService = this.cache.getUpdateService();
        if (this.idString != null && !this.idString.trim().isEmpty()) {
            return Collections.singletonList(this.idString);
        }
        if (this.searchString != null && !this.searchString.trim().isEmpty()) {
            List<String> searchResults = updateService.searchFor(this.searchString);
            return searchResults;
        }
        return Collections.emptyList();
    }

    @Override
    public Object getElementAt(int index) {
        if (this.fetching) {
            return I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.dialog.update.tab.loading", (Object[])new Object[]{this.completed});
        }
        if (this.packageNames.size() == 0) {
            return this.searched ? I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.dialog.update.tab.no_search_results", (Object[])new Object[0]) : "";
        }
        return this.cache.getPackageInfo((String)this.packageNames.get(index));
    }

    @Override
    protected boolean shouldUpdate() {
        return this.shouldUpdate;
    }
}

