/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.deployment.update.client.listmodels;

import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.deployment.update.client.PackageDescriptorCache;
import com.rapidminer.deployment.update.client.listmodels.AbstractPackageListModel;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.plugin.ManagedExtension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class UpdatesPackageListModel
extends AbstractPackageListModel {
    private static final long serialVersionUID = 1L;

    public UpdatesPackageListModel(PackageDescriptorCache cache) {
        super(cache, "gui.dialog.update.tab.no_updates");
    }

    @Override
    public List<String> handleFetchPackageNames() {
        ArrayList<String> packageNames = new ArrayList<String>();
        packageNames.add("rapidminer-studio-6");
        for (ManagedExtension me : ManagedExtension.getAll()) {
            packageNames.add(me.getPackageId());
        }
        return packageNames;
    }

    @Override
    public void modifyPackageList() {
        Iterator i = this.packageNames.iterator();
        while (i.hasNext()) {
            boolean upToDate;
            String packageName = (String)i.next();
            PackageDescriptor desc = this.cache.getPackageInfo(packageName);
            ManagedExtension ext = ManagedExtension.get((String)desc.getPackageId());
            if ("rapidminer-studio-6".equals(packageName)) {
                i.remove();
                continue;
            }
            VersionNumber installedVersion = ext.getLatestInstalledVersion();
            if (installedVersion == null || !(upToDate = installedVersion.isAtLeast(this.getVersionNumber(desc)))) continue;
            i.remove();
        }
    }

    private VersionNumber getVersionNumber(PackageDescriptor desc) {
        if (desc == null) {
            return null;
        }
        VersionNumber other = null;
        try {
            other = new VersionNumber(desc.getVersion());
        }
        catch (VersionNumber.VersionNumberException vne) {
            LogService.getRoot().log(Level.WARNING, "com.rapidminer.deployment.update.client.listmodels.UpdatePackageListModel.malformed_version", new Object[]{desc.getName(), desc.getPackageId(), vne.getLocalizedMessage()});
        }
        return other;
    }
}

