/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting;

import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.connection.ConnectionHandlerRegistry;
import com.rapidminer.connection.util.GenericHandler;
import com.rapidminer.extension.professional.PluginInitProfessional;
import com.rapidminer.extension.pythonscripting.connection.StandPyConnectionHandler;
import com.rapidminer.extension.pythonscripting.gui.dialog.CreateExtensionAction;
import com.rapidminer.extension.pythonscripting.gui.draganddrop.DropPythonEntryIntoProcessCallback;
import com.rapidminer.extension.pythonscripting.gui.draganddrop.DropPythonFileIntoProcessCallback;
import com.rapidminer.extension.pythonscripting.gui.draganddrop.OpenPythonEntryCallback;
import com.rapidminer.extension.pythonscripting.gui.draganddrop.PythonOperatorCallback;
import com.rapidminer.extension.pythonscripting.gui.properties.celleditors.value.OperatorCellEditor;
import com.rapidminer.extension.pythonscripting.gui.properties.celleditors.value.PythonEnvironmentCellEditor;
import com.rapidminer.extension.pythonscripting.model.PythonModel;
import com.rapidminer.extension.pythonscripting.operator.PythonForecast;
import com.rapidminer.extension.pythonscripting.operator.PythonForecastModel;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonSetupTester;
import com.rapidminer.extension.pythonscripting.parameter.CondaEnvironmentSuggestionProvider;
import com.rapidminer.extension.pythonscripting.parameter.ParameterTypeOperator;
import com.rapidminer.extension.pythonscripting.parameter.ParameterTypeScriptingEnvironment;
import com.rapidminer.extension.pythonscripting.parameter.PythonBinariesSuggestionProvider;
import com.rapidminer.extension.pythonscripting.parameter.VenvwEnvironmentSuggestionProvider;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dnd.DropBinaryEntryIntoProcessActionRegistry;
import com.rapidminer.gui.dnd.DropFileIntoProcessActionRegistry;
import com.rapidminer.gui.properties.PropertyPanel;
import com.rapidminer.gui.properties.celleditors.value.LinkButtonValueCellEditor;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.license.LicenseManagerRegistry;
import com.rapidminer.license.verification.JarVerifier;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeLinkButton;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.repository.RepositoryActionCondition;
import com.rapidminer.repository.gui.OpenBinaryEntryActionRegistry;
import com.rapidminer.repository.gui.RepositoryEntryIconRegistry;
import com.rapidminer.repository.gui.RepositoryTree;
import com.rapidminer.repository.gui.actions.CreateFolderAction;
import com.rapidminer.repository.versioned.JsonStorableIOObjectResolver;
import com.rapidminer.timeseriesanalysis.forecast.JsonForecastModelResolver;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.parameter.ParameterChangeListener;
import com.rapidminer.tools.plugin.Plugin;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class PluginInitPythonScripting {
    private static final String FILE_SUFFIX_PY = "py";
    private static final String FILE_SUFFIX_IPYNB = "ipynb";
    public static final String PROPERTY_INITIALIZED_V82 = "rapidminer.python_scripting.initialized";
    public static final String PROPERTY_PYTHON_PATH_V82 = "rapidminer.python_scripting.path";
    public static final String PACKAGE_MANAGER_CONDA = "conda (anaconda)";
    public static final String PACKAGE_MANAGER_VENVW = "virtualenvwrapper";
    public static final String PACKAGE_MANAGER_BINARIES = "specific python binaries";
    public static final String PACKAGE_MANAGER_DEFAULT = "conda (anaconda)";
    private static final String[] PACKAGE_MANAGERS = new String[]{"conda (anaconda)", "virtualenvwrapper", "specific python binaries"};
    private static final String PROPERTY_EXTENSION_INITIALIZED = "rapidminer.python_scripting.hidden.initialized";
    private static final String PROPERTY_PYTHON_SEARCH_PATHS = "rapidminer.python_scripting.search_paths";
    private static final String PROPERTY_PYTHON_SEARCH_PATH = "rapidminer.python_scripting.search_path";
    public static final String PROPERTY_PACKAGE_MANAGER = "rapidminer.python_scripting.package_manager";
    public static final String PROPERTY_SHELL_COMMAND = "rapidminer.python_scripting.shell_command";
    private static final String DEFAULT_SHELL_COMMAND = "bash -l -i -c";
    public static final String PROPERTY_CONDA_ENVIRONMENT = "rapidminer.python_scripting.conda_environment";
    public static final String PROPERTY_VENVW_ENVIRONMENT = "rapidminer.python_scripting.venvw_environment";
    public static final String PROPERTY_PYTHON_BINARY = "rapidminer.python_scripting.python_binary";
    public static final String PROPERTY_CACHED_BINARIES = "rapidminer.python_scripting.cached.binaries";
    private static volatile String currentSearchPath = null;
    private static boolean initialized = false;
    private static Path temporaryDefaultPythonBinary = null;

    private PluginInitPythonScripting() {
    }

    public static void initPlugin() {
        JsonStorableIOObjectResolver.INSTANCE.register(PythonModel.class);
        JsonStorableIOObjectResolver.INSTANCE.register(PythonForecastModel.class);
        JsonForecastModelResolver.INSTANCE.register(PythonForecast.class);
        ParameterTypeEnumeration searchPaths = new ParameterTypeEnumeration(PROPERTY_PYTHON_SEARCH_PATHS, I18N.getGUIMessage((String)"gui.dialog.python_scripting.preferences.search_paths", (Object[])new Object[0]), (ParameterType)new ParameterTypeDirectory(PROPERTY_PYTHON_SEARCH_PATH, I18N.getGUIMessage((String)"gui.dialog.python_scripting.preferences.search_path", (Object[])new Object[0]), true));
        ParameterService.registerParameter((ParameterType)searchPaths);
        ParameterTypeCategory packageManagers = new ParameterTypeCategory(PROPERTY_PACKAGE_MANAGER, I18N.getGUIMessage((String)"gui.dialog.python_scripting.preferences.package_manager", (Object[])new Object[0]), PACKAGE_MANAGERS, 0);
        packageManagers.registerDependencyCondition(new ParameterCondition(null, PROPERTY_PYTHON_SEARCH_PATHS, true){

            public boolean isConditionFullfilled() {
                try {
                    if (this.parameterHandler != null) {
                        currentSearchPath = (String)this.parameterHandler.getParameter(PluginInitPythonScripting.PROPERTY_PYTHON_SEARCH_PATHS);
                    }
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    ByteArrayOutputStream stacktrace = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream(stacktrace);
                    undefinedParameterError.printStackTrace(printStream);
                    LogService.getRoot().warning(stacktrace.toString());
                }
                return true;
            }
        });
        ParameterService.registerParameter((ParameterType)packageManagers);
        ParameterTypeScriptingEnvironment condaEnvs = new ParameterTypeScriptingEnvironment(PROPERTY_CONDA_ENVIRONMENT, I18N.getGUIMessage((String)"gui.dialog.python_scripting.preferences.default_conda", (Object[])new Object[0]), new CondaEnvironmentSuggestionProvider());
        condaEnvs.setOptional(true);
        condaEnvs.setExpert(false);
        condaEnvs.registerDependencyCondition((ParameterCondition)new EqualStringCondition(null, PROPERTY_PACKAGE_MANAGER, true, new String[]{"conda (anaconda)"}));
        ParameterService.registerParameter((ParameterType)condaEnvs);
        ParameterTypeScriptingEnvironment venvwEnvs = new ParameterTypeScriptingEnvironment(PROPERTY_VENVW_ENVIRONMENT, I18N.getGUIMessage((String)"gui.dialog.python_scripting.preferences.default_venvw", (Object[])new Object[0]), new VenvwEnvironmentSuggestionProvider());
        venvwEnvs.setOptional(true);
        venvwEnvs.setExpert(false);
        venvwEnvs.registerDependencyCondition((ParameterCondition)new EqualStringCondition(null, PROPERTY_PACKAGE_MANAGER, true, new String[]{PACKAGE_MANAGER_VENVW}));
        ParameterService.registerParameter((ParameterType)venvwEnvs);
        ParameterTypeScriptingEnvironment binaries = new ParameterTypeScriptingEnvironment(PROPERTY_PYTHON_BINARY, I18N.getGUIMessage((String)"gui.dialog.python_scripting.preferences.default_python_binary", (Object[])new Object[0]), new PythonBinariesSuggestionProvider());
        binaries.setOptional(true);
        binaries.setExpert(false);
        binaries.registerDependencyCondition((ParameterCondition)new EqualStringCondition(null, PROPERTY_PACKAGE_MANAGER, true, new String[]{PACKAGE_MANAGER_BINARIES}));
        ParameterService.registerParameter((ParameterType)binaries);
        ParameterTypeString shellCommand = new ParameterTypeString(PROPERTY_SHELL_COMMAND, I18N.getSettingsMessage((String)PROPERTY_SHELL_COMMAND, (I18N.SettingsType)I18N.SettingsType.DESCRIPTION, (Object[])new Object[0]), DEFAULT_SHELL_COMMAND, true);
        shellCommand.setHidden(true);
        ParameterService.registerParameter((ParameterType)shellCommand);
        ConnectionHandlerRegistry.getInstance().registerHandler((GenericHandler)new StandPyConnectionHandler());
    }

    private static void autodetectPath() {
        String searchPathValues = ParameterService.getParameterValue((String)PROPERTY_PYTHON_SEARCH_PATHS);
        if (searchPathValues == null || searchPathValues.length() == 0) {
            ParameterService.setParameterValue((String)PROPERTY_PYTHON_SEARCH_PATHS, (String)PythonSetupTester.INSTANCE.getDefaultSearchPathValues());
        }
        ParameterService.saveParameters();
        PythonSetupTester.INSTANCE.autodetectPath();
    }

    public static void initPluginForFirstTime() {
        if (initialized) {
            return;
        }
        initialized = true;
        String initializedString = ParameterService.getParameterValue((String)PROPERTY_EXTENSION_INITIALIZED);
        final String packageManager = ParameterService.getParameterValue((String)PROPERTY_PACKAGE_MANAGER);
        final String binaryPath = ParameterService.getParameterValue((String)PROPERTY_PYTHON_BINARY);
        LogService.getRoot().finest(String.format("%s=%s", PROPERTY_EXTENSION_INITIALIZED, initializedString));
        if (!Boolean.parseBoolean(initializedString)) {
            String version82PythonBinary = ParameterService.getParameterValue((String)PROPERTY_PYTHON_PATH_V82);
            if (version82PythonBinary != null && version82PythonBinary.length() > 0) {
                LogService.getRoot().info(String.format("Using Python binary defined in the previous version of Python Scripting extension: %s", version82PythonBinary));
                ParameterService.setParameterValue((String)PROPERTY_PACKAGE_MANAGER, (String)PACKAGE_MANAGER_BINARIES);
                ParameterService.setParameterValue((String)PROPERTY_PYTHON_BINARY, (String)version82PythonBinary);
            } else {
                boolean runningInsideEB = false;
                try {
                    URI location = PluginInitProfessional.class.getProtectionDomain().getCodeSource().getLocation().toURI();
                    runningInsideEB = "vfs".equals(location.getScheme()) && location.getPath().contains("rapidminer-execution");
                }
                catch (Throwable t) {
                    LogService.getRoot().fine("Failed to check if running inside EB: " + t.toString());
                }
                if (runningInsideEB) {
                    LogService.getRoot().info("Skipping Python Scripting autodetect on execution backend.");
                } else if (RapidMiner.getExecutionMode().isHeadless()) {
                    PluginInitPythonScripting.callAutoDetect(packageManager, binaryPath);
                } else {
                    ProgressThread t = new ProgressThread(I18N.getGUIMessage((String)"python_scripting.init_thread", (Object[])new Object[0]), true){

                        public void run() {
                            PluginInitPythonScripting.callAutoDetect(packageManager, binaryPath);
                        }
                    };
                    t.setIndeterminate(true);
                    t.setCancelable(false);
                    t.start();
                }
            }
            ParameterService.setParameterValue((String)PROPERTY_EXTENSION_INITIALIZED, (String)String.valueOf(true));
            ParameterService.saveParameters();
        }
    }

    private static void updateLegacyPath(boolean saveParameters) {
        String defaultPythonBinary;
        try {
            Path defaultPythonBinaryPath = PluginInitPythonScripting.getDefaultPythonBinary();
            defaultPythonBinary = defaultPythonBinaryPath != null ? defaultPythonBinaryPath.toString() : null;
        }
        catch (InvalidPathException e) {
            LogService.getRoot().finest("Cannot get path for default python binary, reason: " + e.getMessage());
            defaultPythonBinary = "";
        }
        if (defaultPythonBinary != null) {
            ParameterService.setParameterValue((String)PROPERTY_PYTHON_PATH_V82, (String)defaultPythonBinary);
            ParameterService.setParameterValue((String)PROPERTY_INITIALIZED_V82, (String)String.valueOf(true));
            if (saveParameters) {
                ParameterService.saveParameters();
            }
        }
    }

    private static void callAutoDetect(String packageManager, String binaryPath) {
        boolean skipAutodetectPath;
        boolean bl = skipAutodetectPath = !"conda (anaconda)".equals(packageManager);
        if (PACKAGE_MANAGER_BINARIES.equals(packageManager) && (binaryPath == null || binaryPath.trim().length() == 0)) {
            skipAutodetectPath = false;
        }
        if (skipAutodetectPath) {
            LogService.getRoot().info("Python environment/binary is already configured in settings.");
        } else {
            PluginInitPythonScripting.autodetectPath();
        }
        PluginInitPythonScripting.updateLegacyPath(false);
    }

    public static void initGui(MainFrame mainframe) {
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeLinkButton.class, LinkButtonValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeScriptingEnvironment.class, PythonEnvironmentCellEditor.class);
        DropPythonFileIntoProcessCallback dropFile = new DropPythonFileIntoProcessCallback();
        DropFileIntoProcessActionRegistry.getInstance().registerCallback(FILE_SUFFIX_PY, (Object)dropFile);
        DropFileIntoProcessActionRegistry.getInstance().registerCallback(FILE_SUFFIX_IPYNB, (Object)dropFile);
        OpenPythonEntryCallback openFile = new OpenPythonEntryCallback();
        OpenBinaryEntryActionRegistry.getInstance().registerCallback(FILE_SUFFIX_PY, (Object)openFile);
        OpenBinaryEntryActionRegistry.getInstance().registerCallback(FILE_SUFFIX_IPYNB, (Object)openFile);
        DropPythonEntryIntoProcessCallback openEntry = new DropPythonEntryIntoProcessCallback();
        DropBinaryEntryIntoProcessActionRegistry.getInstance().registerCallback(FILE_SUFFIX_PY, (Object)openEntry);
        DropBinaryEntryIntoProcessActionRegistry.getInstance().registerCallback(FILE_SUFFIX_IPYNB, (Object)openEntry);
        RepositoryEntryIconRegistry.getInstance().registerCallback(FILE_SUFFIX_PY, () -> "python.png");
        RepositoryEntryIconRegistry.getInstance().registerCallback(FILE_SUFFIX_IPYNB, () -> "python.png");
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeOperator.class, OperatorCellEditor.class);
        PythonOperatorCallback dropOrOpenFile = new PythonOperatorCallback();
        DropBinaryEntryIntoProcessActionRegistry.getInstance().registerCallback("pyop", (Object)dropOrOpenFile);
        OpenBinaryEntryActionRegistry.getInstance().registerCallback("pyop", (Object)dropOrOpenFile);
        RepositoryEntryIconRegistry.getInstance().registerCallback("pyop", () -> "python.png");
        RepositoryTree.addRepositoryAction(CreateExtensionAction.class, (RepositoryActionCondition)new CreateExtensionAction.CreateExtensionCondition(), CreateFolderAction.class, (boolean)true, (boolean)false);
    }

    public static void initFinalChecks() {
    }

    public static void initPluginManager() {
        ParameterService.registerParameterChangeListener((ParameterChangeListener)new ParameterChangeListener(){
            private boolean updated = true;
            private final Set<String> PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("rapidminer.python_scripting.package_manager", "rapidminer.python_scripting.conda_environment", "rapidminer.python_scripting.venvw_environment", "rapidminer.python_scripting.python_binary", "rapidminer.python_scripting.cached.binaries", "rapidminer.python_scripting.hidden.initialized", "rapidminer.python_scripting.search_paths")));

            public void informParameterSaved() {
                if (this.updated) {
                    Thread refreshProcessThread = new Thread(() -> {
                        MainFrame mainFrame = RapidMinerGUI.getMainFrame();
                        if (mainFrame != null) {
                            mainFrame.getProcess().getRootOperator().checkAll();
                            mainFrame.fireProcessUpdated();
                        }
                    });
                    refreshProcessThread.setDaemon(true);
                    refreshProcessThread.setName("refresh-process-thread");
                    refreshProcessThread.start();
                    this.updated = false;
                    PluginInitPythonScripting.updateLegacyPath(true);
                }
            }

            public void informParameterChanged(String key, String value) {
                if (this.PROPERTIES.contains(key)) {
                    this.updated = true;
                }
            }
        });
    }

    public static Boolean useExtensionTreeRoot() {
        return false;
    }

    public static void setTemporaryDefaultPythonBinary(Path binary) {
        temporaryDefaultPythonBinary = binary;
    }

    public static Path getDefaultPythonBinary() {
        if (temporaryDefaultPythonBinary != null) {
            return temporaryDefaultPythonBinary;
        }
        String packageManager = ParameterService.getParameterValue((String)PROPERTY_PACKAGE_MANAGER);
        if (packageManager == null) {
            packageManager = PACKAGE_MANAGER_BINARIES;
        }
        Path binary = null;
        switch (packageManager) {
            case "conda (anaconda)": {
                String condaEnv = ParameterService.getParameterValue((String)PROPERTY_CONDA_ENVIRONMENT);
                if (condaEnv == null) break;
                binary = PythonSetupTester.INSTANCE.getFullPathForCondaEnvironment(condaEnv);
                break;
            }
            case "virtualenvwrapper": {
                String virtualEnv = ParameterService.getParameterValue((String)PROPERTY_VENVW_ENVIRONMENT);
                if (virtualEnv == null) break;
                binary = PythonSetupTester.INSTANCE.getFullPathForVenvwEnvironment(virtualEnv);
                break;
            }
            default: {
                String path = ParameterService.getParameterValue((String)PROPERTY_PYTHON_BINARY);
                if (path == null) break;
                binary = PythonSetupTester.INSTANCE.getFullPathForPythonBinary(path);
            }
        }
        return binary;
    }

    public static String getDefaultPackageManagerSettingForLogging() {
        if (temporaryDefaultPythonBinary != null) {
            return "custom";
        }
        String packageManager = ParameterService.getParameterValue((String)PROPERTY_PACKAGE_MANAGER);
        if (packageManager.equals("conda (anaconda)")) {
            return "conda";
        }
        if (packageManager.equals(PACKAGE_MANAGER_VENVW)) {
            return PACKAGE_MANAGER_VENVW;
        }
        return "custom";
    }

    public static String getDefaultPythonEnvironmentName() {
        if (temporaryDefaultPythonBinary != null) {
            return temporaryDefaultPythonBinary.toString();
        }
        String packageManager = ParameterService.getParameterValue((String)PROPERTY_PACKAGE_MANAGER);
        if (packageManager.equals("conda (anaconda)")) {
            return ParameterService.getParameterValue((String)PROPERTY_CONDA_ENVIRONMENT);
        }
        if (packageManager.equals(PACKAGE_MANAGER_VENVW)) {
            return ParameterService.getParameterValue((String)PROPERTY_VENVW_ENVIRONMENT);
        }
        return ParameterService.getParameterValue((String)PROPERTY_PYTHON_BINARY);
    }

    public static String getCurrentSearchPath() {
        if (currentSearchPath == null) {
            String value = ParameterService.getParameterValue((String)PROPERTY_PYTHON_SEARCH_PATHS);
            if (value == null) {
                return "";
            }
            return value;
        }
        return currentSearchPath;
    }

    public static String[] getPackageManagers() {
        return PACKAGE_MANAGERS;
    }

    public static List<String> getShellCommand() {
        String value = ParameterService.getParameterValue((String)PROPERTY_SHELL_COMMAND);
        if (value == null) {
            value = DEFAULT_SHELL_COMMAND;
        }
        return Collections.unmodifiableList(Arrays.asList(value.split(" ")));
    }

    public static Charset getExtensionDefaultEncoding() {
        return Process.getEncoding(null);
    }

    public static String getVersion() {
        return Plugin.getPluginByExtensionId((String)"rmx_python_scripting").getVersion();
    }

    /*
     * Exception decompiling
     */
    public static void logExtensionProperties() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void lambda$logExtensionProperties$6(String[] s) {
        LogService.getRoot().info(String.format("%s=%s", s[0], s[1]));
    }

    private static /* synthetic */ boolean lambda$logExtensionProperties$5(String[] s) {
        return s[1] != null && s[1].length() > 0;
    }

    static {
        try {
            JarVerifier.verify((Class[])new Class[]{LicenseManagerRegistry.INSTANCE.get().getClass(), RapidMiner.class, PluginInitProfessional.class, PluginInitPythonScripting.class});
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

