/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.connection;

import com.rapidminer.connection.ConnectionHandler;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.ConnectionInformationBuilder;
import com.rapidminer.connection.configuration.ConfigurationParameter;
import com.rapidminer.connection.configuration.ConnectionConfigurationBuilder;
import com.rapidminer.connection.util.ParameterUtility;
import com.rapidminer.connection.util.TestExecutionContext;
import com.rapidminer.connection.util.TestResult;
import com.rapidminer.connection.util.ValidationResult;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StandPyConnectionHandler
implements ConnectionHandler {
    public static final String TYPE = "python_scripting:standpy";
    public static final String SETUP_GROUP = "basic";
    public static final String KEY_ENDPOINT = "endpoint";
    public static final String KEY_TOKEN = "token";
    private static final ValidationResult INVALID_HOST = ValidationResult.failure((String)"standpy.validation.invalid_uri", (Map)null, (Object[])new Object[0]);
    private static final ValidationResult INVALID_TOKEN = ValidationResult.failure((String)"standpy.validation.invalid_token", (Map)null, (Object[])new Object[0]);

    public ConnectionInformation createNewConnectionInformation(String name) {
        ConnectionConfigurationBuilder configBuilder = new ConnectionConfigurationBuilder(name, this.getType());
        configBuilder.withKeys(SETUP_GROUP, Arrays.asList((ConfigurationParameter)ParameterUtility.getCPBuilder((String)KEY_ENDPOINT, (boolean)false).build(), (ConfigurationParameter)ParameterUtility.getCPBuilder((String)KEY_TOKEN, (boolean)true).build()));
        ConnectionInformationBuilder infoBuilder = new ConnectionInformationBuilder(configBuilder.build());
        return infoBuilder.build();
    }

    public void initialize() {
    }

    public boolean isInitialized() {
        return true;
    }

    public String getType() {
        return TYPE;
    }

    public ValidationResult validate(ConnectionInformation object) {
        Pattern pattern;
        Matcher matcher;
        String endpoint = object.getConfiguration().getValue("basic.endpoint");
        String token = object.getConfiguration().getValue("basic.token");
        try {
            boolean unknownHost;
            URI uri = new URI(endpoint);
            boolean unknownScheme = !"http".equals(uri.getScheme()) && !"https".equals(uri.getScheme());
            boolean bl = unknownHost = uri.getHost() == null;
            if (unknownScheme || unknownHost) {
                return INVALID_HOST;
            }
        }
        catch (NullPointerException | URISyntaxException e) {
            return INVALID_HOST;
        }
        if (token != null && (matcher = (pattern = Pattern.compile("\\s|\\n")).matcher(token)).find()) {
            return INVALID_TOKEN;
        }
        return ValidationResult.success((String)"standpy.validation.success");
    }

    public TestResult test(TestExecutionContext<ConnectionInformation> testContext) {
        return TestResult.success((String)"standpy.test.validation_success");
    }
}

