/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.definition;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.rapidminer.extension.pythonscripting.definition.DynamicParameter;
import com.rapidminer.extension.pythonscripting.definition.DynamicPort;
import com.rapidminer.extension.pythonscripting.definition.InvalidDeclarationException;
import com.rapidminer.extension.pythonscripting.definition.OperatorConfiguration;
import com.rapidminer.extension.pythonscripting.definition.OperatorDeclaration;
import com.rapidminer.tools.LogService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Level;

public final class ConfigurationTools {
    private static final String RESOURCES_FOLDER = "com/rapidminer/resources/";
    private static final Set<String> INVALID_PARAMETER_NAMES = new HashSet<String>();
    private static final ObjectMapper MAPPER;
    private static final Set<String> BOUNDED_TYPES;

    private ConfigurationTools() {
        throw new AssertionError((Object)"Static utility class must not be instantiated.");
    }

    public static OperatorDeclaration readOperatorDeclaration(String json) throws IOException {
        return (OperatorDeclaration)MAPPER.readValue(json, OperatorDeclaration.class);
    }

    public static OperatorDeclaration readAndValidateOperatorDeclaration(String json, Set<String> staticParameters, Set<String> staticInputs, Set<String> staticOutputs) throws IOException {
        OperatorDeclaration declaration = (OperatorDeclaration)MAPPER.readValue(json, OperatorDeclaration.class);
        ConfigurationTools.validate(declaration, staticParameters, staticInputs, staticOutputs);
        return declaration;
    }

    public static OperatorConfiguration readOperatorConfiguration(InputStream in) throws IOException {
        return (OperatorConfiguration)MAPPER.readValue(in, OperatorConfiguration.class);
    }

    public static OperatorConfiguration readAndValidateOperatorConfiguration(InputStream in, Set<String> staticParameters, Set<String> staticInputs, Set<String> staticOutputs) throws IOException {
        OperatorConfiguration config = (OperatorConfiguration)MAPPER.readValue(in, OperatorConfiguration.class);
        ConfigurationTools.validate(config.getDeclaration(), staticParameters, staticInputs, staticOutputs);
        return config;
    }

    public static void writeOperatorDeclaration(Writer writer, OperatorDeclaration declaration) throws IOException {
        MAPPER.writeValue(writer, (Object)declaration);
    }

    public static void writeOperatorConfiguration(OutputStream out, OperatorConfiguration operator) throws IOException {
        MAPPER.writeValue(out, (Object)operator);
    }

    public static void validate(OperatorDeclaration declaration, Set<String> parameters, Set<String> staticInputs, Set<String> staticOutputs) throws InvalidDeclarationException {
        ConfigurationTools.validatePorts(declaration.getInputs(), staticInputs);
        ConfigurationTools.validatePorts(declaration.getOutputs(), staticOutputs);
        ConfigurationTools.validateParameters(declaration, parameters);
    }

    private static void validateParameters(OperatorDeclaration declaration, Set<String> staticParameters) throws InvalidDeclarationException {
        List<DynamicParameter> parameters = declaration.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            HashSet<String> names = new HashSet<String>(INVALID_PARAMETER_NAMES);
            names.addAll(staticParameters);
            int selectorCount = 0;
            for (DynamicParameter parameter : parameters) {
                String name = parameter.getName();
                if (name == null || name.trim().isEmpty()) {
                    throw new InvalidDeclarationException("Parameter with missing or empty name.");
                }
                if (names.contains(name)) {
                    throw new InvalidDeclarationException(String.format("Duplicate or invalid parameter '%s'.", name));
                }
                names.add(name);
                if (parameter.getType() == null) {
                    throw new InvalidDeclarationException(String.format("Parameter '%s' has an invalid type.", name));
                }
                ConfigurationTools.validateMinMax(parameter);
                ConfigurationTools.validateCategorical(parameter);
                selectorCount = ConfigurationTools.validateAttributes(parameter, declaration.getInputs(), selectorCount);
            }
        }
    }

    private static void validateMinMax(DynamicParameter parameter) throws InvalidDeclarationException {
        String type = parameter.getType();
        String name = parameter.getName();
        if (BOUNDED_TYPES.contains(type)) {
            if (parameter.getMaxOrDefault(Double.NaN) < parameter.getMinOrDefault(Double.NaN)) {
                String message = "The maximum value for parameter '%s' is larger than its minimum.";
                throw new InvalidDeclarationException(String.format(message, name));
            }
        } else if (parameter.getMin() != null || parameter.getMax() != null) {
            String message = "Parameter '%s' of type '%s' does not support min/max values.";
            throw new InvalidDeclarationException(String.format(message, name, type));
        }
    }

    private static void validateCategorical(DynamicParameter parameter) throws InvalidDeclarationException {
        if (!"category".equals(parameter.getType())) {
            return;
        }
        String name = parameter.getName();
        List<String> categories = parameter.getCategories();
        if (categories == null || categories.isEmpty()) {
            throw new InvalidDeclarationException(String.format("No categories defined for parameter '%s'.", name));
        }
        Object value = parameter.getValue();
        if (value != null && !categories.contains(value.toString())) {
            throw new InvalidDeclarationException(String.format("Invalid default category for parameter '%s'.", name));
        }
    }

    private static int validateAttributes(DynamicParameter parameter, List<DynamicPort> inputs, int selectorCount) throws InvalidDeclarationException {
        String message;
        if (!"attributes".equals(parameter.getType())) {
            return selectorCount;
        }
        if (selectorCount > 0) {
            String message2 = "Parameter '%s' defines a 2nd attributes selector (only one allowed).";
            throw new InvalidDeclarationException(String.format(message2, parameter.getName()));
        }
        if (parameter.getValue() == null) {
            String message3 = "Parameter '%s' does not reference any input.";
            throw new InvalidDeclarationException(String.format(message3, parameter.getName(), parameter.getValue()));
        }
        DynamicPort target = null;
        for (DynamicPort port : inputs) {
            if (!port.getName().equals(parameter.getValue())) continue;
            target = port;
            break;
        }
        if (target == null) {
            message = "Parameter '%s' references undefined input '%s'.";
            throw new InvalidDeclarationException(String.format(message, parameter.getName(), parameter.getValue()));
        }
        if (!"table".equals(target.getType())) {
            message = "Parameter '%s' references incompatible input '%s'. Only type 'table' is supported.";
            throw new InvalidDeclarationException(String.format(message, parameter.getName()));
        }
        return selectorCount + 1;
    }

    private static void validatePorts(List<DynamicPort> ports, Set<String> staticPorts) throws InvalidDeclarationException {
        if (ports == null || ports.isEmpty()) {
            return;
        }
        HashSet<String> names = new HashSet<String>(ports.size());
        for (DynamicPort input : ports) {
            String name = input.getName();
            if (name == null) {
                throw new InvalidDeclarationException("Port with missing or empty name.");
            }
            if (names.contains(name)) {
                throw new InvalidDeclarationException(String.format("Duplicate or invalid port '%s'.", name));
            }
            if (staticPorts.contains(name)) {
                throw new InvalidDeclarationException(String.format("User configurable ports cannot have the same name as a static port. The name: '%s' is reserved.", name));
            }
            names.add(name);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String loadTextFile(String file) {
        ClassLoader loader = ConfigurationTools.class.getClassLoader();
        String path = RESOURCES_FOLDER + file;
        try (InputStream in = Objects.requireNonNull(loader.getResourceAsStream(path));){
            Scanner scanner = new Scanner(in).useDelimiter("\\A");
            try {
                String string;
                String string2 = string = scanner.hasNext() ? scanner.next() : "";
                if (scanner != null) {
                    scanner.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (scanner != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.SEVERE, "Failed to load {0}.", file);
            return "";
        }
    }

    static {
        INVALID_PARAMETER_NAMES.add("operator");
        INVALID_PARAMETER_NAMES.add("editable");
        INVALID_PARAMETER_NAMES.add("attribute_filter_type");
        INVALID_PARAMETER_NAMES.add("also_apply_to_special_attributes_(id,_label..)");
        INVALID_PARAMETER_NAMES.add("type");
        INVALID_PARAMETER_NAMES.add("exclude_expression");
        INVALID_PARAMETER_NAMES.add("expression");
        INVALID_PARAMETER_NAMES.add("select_subset");
        INVALID_PARAMETER_NAMES.add("type_of_value");
        INVALID_PARAMETER_NAMES.add("attribute");
        MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).configure(DeserializationFeature.ACCEPT_FLOAT_AS_INT, true).configure(SerializationFeature.INDENT_OUTPUT, true).setSerializationInclusion(JsonInclude.Include.NON_ABSENT).setSerializationInclusion(JsonInclude.Include.NON_NULL).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        BOUNDED_TYPES = new HashSet<String>();
        BOUNDED_TYPES.add("integer");
        BOUNDED_TYPES.add("real");
    }
}

