/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.generation;

import com.rapidminer.extension.pythonscripting.definition.ConfigurationTools;
import com.rapidminer.extension.pythonscripting.definition.OperatorConfiguration;
import com.rapidminer.extension.pythonscripting.definition.OperatorDeclaration;
import com.rapidminer.extension.pythonscripting.generation.ClassTools;
import com.rapidminer.extension.pythonscripting.generation.XmlTools;
import com.rapidminer.extension.pythonscripting.operator.PythonForecaster;
import com.rapidminer.extension.pythonscripting.operator.PythonLearner;
import com.rapidminer.extension.pythonscripting.operator.PythonOperator;
import com.rapidminer.extension.pythonscripting.operator.PythonTransformer;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

public class ExtensionBuilder {
    private static final String DEFAULT_GROUPS = ConfigurationTools.loadTextFile("groupsPythonScripting.properties");
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(?:0|[1-9][0-9]*)\\.(?:0|[1-9][0-9]*)\\.(?:0|[1-9][0-9]*)(?:-[a-zA-Z0-9]+)?$");
    private static final Map<String, Class<? extends PythonOperator>> CLASS_MAP = new HashMap<String, Class<? extends PythonOperator>>(2);
    private final String name;
    private final List<OperatorConfiguration> operators;
    private final String version;
    private String vendor;
    private String homepage;

    public ExtensionBuilder(String name, String version) {
        this.name = name;
        this.version = version;
        this.vendor = "RapidMiner GmbH";
        this.homepage = "www.rapidminer.com";
        this.operators = new ArrayList<OperatorConfiguration>();
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public ExtensionBuilder addOperator(OperatorConfiguration configuration) {
        this.operators.add(configuration);
        return this;
    }

    public void build(Path jarLocation) throws IOException {
        this.validate();
        String namespace = ExtensionBuilder.getNamespace(this.name);
        String path = "com/rapidminer/extension/" + namespace + "/";
        HashMap<String, GeneratedOperator> generated = new HashMap<String, GeneratedOperator>(this.operators.size());
        for (OperatorConfiguration config : this.operators) {
            OperatorDeclaration declaration = config.getDeclaration();
            String operatorName = declaration.getName();
            String operatorKey = ExtensionBuilder.getNamespace(operatorName);
            String className = ExtensionBuilder.getClassName(operatorName);
            String type = config.getType();
            StringWriter writer = new StringWriter();
            ConfigurationTools.writeOperatorDeclaration(writer, declaration);
            byte[] operatorCode = ClassTools.writeOperator(path, className, CLASS_MAP.get(type), writer.toString(), config.getDefinition());
            generated.put(operatorKey, new GeneratedOperator(operatorKey, type, operatorName, className, operatorCode));
        }
        Manifest manifest = this.createManifest(path, namespace);
        try (JarOutputStream jar = new JarOutputStream(Files.newOutputStream(jarLocation, new OpenOption[0]), manifest);){
            jar.putNextEntry(new ZipEntry(path + "Operators.xml"));
            jar.write(XmlTools.writeOperators(namespace, generated).getBytes(StandardCharsets.UTF_8));
            jar.closeEntry();
            jar.putNextEntry(new ZipEntry(path + "OperatorsDocumentation.xml"));
            jar.write(XmlTools.writeOperatorHelp(generated).getBytes(StandardCharsets.UTF_8));
            jar.closeEntry();
            jar.putNextEntry(new ZipEntry(path + "Groups.properties"));
            jar.write(DEFAULT_GROUPS.getBytes(StandardCharsets.UTF_8));
            jar.closeEntry();
            jar.putNextEntry(new ZipEntry(path + "PluginInit.class"));
            jar.write(ClassTools.writePluginInit(path));
            jar.closeEntry();
            for (Map.Entry entry : generated.entrySet()) {
                GeneratedOperator operator = (GeneratedOperator)entry.getValue();
                jar.putNextEntry(new ZipEntry(path + operator.getClassName() + ".class"));
                jar.write(((GeneratedOperator)entry.getValue()).getByteCode());
                jar.closeEntry();
                String documentation = namespace + ("learner".equals(operator.type) || "forecaster".equals(operator.type) ? "/modeling/" : "/blending/") + operator.getKey() + ".xml";
                jar.putNextEntry(new ZipEntry(documentation));
                jar.write(XmlTools.writeOperatorDocumentation(namespace, operator).getBytes(StandardCharsets.UTF_8));
                jar.closeEntry();
            }
            jar.finish();
        }
    }

    private Manifest createManifest(String path, String namespace) {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        attributes.putValue("RapidMiner-Version", "10.5.1");
        attributes.putValue("Plugin-Dependencies", "rmx_python_scripting[11.0.4]");
        attributes.putValue("Implementation-Title", this.name);
        attributes.putValue("Implementation-Version", this.version);
        attributes.putValue("Specification-Vendor", this.vendor);
        attributes.putValue("Specification-Title", this.name);
        attributes.putValue("Operator-Descriptor", path + "Operators.xml");
        attributes.putValue("RapidMiner-Type", "RapidMiner_Extension");
        attributes.putValue("Implementation-Vendor", this.vendor);
        attributes.putValue("Extension-ID", "rmx_" + namespace);
        attributes.putValue("Namespace", namespace);
        attributes.putValue("Created-By", this.vendor);
        attributes.putValue("Specification-Version", this.version);
        attributes.putValue("Implementation-URL", this.homepage);
        attributes.putValue("Initialization-Class", path.replace('/', '.') + "PluginInit");
        attributes.putValue("Group-Descriptor", path + "Groups.properties");
        return manifest;
    }

    public static String getNamespace(String string) {
        String[] segments = string.split("[^a-zA-Z0-9]+");
        StringJoiner joiner = new StringJoiner("_");
        for (String segment : segments) {
            joiner.add(segment.toLowerCase(Locale.ENGLISH));
        }
        return joiner.toString();
    }

    private static String getClassName(String string) {
        String[] segments = string.split("[^a-zA-Z0-9]+");
        StringBuilder builder = new StringBuilder();
        for (String segment : segments) {
            builder.append(segment.substring(0, 1).toUpperCase(Locale.ENGLISH));
            builder.append(segment.substring(1).toLowerCase(Locale.ENGLISH));
        }
        return builder.toString();
    }

    private void validate() throws ExtensionBuilderException {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new ExtensionBuilderException("The extension name must not be empty.");
        }
        if (ExtensionBuilder.getNamespace(this.name).isEmpty()) {
            throw new ExtensionBuilderException("The extension name must contain alpha-numeric segments.");
        }
        if (this.version == null || !VERSION_PATTERN.matcher(this.version).matches()) {
            throw new ExtensionBuilderException("Invalid extension version. Examples of valid version strings are 1.5.3 or 2.0.0-BETA.");
        }
        HashSet<String> names = new HashSet<String>(this.operators.size());
        for (OperatorConfiguration operator : this.operators) {
            String operatorName = operator.getDeclaration().getName();
            if (names.contains(operatorName)) {
                throw new ExtensionBuilderException("Duplicate operator name: " + operatorName);
            }
            names.add(operatorName);
        }
    }

    static {
        CLASS_MAP.put("learner", PythonLearner.class);
        CLASS_MAP.put("transformer", PythonTransformer.class);
        CLASS_MAP.put("forecaster", PythonForecaster.class);
    }

    static final class GeneratedOperator {
        private final String key;
        private final String type;
        private final String name;
        private final String className;
        private final byte[] byteCode;

        private GeneratedOperator(String key, String type, String name, String className, byte[] byteCode) {
            this.key = key;
            this.type = type;
            this.name = name;
            this.className = className;
            this.byteCode = byteCode;
        }

        public String getKey() {
            return this.key;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.className;
        }

        public byte[] getByteCode() {
            return this.byteCode;
        }
    }

    private static class ExtensionBuilderException
    extends IOException {
        public ExtensionBuilderException(String message) {
            super(message);
        }
    }
}

