/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.generation;

import com.rapidminer.repository.BinaryEntry;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.tools.LogService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public final class RepositoryTools {
    private RepositoryTools() {
        throw new AssertionError((Object)"Static utility class must not be instantiated.");
    }

    public static List<BinaryEntry> scanFolder(Folder folder) {
        if (folder == null) {
            return Collections.emptyList();
        }
        ArrayList<BinaryEntry> entryList = new ArrayList<BinaryEntry>();
        try {
            List folders = folder.getSubfolders();
            for (Folder subFolder : folders) {
                entryList.addAll(RepositoryTools.scanFolder(subFolder));
            }
        }
        catch (RepositoryException folders) {
            // empty catch block
        }
        try {
            List entries = folder.getDataEntries();
            for (DataEntry entry : entries) {
                BinaryEntry binaryEntry;
                if (!(entry instanceof BinaryEntry) || !"pyop".equals((binaryEntry = (BinaryEntry)entry).getSuffix())) continue;
                entryList.add(binaryEntry);
            }
        }
        catch (RepositoryException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to scan folder.", e);
        }
        return entryList;
    }
}

