/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.generation;

import com.rapidminer.extension.pythonscripting.definition.ConfigurationTools;
import com.rapidminer.extension.pythonscripting.generation.ExtensionBuilder;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class XmlTools {
    private static final String DOC_LEARNER = ConfigurationTools.loadTextFile("scripts/learner_documentation_template.xml");
    private static final String DOC_TRANSFORMER = ConfigurationTools.loadTextFile("scripts/transformer_documentation_template.xml");
    private static final String DOC_FORECASTER = ConfigurationTools.loadTextFile("scripts/forecaster_documentation_template.xml");
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final Map<String, String> GROUP_MAP = new HashMap<String, String>(2);

    private XmlTools() {
        throw new AssertionError((Object)"Static utility class must not be instantiated.");
    }

    public static String writeOperators(String packageName, Map<String, ExtensionBuilder.GeneratedOperator> operators) {
        StringWriter writer = new StringWriter();
        String packagePath = "com/rapidminer/extension/" + packageName;
        String classPath = packagePath.replace("/", ".");
        try {
            XMLStreamWriter xml = XML_OUTPUT_FACTORY.createXMLStreamWriter(writer);
            xml.writeStartDocument();
            xml.writeStartElement("operators");
            xml.writeAttribute("name", packageName);
            xml.writeAttribute("version", "6.0");
            xml.writeAttribute("docbundle", packagePath + "/OperatorsDocumentation");
            for (String group : new String[]{"modeling", "blending"}) {
                xml.writeStartElement("group");
                xml.writeAttribute("key", group);
                for (Map.Entry<String, ExtensionBuilder.GeneratedOperator> entry : operators.entrySet()) {
                    ExtensionBuilder.GeneratedOperator operator = entry.getValue();
                    String operatorGroup = GROUP_MAP.get(operator.getType());
                    if (!group.equals(operatorGroup)) continue;
                    xml.writeStartElement("operator");
                    xml.writeStartElement("key");
                    xml.writeCharacters(entry.getKey());
                    xml.writeEndElement();
                    xml.writeStartElement("class");
                    xml.writeCharacters(classPath + "." + operator.getClassName());
                    xml.writeEndElement();
                    xml.writeStartElement("icon");
                    xml.writeCharacters("python.png");
                    xml.writeEndElement();
                    xml.writeEndElement();
                }
                xml.writeEndElement();
            }
            xml.writeEndDocument();
            xml.close();
        }
        catch (XMLStreamException e) {
            throw new AssertionError("Failed to create operator XML string.", e);
        }
        return writer.toString();
    }

    public static String writeOperatorHelp(Map<String, ExtensionBuilder.GeneratedOperator> operators) {
        StringWriter writer = new StringWriter();
        try {
            XMLStreamWriter xml = XML_OUTPUT_FACTORY.createXMLStreamWriter(writer);
            xml.writeStartDocument();
            xml.writeStartElement("operatorHelp");
            xml.writeAttribute("lang", "en_EN");
            for (Map.Entry<String, ExtensionBuilder.GeneratedOperator> entry : operators.entrySet()) {
                xml.writeStartElement("operator");
                xml.writeStartElement("key");
                xml.writeCharacters(entry.getKey());
                xml.writeEndElement();
                xml.writeStartElement("name");
                xml.writeCharacters(entry.getValue().getName());
                xml.writeEndElement();
                xml.writeEndElement();
            }
            xml.writeEndDocument();
            xml.close();
        }
        catch (XMLStreamException e) {
            throw new AssertionError("Failed to create operator documentation XML string.", e);
        }
        return writer.toString();
    }

    public static String writeOperatorDocumentation(String extensionKey, ExtensionBuilder.GeneratedOperator operator) {
        String template = "learner".equals(operator.getType()) ? DOC_LEARNER : ("transformer".equals(operator.getType()) ? DOC_TRANSFORMER : DOC_FORECASTER);
        return template.replace("${EXT_KEY}", extensionKey).replace("${OP_KEY}", operator.getKey()).replace("${OP_NAME}", operator.getName());
    }

    static {
        GROUP_MAP.put("learner", "modeling");
        GROUP_MAP.put("transformer", "blending");
        GROUP_MAP.put("forecaster", "modeling");
    }
}

