/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.gui.dialog;

import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.look.Colors;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.function.UnaryOperator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class CodeEditor
extends ButtonDialog {
    private final RSyntaxTextArea textArea;
    private String code;
    private boolean ok = false;

    public CodeEditor(String key, String code, String syntax, final UnaryOperator<String> hinter) {
        super((Window)ApplicationFrame.getApplicationFrame(), key, Dialog.ModalityType.APPLICATION_MODAL, new Object[0]);
        Object center;
        this.code = code;
        this.textArea = new RSyntaxTextArea();
        this.textArea.setDocument((Document)new RSyntaxDocument(syntax));
        this.textArea.setBorder(null);
        this.textArea.setAnimateBracketMatching(true);
        this.textArea.setAutoIndentEnabled(true);
        this.textArea.setAutoscrolls(true);
        this.textArea.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (SwingTools.isControlOrMetaDown((KeyEvent)e) && e.getKeyCode() == 10) {
                    CodeEditor.this.ok();
                }
            }
        });
        RTextScrollPane scrollPane = new RTextScrollPane((RTextArea)this.textArea);
        scrollPane.setBorder(BorderFactory.createLineBorder(Colors.TEXTFIELD_BORDER));
        scrollPane.setVerticalScrollBarPolicy(20);
        if (hinter == null) {
            center = scrollPane;
        } else {
            center = new JPanel();
            ((Container)center).setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 23;
            c.gridx = 0;
            ((Container)center).add((Component)scrollPane, c);
            final JLabel info = new JLabel();
            info.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Colors.TEXTFIELD_BORDER), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            info.setOpaque(true);
            info.setBackground(Colors.WARNING_COLOR);
            info.setVisible(false);
            c.weighty = 0.0;
            ((Container)center).add((Component)info, c);
            this.textArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    String hint = (String)hinter.apply(CodeEditor.this.textArea.getText());
                    info.setText(hint);
                    info.setVisible(hint != null);
                }
            });
        }
        this.textArea.setText(code);
        this.layoutDefault((JComponent)center, 3, new AbstractButton[]{this.makeOkButton("text_property_dialog_apply"), this.makeCancelButton()});
        this.textArea.requestFocusInWindow();
    }

    protected void ok() {
        this.ok = true;
        this.code = this.textArea.getText();
        this.dispose();
    }

    protected void cancel() {
        this.ok = false;
        this.dispose();
    }

    public boolean wasConfirmed() {
        return this.ok;
    }

    public String getCode() {
        return this.code;
    }
}

