/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.gui.dialog;

import com.rapidminer.extension.pythonscripting.definition.OperatorConfiguration;
import com.rapidminer.extension.pythonscripting.generation.ExtensionBuilder;
import com.rapidminer.extension.pythonscripting.gui.dialog.CreateExtensionDialog;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.RepositoryActionCondition;
import com.rapidminer.repository.gui.RepositoryTree;
import com.rapidminer.repository.gui.actions.AbstractRepositoryAction;
import com.rapidminer.tools.FileSystemService;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class CreateExtensionAction
extends AbstractRepositoryAction<Folder> {
    public CreateExtensionAction(RepositoryTree tree) {
        super(tree, Folder.class, false, "python_scripting.create_extension");
    }

    public void actionPerformed(Folder folder) {
        CreateExtensionDialog dialog = new CreateExtensionDialog(folder);
        dialog.setVisible(true);
        boolean actionCompleted = false;
        while (!actionCompleted && dialog.wasConfirmed()) {
            String name = dialog.getExtensionName();
            String version = dialog.getVersion();
            String vendor = dialog.getVendor();
            String homepage = dialog.getHomepage();
            ExtensionBuilder builder = new ExtensionBuilder(name, version);
            if (vendor != null) {
                builder.setVendor(vendor);
            }
            if (homepage != null) {
                builder.setHomepage(homepage);
            }
            for (OperatorConfiguration config : dialog.getConfigurations()) {
                builder.addOperator(config);
            }
            String file = String.format("rmx_%s-%s.jar", ExtensionBuilder.getNamespace(name), version);
            Path jarLocation = Paths.get(FileSystemService.getUserRapidMinerDir().getAbsolutePath(), "extensions", file);
            try {
                builder.build(jarLocation);
                actionCompleted = true;
                SwingTools.showMessageDialog((String)"python_scripting.export_completed", (Object[])new Object[]{file});
            }
            catch (IOException e) {
                SwingTools.showVerySimpleErrorMessage((String)"python_scripting.export_failed", (Object[])new Object[]{e.getMessage()});
                dialog.setVisible(true);
            }
        }
    }

    public static class CreateExtensionCondition
    implements RepositoryActionCondition {
        public boolean evaluateCondition(List<Entry> entryList) {
            for (Entry entry : entryList) {
                if (entry instanceof Folder) continue;
                return false;
            }
            return true;
        }
    }
}

