/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.gui.dialog;

import com.rapidminer.extension.pythonscripting.definition.ConfigurationTools;
import com.rapidminer.extension.pythonscripting.definition.OperatorConfiguration;
import com.rapidminer.extension.pythonscripting.generation.RepositoryTools;
import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.look.Colors;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.repository.BinaryEntry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.tools.LogService;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class CreateExtensionDialog
extends ButtonDialog {
    private boolean ok = false;
    private final JTextField nameInput = new JTextField();
    private final JTextField versionInput = new JTextField();
    private final JTextField vendorInput = new JTextField();
    private final JTextField homepageInput = new JTextField();
    private final JTextArea operatorList = new JTextArea();
    private transient List<OperatorConfiguration> configurations = Collections.emptyList();

    public CreateExtensionDialog(final Folder folder) {
        super((Window)ApplicationFrame.getApplicationFrame(), "python_scripting.create_extension", Dialog.ModalityType.APPLICATION_MODAL, new Object[0]);
        this.setEditable(false);
        this.layoutDefault(this.createMainPanel(), 5, new AbstractButton[]{this.makeOkButton("python_scripting.confirm_extension"), this.makeCancelButton()});
        ProgressThread scanner = new ProgressThread("scanner"){

            public void run() {
                List<BinaryEntry> entries = RepositoryTools.scanFolder(folder);
                CreateExtensionDialog.this.configurations = new ArrayList<OperatorConfiguration>();
                StringJoiner joiner = new StringJoiner(",\n");
                for (BinaryEntry entry : entries) {
                    try {
                        InputStream in = entry.openInputStream();
                        try {
                            OperatorConfiguration config = ConfigurationTools.readOperatorConfiguration(in);
                            CreateExtensionDialog.this.configurations.add(config);
                            joiner.add(config.getDeclaration().getName() + " (" + config.getType() + ", " + entry.getName() + ")");
                        }
                        finally {
                            if (in == null) continue;
                            in.close();
                        }
                    }
                    catch (RepositoryException | IOException e) {
                        LogService.getRoot().log(Level.WARNING, "Failed to load operator configuration.", e);
                    }
                }
                String list = joiner.toString();
                SwingUtilities.invokeLater(() -> {
                    CreateExtensionDialog.this.nameInput.setText(folder.getName());
                    CreateExtensionDialog.this.versionInput.setText("1.0.0");
                    CreateExtensionDialog.this.operatorList.setText(list);
                    CreateExtensionDialog.this.setEditable(true);
                });
            }
        };
        scanner.start();
    }

    public String getExtensionName() {
        return this.nameInput.getText();
    }

    public String getVersion() {
        return this.versionInput.getText();
    }

    public String getVendor() {
        return this.vendorInput.getText();
    }

    public String getHomepage() {
        return this.homepageInput.getText();
    }

    public List<OperatorConfiguration> getConfigurations() {
        return this.configurations;
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints lc = new GridBagConstraints();
        lc.fill = 2;
        lc.anchor = 23;
        lc.insets = new Insets(0, 0, 5, 32);
        lc.gridx = 0;
        GridBagConstraints vc = new GridBagConstraints();
        vc.fill = 1;
        vc.insets = new Insets(0, 0, 5, 0);
        vc.weightx = 1.0;
        vc.gridx = 1;
        panel.add((Component)this.createLabel("Extension name"), lc);
        panel.add((Component)this.nameInput, vc);
        panel.add((Component)this.createLabel("Version"), lc);
        panel.add((Component)this.versionInput, vc);
        panel.add((Component)this.createLabel("Vendor"), lc);
        panel.add((Component)this.vendorInput, vc);
        panel.add((Component)this.createLabel("Homepage"), lc);
        panel.add((Component)this.homepageInput, vc);
        vc.weighty = 1.0;
        panel.add((Component)this.createLabel("Operators"), lc);
        this.operatorList.setBorder(null);
        this.operatorList.setLineWrap(true);
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane((Component)this.operatorList);
        scrollPane.setBorder(BorderFactory.createLineBorder(Colors.TEXTFIELD_BORDER));
        panel.add((Component)scrollPane, vc);
        this.operatorList.setEditable(false);
        return panel;
    }

    private void setEditable(boolean editable) {
        this.nameInput.setEditable(editable);
        this.versionInput.setEditable(editable);
        this.vendorInput.setEditable(editable);
        this.homepageInput.setEditable(editable);
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        Dimension preferred = label.getPreferredSize();
        preferred.height = 32;
        label.setMinimumSize(preferred);
        label.setPreferredSize(preferred);
        return label;
    }

    protected void ok() {
        this.ok = true;
        this.dispose();
    }

    protected void cancel() {
        this.ok = false;
        this.dispose();
    }

    public boolean wasConfirmed() {
        return this.ok;
    }
}

