/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.gui.dialog;

import com.rapidminer.extension.pythonscripting.gui.dialog.CodeCell;
import com.rapidminer.extension.pythonscripting.gui.dialog.ErrorCodeCell;
import com.rapidminer.extension.pythonscripting.gui.dialog.IpynbFileMultipleCodeCellModel;
import com.rapidminer.extension.pythonscripting.gui.dialog.MultipleCodeCellModel;
import com.rapidminer.extension.pythonscripting.gui.dialog.TagModel;
import com.rapidminer.extension.pythonscripting.gui.dialog.TagView;
import com.rapidminer.extension.pythonscripting.gui.dialog.TaggedRSyntaxTextArea;
import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.components.FixedWidthEditorPane;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.parameter.TextType;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class MultipleCodeCellsPropertyDialog
extends ButtonDialog
implements TagView {
    private boolean ok = false;
    private boolean showsError = false;
    private List<TaggedRSyntaxTextArea> textAreas;
    private JButton okButton;
    private TextType textType;
    private JComponent textsPanel;
    private JCheckBox hideExcluded;
    private JCheckBox hideTags;
    private transient MultipleCodeCellModel codeCellModel;
    private boolean hasTags;
    private transient TagModel tags;

    private Set<String> getAllCodeCellTags() {
        return this.textAreas.stream().map(TaggedRSyntaxTextArea::getTags).collect(HashSet::new, AbstractCollection::addAll, AbstractCollection::addAll);
    }

    private boolean hasAllCodeCellTags() {
        return this.textAreas.stream().noneMatch(ta -> ta.getTags().isEmpty());
    }

    protected JToggleButton makeIncludeWithNoTagsButton() {
        JToggleButton includeWithNoTagsButton = new JToggleButton((Action)new ResourceAction("python_scripting.include_no_tag", new Object[0]){

            protected void loggedActionPerformed(ActionEvent e) {
                super.loggedActionPerformed(e);
                MultipleCodeCellsPropertyDialog.this.tags.setIncludeWithNoTag(!MultipleCodeCellsPropertyDialog.this.tags.isIncludeWithNoTag());
            }
        });
        includeWithNoTagsButton.setSelected(this.tags.isIncludeWithNoTag());
        this.tags.addChangeListener(e -> includeWithNoTagsButton.setSelected(this.tags.isIncludeWithNoTag()));
        return includeWithNoTagsButton;
    }

    protected JToggleButton makeiIncludeAllCellsButton() {
        JToggleButton includeAllCellsButton = new JToggleButton((Action)new ResourceAction("python_scripting.include_all", new Object[0]){

            protected void loggedActionPerformed(ActionEvent e) {
                super.loggedActionPerformed(e);
                if (MultipleCodeCellsPropertyDialog.this.tags.isAllIncluded(MultipleCodeCellsPropertyDialog.this.getAllCodeCellTags())) {
                    MultipleCodeCellsPropertyDialog.this.tags.excludeAll();
                } else {
                    MultipleCodeCellsPropertyDialog.this.tags.includeAll(MultipleCodeCellsPropertyDialog.this.getAllCodeCellTags());
                }
            }
        });
        includeAllCellsButton.setSelected(this.tags.isAllIncluded(this.getAllCodeCellTags()));
        this.tags.addChangeListener(e -> includeAllCellsButton.setSelected(this.tags.isAllIncluded(this.getAllCodeCellTags())));
        return includeAllCellsButton;
    }

    public MultipleCodeCellsPropertyDialog(TextType textType, MultipleCodeCellModel codeCellModel, String tagsRegexp) {
        super((Window)ApplicationFrame.getApplicationFrame(), "parameter.text", Dialog.ModalityType.APPLICATION_MODAL, new Object[0]);
        JComponent codePanel;
        this.codeCellModel = codeCellModel;
        this.textType = textType;
        this.hasTags = codeCellModel.hasTags();
        this.tags = new TagModel(codeCellModel, tagsRegexp);
        List<CodeCell> texts = codeCellModel.getCellContents();
        if (texts.isEmpty()) {
            texts = new ArrayList<CodeCell>();
            texts.add(new CodeCell(""));
        }
        this.showsError = texts.stream().anyMatch(c -> c instanceof ErrorCodeCell);
        this.textAreas = new ArrayList<TaggedRSyntaxTextArea>();
        for (CodeCell codeCell : texts) {
            this.textAreas.add(new TaggedRSyntaxTextArea(codeCell.getSource(), this.tags, this, codeCell.getTags(), !this.isIPythonNotebook()));
        }
        if (this.isIPythonNotebook()) {
            this.textsPanel = new JPanel();
            this.textsPanel.setLayout(new BoxLayout(this.textsPanel, 1));
            for (int i = 0; i < this.textAreas.size(); ++i) {
                this.textsPanel.add(this.textAreas.get(i));
                if (i != 0) continue;
                this.textAreas.get(i).resetCaretPosition();
                this.textAreas.get(i).requestFocusInWindow();
            }
            JScrollPane scrollPane = new JScrollPane(this.textsPanel);
            scrollPane.setBorder(null);
            scrollPane.setVerticalScrollBarPolicy(20);
            codePanel = scrollPane;
        } else {
            if (this.textAreas.size() > 0) {
                this.textsPanel = this.textAreas.get(0);
                this.textAreas.get(0).resetCaretPosition();
                this.textAreas.get(0).requestFocusInWindow();
            } else {
                this.textsPanel = new JPanel();
            }
            codePanel = this.textsPanel;
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.hideExcluded = new JCheckBox((Action)new ResourceAction("python_scripting.hide_excluded", new Object[0]){

            public void loggedActionPerformed(ActionEvent e) {
                super.loggedActionPerformed(e);
                MultipleCodeCellsPropertyDialog.this.updateInfoPanel(MultipleCodeCellsPropertyDialog.this.getInfoText());
                MultipleCodeCellsPropertyDialog.this.updateView();
            }
        });
        this.hideTags = new JCheckBox((Action)new ResourceAction("python_scripting.hide_tags", new Object[0]){

            public void loggedActionPerformed(ActionEvent e) {
                super.loggedActionPerformed(e);
                MultipleCodeCellsPropertyDialog.this.updateView();
            }
        });
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 0));
        checkBoxPanel.add(this.hideExcluded);
        checkBoxPanel.add(this.hideTags);
        mainPanel.add((Component)checkBoxPanel, "First");
        mainPanel.add((Component)codePanel, "Center");
        this.okButton = this.makeOkButton("text_property_dialog_apply");
        if (texts.size() > 0 && texts.stream().noneMatch(c -> c.supportsTags())) {
            this.okButton.setVisible(false);
            checkBoxPanel.setVisible(false);
            this.tags.setIncludeWithNoTag(true);
            this.layoutDefault(mainPanel, 1, new AbstractButton[]{this.makeCancelButton()});
        } else if (this.hasTags) {
            this.hideTags.setVisible(true);
            this.hideTags.setSelected(false);
            this.layoutDefault(mainPanel, 1, new AbstractButton[]{this.makeiIncludeAllCellsButton(), this.makeIncludeWithNoTagsButton(), this.okButton, this.makeCancelButton()});
        } else {
            this.hideTags.setVisible(false);
            this.hideTags.setSelected(true);
            this.hideExcluded.setVisible(false);
            this.layoutDefault(mainPanel, 1, new AbstractButton[]{this.makeCancelButton()});
        }
        SwingUtilities.invokeLater(() -> this.textsPanel.scrollRectToVisible(new Rectangle()));
        this.updateView();
        this.tags.addChangeListener(e -> this.updateView());
    }

    protected void ok() {
        this.ok = true;
        this.dispose();
    }

    protected void cancel() {
        this.ok = false;
        this.dispose();
    }

    protected boolean isIPythonNotebook() {
        return this.codeCellModel instanceof IpynbFileMultipleCodeCellModel;
    }

    protected String getResourceType() {
        if (this.isIPythonNotebook()) {
            return I18N.getGUIMessage((String)"gui.label.python_scripting.code_type_ipynb", (Object[])new Object[0]);
        }
        return I18N.getGUIMessage((String)"gui.label.python_scripting.code_type_py", (Object[])new Object[0]);
    }

    private String getErrorInfoText() {
        return I18N.getGUIMessage((String)"gui.label.python_scripting.error.info", (Object[])new Object[]{this.getResourceType()});
    }

    protected String getInfoText() {
        if (this.showsError) {
            return this.getErrorInfoText();
        }
        String infoText = I18N.getGUIMessage((String)"gui.label.python_scripting.code_preview.info", (Object[])new Object[]{this.getResourceType()});
        if (this.isIPythonNotebook()) {
            infoText = this.hideExcluded.isSelected() ? I18N.getGUIMessage((String)"gui.label.python_scripting.code_preview.info.detailed1", (Object[])new Object[]{infoText}) : I18N.getGUIMessage((String)"gui.label.python_scripting.code_preview.info.detailed2", (Object[])new Object[]{infoText});
        }
        return infoText;
    }

    protected void updateInfoPanel(String infoText) {
        Component comp = this.getRootPane().getContentPane().getComponent(0);
        if (comp instanceof JPanel) {
            JPanel infoPanel = (JPanel)comp;
            if ((comp = infoPanel.getComponent(1)) instanceof FixedWidthEditorPane) {
                FixedWidthEditorPane infoPane = (FixedWidthEditorPane)comp;
                infoPane.setText(infoText);
            } else {
                LogService.getRoot().warning("Error during updating info panel.");
            }
        } else {
            LogService.getRoot().warning("Error during updating info panel.");
        }
    }

    protected String getDialogTitle() {
        return I18N.getGUIMessage((String)"gui.label.python_scripting.code_preview", (Object[])new Object[0]);
    }

    public boolean isOk() {
        return this.ok;
    }

    @Override
    public boolean hideExcludedCells() {
        return this.hideExcluded.isSelected();
    }

    @Override
    public boolean hideTags() {
        return this.hideTags.isSelected();
    }

    @Override
    public void updateView() {
        for (TaggedRSyntaxTextArea ta : this.textAreas) {
            ta.updateState();
        }
        this.revalidate();
    }

    @Override
    public TextType getTextType() {
        return this.textType;
    }

    public boolean areTagsEdited() {
        return this.tags.isEdited();
    }

    public String getTagsRegex() {
        return this.tags.convertToRegex(this.getAllCodeCellTags(), this.hasAllCodeCellTags());
    }
}

