/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.gui.dialog;

import com.rapidminer.extension.pythonscripting.gui.dialog.CodeCell;
import com.rapidminer.extension.pythonscripting.gui.dialog.MultipleCodeCellModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class TagModel {
    private Set<String> tags;
    private boolean includeWithNoTag = false;
    private boolean edited = false;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    protected void notifyListeners() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public TagModel(MultipleCodeCellModel codeCellModel, String initialTagsRegexp) {
        this.tags = new HashSet<String>();
        Pattern pattern = Pattern.compile(initialTagsRegexp);
        for (CodeCell c : codeCellModel.getCellContents()) {
            for (String tag : c.getTags()) {
                if (!pattern.matcher(tag).find()) continue;
                this.tags.add(tag);
            }
        }
        this.includeWithNoTag = pattern.matcher("").find();
    }

    public boolean isIncluded(String tag) {
        return this.tags.contains(tag);
    }

    public void include(String tag) {
        if (!this.tags.contains(tag)) {
            this.edited = true;
            this.tags.add(tag);
            this.notifyListeners();
        }
    }

    public boolean isAllIncluded(Set<String> tags) {
        return this.tags.containsAll(tags) && this.isIncludeWithNoTag();
    }

    public void includeAll(Set<String> tags) {
        if (!this.isAllIncluded(tags)) {
            this.edited = true;
            this.tags.addAll(tags);
            this.includeWithNoTag = true;
            this.notifyListeners();
        }
    }

    public void exclude(String tag) {
        if (this.tags.contains(tag)) {
            this.edited = true;
            this.tags.remove(tag);
            this.notifyListeners();
        }
    }

    public void excludeAll() {
        if (!this.tags.isEmpty() || this.isIncludeWithNoTag()) {
            this.edited = true;
            this.tags.clear();
            this.includeWithNoTag = false;
            this.notifyListeners();
        }
    }

    public boolean isIncludeWithNoTag() {
        return this.includeWithNoTag;
    }

    public void setIncludeWithNoTag(boolean b) {
        if (b != this.includeWithNoTag) {
            this.edited = true;
            this.includeWithNoTag = b;
            this.notifyListeners();
        }
    }

    public boolean isEdited() {
        return this.edited;
    }

    public String convertToRegex(Set<String> tagUniverse, boolean hasAllCodeCellTags) {
        if (this.tags.containsAll(tagUniverse) && (this.isIncludeWithNoTag() || hasAllCodeCellTags)) {
            return "^(.*)$";
        }
        StringBuilder reg = new StringBuilder();
        for (String tag : this.tags) {
            if (reg.length() == 0 && !this.isIncludeWithNoTag()) {
                reg.append(tag);
                continue;
            }
            reg = reg.append("|").append(tag);
        }
        if (reg.length() == 0 && this.isIncludeWithNoTag()) {
            reg.append("?!.");
        }
        if (this.tags.isEmpty() && !this.isIncludeWithNoTag()) {
            reg.append("a^");
        }
        reg.insert(0, "^(").append(")$");
        return reg.toString();
    }
}

