/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.gui.dialog;

import com.rapidminer.extension.pythonscripting.gui.dialog.TagButtonModel;
import com.rapidminer.extension.pythonscripting.gui.dialog.TagModel;
import com.rapidminer.extension.pythonscripting.gui.dialog.TagView;
import com.rapidminer.gui.tools.SQLEditor;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.parameter.TextType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

class TaggedRSyntaxTextArea
extends JPanel {
    private static final Border CELL_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 1, 6, 1), BorderFactory.createLoweredSoftBevelBorder());
    private RSyntaxTextArea textArea;
    private RTextScrollPane scrollPane;
    private final boolean singleTextArea;
    private JPanel tagsPanel;
    private final Set<String> tags;
    private final transient TagModel tagModel;
    private final transient TagView tagView;
    private transient Style[] defaultStyles;
    private Color greyedOutForegroundColor = new Color(128, 128, 128);
    private Color greyedOutBackgroundColor = new Color(210, 210, 210);

    private void createTagsPanel(Set<String> tags) {
        this.tagsPanel = new JPanel(new FlowLayout(0, 6, 6));
        for (String tag : tags) {
            JToggleButton tagButton = new JToggleButton(tag);
            tagButton.setModel(new TagButtonModel(this.tagModel, this.tagView, tag, e -> tagButton.repaint()));
            this.tagsPanel.add(tagButton);
        }
    }

    private void saveStyles(Style[] styles) {
        this.defaultStyles = new Style[styles.length];
        for (int i = 0; i < styles.length; ++i) {
            this.defaultStyles[i] = styles[i] != null ? (Style)styles[i].clone() : null;
        }
    }

    private void setGreyedOut(boolean b) {
        if (b) {
            Style[] styles;
            for (Style s : styles = this.textArea.getSyntaxScheme().getStyles()) {
                if (s == null) continue;
                s.foreground = this.greyedOutForegroundColor;
                s.background = this.greyedOutBackgroundColor;
            }
            this.textArea.getSyntaxScheme().setStyles(styles);
            this.textArea.setBackground(this.greyedOutBackgroundColor);
        } else {
            Style[] styles = new Style[this.defaultStyles.length];
            for (int i = 0; i < styles.length; ++i) {
                styles[i] = this.defaultStyles[i] != null ? (Style)this.defaultStyles[i].clone() : null;
            }
            this.textArea.getSyntaxScheme().setStyles(styles);
            this.textArea.setBackground(Color.WHITE);
        }
    }

    private void updateGreyingOut() {
        boolean included = this.tagModel.isIncludeWithNoTag() && this.tags.isEmpty();
        for (String tag : this.tags) {
            if (!this.tagModel.isIncluded(tag)) continue;
            included = true;
        }
        this.setGreyedOut(!included);
        this.setVisible(included || !this.tagView.hideExcludedCells());
    }

    private void updateTagPanel() {
        this.tagsPanel.setVisible(!this.tagView.hideTags());
    }

    public void updateState() {
        this.updateTagPanel();
        this.updateGreyingOut();
    }

    private void createTextArea(String text) {
        if (this.getTextType().equals((Object)TextType.SQL)) {
            this.textArea = new SQLEditor();
        } else {
            this.textArea = new RSyntaxTextArea();
            this.textArea.setDocument((Document)new RSyntaxDocument(this.getTextType().getSyntaxIdentifier()));
        }
        this.saveStyles(this.textArea.getSyntaxScheme().getStyles());
        this.textArea.setMargin(new Insets(5, 0, 0, 0));
        this.textArea.setBracketMatchingEnabled(this.getTextType().isBracketMatching());
        this.textArea.setAnimateBracketMatching(this.getTextType().isBracketMatching());
        this.textArea.setAutoIndentEnabled(this.getTextType().isAutoIntending());
        this.textArea.setAutoscrolls(true);
        this.textArea.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!SwingTools.isControlOrMetaDown((KeyEvent)e) || e.getKeyCode() == 10) {
                    // empty if block
                }
            }
        });
        this.textArea.setText(text);
        this.textArea.setEditable(false);
        this.textArea.setMarkOccurrences(false);
        this.textArea.setUseSelectedTextColor(false);
        this.textArea.setHighlightCurrentLine(this.singleTextArea);
        if (this.singleTextArea) {
            this.scrollPane = new RTextScrollPane((RTextArea)this.textArea);
            this.scrollPane.setBorder(null);
            this.scrollPane.setHorizontalScrollBarPolicy(30);
            this.scrollPane.setVerticalScrollBarPolicy(20);
        }
    }

    public TaggedRSyntaxTextArea(String text, TagModel model, TagView view, Set<String> tags, boolean singleTextArea) {
        super(new BorderLayout());
        this.tags = tags;
        this.tagModel = model;
        this.tagView = view;
        this.singleTextArea = singleTextArea;
        this.createTextArea(text);
        this.createTagsPanel(tags);
        this.add((Component)this.tagsPanel, "North");
        if (singleTextArea) {
            this.add((Component)this.scrollPane, "Center");
        } else {
            this.add((Component)this.textArea, "Center");
        }
        if (tags.isEmpty()) {
            this.tagsPanel.setVisible(false);
        }
        this.setBorder(CELL_BORDER);
    }

    private TextType getTextType() {
        return this.tagView.getTextType();
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String t) {
        this.textArea.setText(t);
    }

    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.textArea.requestFocusInWindow();
    }

    public void resetCaretPosition() {
        this.textArea.setCaretPosition(0);
    }

    private int numberOfLines(String s) {
        if (s.length() == 0) {
            return 0;
        }
        int lines = 1;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\n') continue;
            ++lines;
        }
        return lines;
    }

    private Dimension updateSize(Dimension s) {
        s.height = this.textArea.getFontMetrics(this.textArea.getFont()).getHeight() * this.numberOfLines(this.textArea.getText()) + TaggedRSyntaxTextArea.CELL_BORDER.getBorderInsets((Component)this.tagsPanel).top + TaggedRSyntaxTextArea.CELL_BORDER.getBorderInsets((Component)this.tagsPanel).bottom + TaggedRSyntaxTextArea.CELL_BORDER.getBorderInsets((Component)this.textArea).top + TaggedRSyntaxTextArea.CELL_BORDER.getBorderInsets((Component)this.textArea).bottom;
        if (this.tagsPanel.isVisible()) {
            s.height += this.tagsPanel.getHeight();
        }
        return s;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.updateSize(super.getMinimumSize());
    }

    @Override
    public Dimension getPreferredSize() {
        return this.updateSize(super.getPreferredSize());
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
    }
}

