/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.gui.draganddrop;

import com.rapidminer.Process;
import com.rapidminer.extension.pythonscripting.gui.draganddrop.PythonOperatorFactory;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.repository.BinaryEntry;
import com.rapidminer.repository.gui.OpenBinaryEntryCallback;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public class OpenPythonEntryCallback
implements OpenBinaryEntryCallback {
    public void openEntry(BinaryEntry entry) {
        try {
            Process process = RapidMinerGUI.getMainFrame().getProcess();
            PythonOperatorFactory.getInstance().create(entry, process).forEach(op -> process.getRootOperator().getSubprocess(0).addOperator(op));
        }
        catch (OperatorCreationException e) {
            SwingUtilities.invokeLater(() -> SwingTools.showSimpleErrorMessage((String)"python_scripting.open_entry", (Throwable)e, (Object[])new Object[]{entry.getName(), e}));
            LogService.getRoot().log(Level.SEVERE, I18N.getGUIMessage((String)"gui.dialog.error.python_scripting.open_entry.message", (Object[])new Object[]{entry.getName(), e}));
        }
    }
}

