/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.gui.draganddrop;

import com.rapidminer.Process;
import com.rapidminer.extension.pythonscripting.definition.ConfigurationTools;
import com.rapidminer.extension.pythonscripting.definition.OperatorConfiguration;
import com.rapidminer.extension.pythonscripting.definition.OperatorDeclaration;
import com.rapidminer.extension.pythonscripting.operator.PythonForecaster;
import com.rapidminer.extension.pythonscripting.operator.PythonLearner;
import com.rapidminer.extension.pythonscripting.operator.PythonOperator;
import com.rapidminer.extension.pythonscripting.operator.PythonTransformer;
import com.rapidminer.extension.pythonscripting.parameter.ParameterTypeOperator;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dnd.DropBinaryEntryIntoProcessCallback;
import com.rapidminer.gui.flow.processrendering.view.ProcessRendererTransferHandler;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.repository.BinaryEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.gui.OpenBinaryEntryCallback;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public class PythonOperatorCallback
implements OpenBinaryEntryCallback,
DropBinaryEntryIntoProcessCallback {
    private static final Map<String, Class<? extends PythonOperator>> CLASS_MAP = new HashMap<String, Class<? extends PythonOperator>>(3);
    public static final Map<String, Set<String>> PARAMETER_MAP;
    public static final Map<String, Set<String>> STATIC_INPUT_MAP;
    public static final Map<String, Set<String>> STATIC_OUTPUT_MAP;

    public List<Operator> createAndConfigureOperatorsForDroppedEntry(BinaryEntry entry, Process process) throws OperatorCreationException {
        String formattedDeclaration;
        OperatorConfiguration configuration;
        try (InputStream in = entry.openInputStream();){
            configuration = ConfigurationTools.readOperatorConfiguration(in);
            String type = configuration.getType();
            ConfigurationTools.validate(configuration.getDeclaration(), PARAMETER_MAP.get(type), STATIC_INPUT_MAP.get(type), STATIC_OUTPUT_MAP.get(type));
            StringWriter writer = new StringWriter();
            ConfigurationTools.writeOperatorDeclaration(writer, configuration.getDeclaration());
            formattedDeclaration = writer.toString();
        }
        catch (RepositoryException | IOException e) {
            throw new OperatorCreationException(-1, entry.getName(), e);
        }
        Operator operator = OperatorService.createOperator(CLASS_MAP.get(configuration.getType()));
        OperatorDeclaration declaration = configuration.getDeclaration();
        String name = declaration.getName();
        if (name != null) {
            operator.rename(name);
        }
        operator.setParameter("operator", ParameterTypeOperator.encode(formattedDeclaration, configuration.getDefinition()));
        operator.setParameter("editable", Boolean.toString(declaration.isEditable()));
        return Collections.singletonList(operator);
    }

    public void triggerAction(BinaryEntry binaryEntry) {
    }

    public boolean willReturnOperator(BinaryEntry binaryEntry) {
        return true;
    }

    public void openEntry(BinaryEntry entry) {
        try {
            List<Operator> operators = this.createAndConfigureOperatorsForDroppedEntry(entry, null);
            ProcessRendererTransferHandler handler = (ProcessRendererTransferHandler)RapidMinerGUI.getMainFrame().getProcessPanel().getProcessRenderer().getTransferHandler();
            handler.dropNow(operators, null);
        }
        catch (OperatorCreationException | ClassCastException | NullPointerException e) {
            SwingUtilities.invokeLater(() -> PythonOperatorCallback.lambda$openEntry$0((Exception)e, entry));
            LogService.getRoot().log(Level.SEVERE, I18N.getGUIMessage((String)"gui.dialog.error.python_scripting.open_entry.message", (Object[])new Object[]{entry.getName(), e}));
        }
    }

    private static /* synthetic */ void lambda$openEntry$0(Exception e, BinaryEntry entry) {
        SwingTools.showSimpleErrorMessage((String)"python_scripting.open_entry", (Throwable)e, (Object[])new Object[]{entry.getName(), e});
    }

    static {
        CLASS_MAP.put("learner", PythonLearner.class);
        CLASS_MAP.put("transformer", PythonTransformer.class);
        CLASS_MAP.put("forecaster", PythonForecaster.class);
        PARAMETER_MAP = new HashMap<String, Set<String>>(3);
        PARAMETER_MAP.put("learner", PythonLearner.getStaticParameters());
        PARAMETER_MAP.put("transformer", PythonTransformer.getStaticParameters());
        PARAMETER_MAP.put("forecaster", PythonForecaster.getStaticParameters());
        STATIC_INPUT_MAP = new HashMap<String, Set<String>>(3);
        STATIC_INPUT_MAP.put("learner", PythonLearner.getStaticInputPorts());
        STATIC_INPUT_MAP.put("transformer", PythonTransformer.getStaticInputPorts());
        STATIC_INPUT_MAP.put("forecaster", PythonForecaster.getStaticInputPorts());
        STATIC_OUTPUT_MAP = new HashMap<String, Set<String>>(3);
        STATIC_OUTPUT_MAP.put("learner", PythonLearner.getStaticOutputPorts());
        STATIC_OUTPUT_MAP.put("transformer", PythonTransformer.getStaticOutputPorts());
        STATIC_OUTPUT_MAP.put("forecaster", PythonForecaster.getStaticOutputPorts());
    }
}

